/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.parameters;

import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.service.testcase.DatasetModificationService;

@RequestMapping(value={"/datasets"})
@Controller
public class DatasetController {
    private static final String DATASET_ID_URL = "/{datasetId}";
    @Inject
    private DatasetModificationService datasetModificationService;

    @RequestMapping(value={"/{datasetId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteDataset(@PathVariable long datasetId) {
        this.datasetModificationService.removeById(datasetId);
    }

    @RequestMapping(value={"/{datasetId}/name"}, method={RequestMethod.POST}, params={"value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String changeName(@PathVariable long datasetId, @RequestParam(value="value") String value) {
        this.datasetModificationService.changeName(datasetId, value);
        return value;
    }
}

