/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.keyword;

import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.service.actionword.ActionWordService;
import org.squashtest.tm.service.testcase.bdd.KeywordTestCaseService;

@Controller
@RequestMapping(value={"/keyword-test-cases"})
public class KeywordTestCaseController {
    @Inject
    private KeywordTestCaseService keywordTestCaseService;
    @Autowired(required=false)
    private ActionWordService actionWordService;

    @ResponseBody
    @RequestMapping(value={"/autocomplete"})
    public Collection<String> findAllMatchingActionWords(@RequestParam Long projectId, @RequestParam String searchInput) {
        return this.actionWordService.findAllMatchingActionWords(projectId.longValue(), searchInput);
    }

    @ResponseBody
    @RequestMapping(value={"/duplicated-action"})
    public Map<String, Long> findAllDuplicatedActionWithProject(@RequestParam long projectId, @RequestParam String inputActionWord) {
        return this.actionWordService.findAllDuplicatedActionWithProject(projectId, inputActionWord);
    }

    @ResponseBody
    @RequestMapping(value={"/{testCaseId}/generated-script"})
    public String getGeneratedScript(@PathVariable long testCaseId) {
        return this.keywordTestCaseService.writeScriptFromTestCase(testCaseId, true);
    }
}

