/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.importer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.service.batchimport.excel.TemplateMismatchException;
import org.squashtest.tm.service.importer.ImportLog;
import org.squashtest.tm.service.importer.ImportSummary;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.web.importer.ImportHelper;
import org.squashtest.tm.web.internal.controller.testcase.importer.ImportFormatFailure;
import org.squashtest.tm.web.internal.controller.testcase.importer.TestCaseImportLogHelper;

@Controller
@RequestMapping(value={"/test-cases/importer"})
public class TestCaseImportController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseImportController.class);
    private static final String SUMMARY = "summary";
    @Inject
    private TestCaseLibraryNavigationService navigationService;
    @Inject
    private TestCaseImportLogHelper logHelper;
    @Inject
    private ImportHelper importHelper;

    @RequestMapping(value={"/zip"}, method={RequestMethod.POST}, produces={"text/html"})
    public ModelAndView importZippedTestCases(@RequestParam(value="archive") MultipartFile archive, @RequestParam(value="projectId") long projectId, @RequestParam(value="zipEncoding") String zipEncoding) throws IOException {
        InputStream stream = archive.getInputStream();
        ModelAndView mav = new ModelAndView("fragment/import/import-summary");
        ImportSummary summary = this.navigationService.importZipTestCase(stream, projectId, zipEncoding);
        mav.addObject(SUMMARY, (Object)summary);
        mav.addObject("workspace", (Object)"test-case");
        return mav;
    }

    @RequestMapping(value={"/xls"}, method={RequestMethod.POST}, params={"dry-run"})
    public ModelAndView dryRunExcelWorkbook(@RequestParam(value="archive") MultipartFile uploadedFile, WebRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("dryRunExcelWorkbook");
        }
        return this.importWorkbook(uploadedFile, request, new Command<File, ImportLog>(){

            @Override
            public ImportLog execute(File xls) {
                return TestCaseImportController.this.navigationService.simulateImportExcelTestCase(xls);
            }
        });
    }

    private ModelAndView importWorkbook(MultipartFile uploadedFile, WebRequest request, Command<File, ImportLog> callback) {
        ModelAndView mav;
        block9: {
            mav = new ModelAndView("fragment/import/import-summary");
            File xls = null;
            try {
                xls = this.importHelper.multipartToImportFile(uploadedFile, "test-case-import-", ".xls");
                ImportLog summary = callback.execute(xls);
                summary.recompute();
                this.generateImportLog(request, summary);
                mav.addObject(SUMMARY, (Object)summary);
            }
            catch (IOException e) {
                LOGGER.error("An exception prevented processing of test-case import file", (Throwable)e);
                if (xls != null) {
                    xls.deleteOnExit();
                }
                break block9;
            }
            catch (TemplateMismatchException tme) {
                try {
                    ImportFormatFailure importFormatFailure = new ImportFormatFailure(tme);
                    mav.addObject(SUMMARY, (Object)importFormatFailure);
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (xls != null) {
                        xls.deleteOnExit();
                    }
                }
            }
            if (xls == null) break block9;
            xls.deleteOnExit();
        }
        mav.addObject("workspace", (Object)"test-case");
        return mav;
    }

    private void generateImportLog(WebRequest request, ImportLog summary) {
        File xlsSummary = null;
        try {
            try {
                xlsSummary = this.importLogToLogFile(summary);
                String reportUrl = String.valueOf(request.getContextPath()) + "/test-cases/import-logs/" + xlsSummary.getName();
                summary.setReportUrl(reportUrl);
            }
            catch (IOException e) {
                LOGGER.warn("An error occured during import log generation", (Throwable)e);
                if (xlsSummary != null) {
                    xlsSummary.deleteOnExit();
                }
            }
        }
        finally {
            if (xlsSummary != null) {
                xlsSummary.deleteOnExit();
            }
        }
    }

    private File importLogToLogFile(ImportLog summary) throws IOException {
        return this.logHelper.storeLogFile(summary);
    }

    @RequestMapping(value={"/xls"}, params={"!dry-run"}, method={RequestMethod.POST})
    public ModelAndView importExcelWorkbook(@RequestParam(value="archive") MultipartFile uploadedFile, WebRequest request) {
        return this.importWorkbook(uploadedFile, request, new Command<File, ImportLog>(){

            @Override
            public ImportLog execute(File xls) {
                return TestCaseImportController.this.navigationService.performImportExcelTestCase(xls);
            }
        });
    }

    private static interface Command<T, U> {
        public U execute(T var1);
    }
}

