/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.importer;

import java.io.File;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.web.internal.controller.testcase.importer.RequirementImportLogHelper;

@Controller
@RequestMapping(value={"/requirement/import-logs"})
public class RequirementImportLogController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementImportLogController.class);
    @Inject
    private RequirementImportLogHelper logHelper;

    @ResponseBody
    @RequestMapping(value={"/{filename:.+}"}, method={RequestMethod.GET})
    public FileSystemResource getExcelImportLog(@PathVariable String filename, HttpServletResponse response) {
        File logFile = this.logHelper.fetchLogFile(filename);
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + this.logHelper.logFilename(filename));
        return new FileSystemResource(logFile);
    }
}

