/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.importer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.service.batchimport.excel.ColumnMismatch;
import org.squashtest.tm.service.batchimport.excel.TemplateMismatchException;
import org.squashtest.tm.service.batchimport.excel.WorksheetFormatStatus;

public class ImportFormatFailure {
    private Map<ColumnMismatch, Set<String>> mismatches = new HashMap<ColumnMismatch, Set<String>>();

    public ImportFormatFailure(TemplateMismatchException tme) {
        this.fillMismatches(tme);
    }

    private void fillMismatches(TemplateMismatchException tme) {
        for (WorksheetFormatStatus wfs : tme.getWorksheetFormatStatuses()) {
            Map worksheetMismatches = wfs.getColumnNamesByMismatches();
            this.addAll(worksheetMismatches);
        }
    }

    private void addAll(Map<ColumnMismatch, Set<String>> worksheetMismatches) {
        for (Map.Entry<ColumnMismatch, Set<String>> columnMismatch : worksheetMismatches.entrySet()) {
            Set<String> columnNames = columnMismatch.getValue();
            Set<String> alreadyStoredColumnNames = this.mismatches.get(columnMismatch.getKey());
            if (alreadyStoredColumnNames == null) {
                alreadyStoredColumnNames = new HashSet<String>();
            }
            alreadyStoredColumnNames.addAll(columnNames);
            this.mismatches.put(columnMismatch.getKey(), alreadyStoredColumnNames);
        }
    }

    public Set<String> getDuplicateColumns() {
        return this.mismatches.get(ColumnMismatch.DUPLICATE);
    }

    public Set<String> getMissingMandatoryColumns() {
        return this.mismatches.get(ColumnMismatch.MISSING_MANDATORY);
    }

    public String getStatus() {
        return "Format KO";
    }
}

