/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.executions;

import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.Pagings;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.IsScriptedTestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.service.execution.ExecutionFinder;
import org.squashtest.tm.service.testcase.TestCaseFinder;
import org.squashtest.tm.web.internal.controller.testcase.executions.ExecutionsTableModelBuilder;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableSorting;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
@RequestMapping(value={"/test-cases/{testCaseId}/executions"})
public class TestCaseExecutionsController {
    private static final String NAME = "name";
    private final DatatableMapper<String> execsTableMapper = new NameBasedMapper().mapAttribute("project-name", "name", Project.class).mapAttribute("campaign-name", "name", Campaign.class).mapAttribute("iteration-name", "name", Iteration.class).mapAttribute("exec-name", "name", Execution.class).mapAttribute("exec-mode", "executionMode", Execution.class).mapAttribute("test-suite-name", "name", TestSuite.class).mapAttribute("exec-status", "executionStatus", Execution.class).mapAttribute("last-exec-by", "lastExecutedBy", Execution.class).mapAttribute("last-exec-on", "lastExecutedOn", Execution.class).mapAttribute("dataset", "datasetLabel", Execution.class);
    private ExecutionFinder executionFinder;
    @Inject
    private TestCaseFinder testCaseFinder;
    @Inject
    private InternationalizationHelper internationalizationHelper;

    @Inject
    public void setExecutionFinder(ExecutionFinder executionFinder) {
        this.executionFinder = executionFinder;
    }

    @RequestMapping(method={RequestMethod.GET}, params={"tab"})
    public String getExecutionsTab(@PathVariable long testCaseId, Model model) {
        Paging paging = Pagings.DEFAULT_PAGING;
        List executions = this.executionFinder.findAllByTestCaseIdOrderByRunDate(testCaseId, paging);
        TestCase testCase = this.testCaseFinder.findById(testCaseId);
        IsScriptedTestCaseVisitor visitor = new IsScriptedTestCaseVisitor();
        testCase.accept((TestCaseVisitor)visitor);
        model.addAttribute("isTcScripted", (Object)visitor.isScripted());
        model.addAttribute("executionsPageSize", (Object)paging.getPageSize());
        model.addAttribute("testCaseId", (Object)testCaseId);
        model.addAttribute("execs", (Object)executions);
        return "test-cases-tabs/executions-tab.html";
    }

    @RequestMapping(params={"sEcho"})
    @ResponseBody
    public DataTableModel getExecutionsTableModel(@PathVariable long testCaseId, DataTableDrawParameters params, Locale locale) {
        PagingAndSorting pas = this.createPagingAndSorting(params);
        PagedCollectionHolder executions = this.executionFinder.findAllByTestCaseId(testCaseId, pas);
        return new ExecutionsTableModelBuilder(locale, this.internationalizationHelper).buildDataModel(executions, params.getsEcho());
    }

    private PagingAndSorting createPagingAndSorting(DataTableDrawParameters params) {
        return new DataTableSorting(params, this.execsTableMapper);
    }
}

