/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase.executions;

import java.util.HashMap;
import java.util.Locale;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.web.internal.controller.campaign.TestSuiteHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

class ExecutionsTableModelBuilder
extends DataTableModelBuilder<Execution> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionsTableModelBuilder.class);
    private final Locale locale;
    private final InternationalizationHelper i18nHelper;

    public ExecutionsTableModelBuilder(@NotNull Locale locale, @NotNull InternationalizationHelper i18nHelper) {
        this.locale = locale;
        this.i18nHelper = i18nHelper;
    }

    @Override
    protected Object buildItemData(Execution item) {
        IterationTestPlanItem testPlanItem = item.getTestPlan();
        Iteration iteration = testPlanItem.getIteration();
        HashMap<String, Object> data = new HashMap<String, Object>(12);
        data.put("exec-id", item.getId());
        data.put("project-name", HtmlUtils.htmlEscape((String)iteration.getProject().getName()));
        data.put("campaign-name", HtmlUtils.htmlEscape((String)iteration.getCampaign().getName()));
        data.put("iteration-name", HtmlUtils.htmlEscape((String)iteration.getName()));
        data.put("exec-name", String.valueOf(HtmlUtils.htmlEscape((String)item.getName())) + " (Exec.#" + (1 + item.getExecutionOrder()) + ")");
        data.put("exec-mode", this.translate((Internationalizable)item.getExecutionMode()));
        data.put("test-suite-name", HtmlUtils.htmlEscape((String)this.testSuiteNameList(testPlanItem)));
        data.put("raw-exec-status", item.getExecutionStatus().name());
        data.put("exec-status", this.translate((Internationalizable)item.getExecutionStatus()));
        data.put("last-exec-by", HTMLCleanupUtils.escapeOrDefault(item.getLastExecutedBy(), null));
        data.put("last-exec-on", this.i18nHelper.localizeShortDate(item.getLastExecutedOn(), this.locale));
        data.put("dataset", HtmlUtils.htmlEscape((String)this.formatDatasetName(item)));
        return data;
    }

    private String testSuiteNameList(IterationTestPlanItem item) {
        return TestSuiteHelper.buildEllipsedSuiteNameList(item.getTestSuites(), 20);
    }

    private String formatDatasetName(Execution exec) {
        String dsLabel = exec.getDatasetLabel();
        if (!StringUtils.isBlank((CharSequence)dsLabel)) {
            return dsLabel;
        }
        return this.i18nHelper.internationalize("label.noneDS", this.locale);
    }

    private String translate(Internationalizable i18nable) {
        return this.i18nHelper.internationalize(i18nable, this.locale);
    }
}

