/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase;

import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.service.library.WorkspaceService;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.generic.WorkspaceController;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;
import org.squashtest.tm.web.internal.model.rest.RestLibrary;

@Controller
@RequestMapping(value={"/test-case-workspace"})
public class TestCaseWorkspaceController
extends WorkspaceController<TestCaseLibraryNode> {
    @Inject
    private TestCaseLibraryNavigationService testCaseLibraryNavigationService;
    @Inject
    @Named(value="squashtest.tm.service.TestCasesWorkspaceService")
    private WorkspaceService<TestCaseLibrary> workspaceService;
    @Inject
    @Named(value="testCaseWorkspaceDisplayService")
    private WorkspaceDisplayService testCaseWorkspaceDisplayService;
    @Inject
    @Named(value="testCase.driveNodeBuilder")
    private Provider<DriveNodeBuilder<TestCaseLibraryNode>> driveNodeBuilderProvider;

    @Override
    protected WorkspaceService<TestCaseLibrary> getWorkspaceService() {
        return this.workspaceService;
    }

    @Override
    protected String getWorkspaceViewName() {
        return "test-case-workspace.html";
    }

    @Override
    protected WorkspaceType getWorkspaceType() {
        return null;
    }

    @Override
    protected void populateModel(Model model, Locale locale) {
        List<RestLibrary> libraries = this.getEditableLibraries(model);
        model.addAttribute("editableLibraries", libraries);
    }

    @Override
    protected Provider<DriveNodeBuilder<TestCaseLibraryNode>> driveNodeBuilderProvider() {
        return this.driveNodeBuilderProvider;
    }

    @Override
    protected WorkspaceDisplayService workspaceDisplayService() {
        return this.testCaseWorkspaceDisplayService;
    }

    @Override
    protected String[] getNodeParentsInWorkspace(EntityReference entityReference) {
        List parents = this.testCaseLibraryNavigationService.getParentNodesAsStringList(entityReference.getId());
        return parents.toArray(new String[parents.size()]);
    }

    @Override
    protected String getTreeElementIdInWorkspace(EntityReference entityReference) {
        return "TestCase-" + entityReference.getId();
    }
}

