/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.api.plugin.PluginType;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.core.foundation.collection.DefaultPagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.SinglePageCollectionHolder;
import org.squashtest.tm.core.foundation.collection.SortOrder;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.IdentifiedUtil;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.bugtracker.IssueOwnership;
import org.squashtest.tm.domain.bugtracker.RemoteIssueDecorator;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.RenderingLocation;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.project.LibraryPluginBinding;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.servers.AuthenticationStatus;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.GetKindTestCaseVisitor;
import org.squashtest.tm.domain.testcase.IsKeywordTestCaseVisitor;
import org.squashtest.tm.domain.testcase.IsScriptedTestCaseVisitor;
import org.squashtest.tm.domain.testcase.IsStandardTestCaseVisitor;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.domain.tf.automationrequest.RemoteAutomationRequestExtender;
import org.squashtest.tm.exception.UnknownEntityException;
import org.squashtest.tm.exception.tf.WrongPriorityFormatException;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.customfield.CustomFieldHelper;
import org.squashtest.tm.service.customfield.CustomFieldHelperService;
import org.squashtest.tm.service.execution.ExecutionFinder;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.internal.dto.CustomFieldJsonConverter;
import org.squashtest.tm.service.internal.dto.CustomFieldModel;
import org.squashtest.tm.service.internal.dto.json.JsonInfoList;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.requirement.VerifiedRequirementsManagerService;
import org.squashtest.tm.service.scmserver.ScmRepositoryManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testautomation.AutomatedTestTechnologyFinderService;
import org.squashtest.tm.service.testcase.ParameterFinder;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.service.testcase.scripted.ScriptedTestCaseFinder;
import org.squashtest.tm.service.tf.AutomationRequestModificationService;
import org.squashtest.tm.web.internal.controller.bugtracker.BugTrackerControllerHelper;
import org.squashtest.tm.web.internal.controller.generic.ServiceAwareAttachmentTableModelHelper;
import org.squashtest.tm.web.internal.controller.milestone.MetaMilestone;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestonePanelConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.controller.milestone.TestCaseBoundMilestoneTableModelHelper;
import org.squashtest.tm.web.internal.controller.testcase.CallingTestCasesTableModelBuilder;
import org.squashtest.tm.web.internal.controller.testcase.TestCaseImportanceJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.controller.testcase.TestCaseStatusJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.controller.testcase.parameters.ParameterNameComparator;
import org.squashtest.tm.web.internal.controller.testcase.parameters.ParametersModelHelper;
import org.squashtest.tm.web.internal.controller.testcase.parameters.TestCaseDatasetsController;
import org.squashtest.tm.web.internal.controller.testcase.steps.TestStepsTableModelBuilder;
import org.squashtest.tm.web.internal.helper.InternationalizableLabelFormatter;
import org.squashtest.tm.web.internal.helper.LevelLabelFormatter;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.JsonInfoListBuilder;
import org.squashtest.tm.web.internal.model.combo.OptionTag;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableSorting;
import org.squashtest.tm.web.internal.model.jquery.RenameModel;
import org.squashtest.tm.web.internal.model.json.JsonAutomationRequest;
import org.squashtest.tm.web.internal.model.json.JsonEnumValue;
import org.squashtest.tm.web.internal.model.json.JsonGeneralInfo;
import org.squashtest.tm.web.internal.model.json.JsonTestCase;
import org.squashtest.tm.web.internal.model.json.JsonTestCaseBuilder;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/test-cases/{testCaseId}"})
public class TestCaseModificationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseModificationController.class);
    private static final String NAME = "name";
    private static final String OPTIMIZED = "optimized";
    private static final String TEST_CASE = "testCase";
    private static final String TEST_SPACE_CASE = "test case ";
    private static final String TEST_CASE_ID = "testCaseId";
    private static final String FINAL_STATE = "finalState";
    private static final String SQUASHTM_NODATA = "squashtm.nodata";
    private final DatatableMapper<String> referencingTestCaseMapper = new NameBasedMapper(6).mapAttribute("project-name", "name", Project.class).mapAttribute("tc-reference", "reference", TestCase.class).mapAttribute("tc-name", "name", TestCase.class).mapAttribute("tc-mode", "executionMode", TestCase.class);
    @Inject
    private TestCaseModificationService testCaseModificationService;
    @Inject
    private ExecutionFinder executionFinder;
    @Inject
    private ParameterFinder parameterFinder;
    @Inject
    private VerifiedRequirementsManagerService verifiedRequirementsManagerService;
    @Inject
    private MessageSource messageSource;
    @Inject
    private InternationalizationHelper internationalizationHelper;
    @Inject
    private Provider<TestCaseImportanceJeditableComboDataBuilder> importanceComboBuilderProvider;
    @Inject
    private BugTrackersLocalService bugTrackersLocalService;
    @Inject
    private ServiceAwareAttachmentTableModelHelper attachmentHelper;
    @Inject
    private InfoListItemFinderService infoListItemService;
    @Inject
    private CustomFieldHelperService cufHelperService;
    @Inject
    private CustomFieldJsonConverter converter;
    @Inject
    private Provider<TestCaseStatusJeditableComboDataBuilder> statusComboBuilderProvider;
    @Inject
    private Provider<LevelLabelFormatter> levelLabelFormatterProvider;
    @Inject
    private Provider<InternationalizableLabelFormatter> labelFormatter;
    @Inject
    private JsonInfoListBuilder infoListBuilder;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    @Inject
    private Provider<JsonTestCaseBuilder> builder;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private AutomationRequestModificationService automationRequestModificationService;
    @Inject
    private GenericProjectManagerService projectManager;
    @Inject
    private ScriptedTestCaseFinder scriptedTestCaseFinder;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private AutomatedTestTechnologyFinderService automatedTestTechnologyFinder;
    @Inject
    ScmRepositoryManagerService scmRepositoryManagerService;

    @RequestMapping(method={RequestMethod.GET})
    public final ModelAndView showTestCase(@PathVariable long testCaseId, Locale locale) {
        ModelAndView mav = new ModelAndView("fragment/test-cases/test-case");
        TestCase testCase = this.testCaseModificationService.findById(testCaseId);
        this.populateModelWithTestCaseEditionData(mav, testCase, locale);
        return mav;
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public ModelAndView showTestCaseInfo(@PathVariable long testCaseId, Locale locale) {
        LOGGER.trace("TestCaseModificationController : getting infos");
        ModelAndView mav = new ModelAndView("page/test-case-workspace/show-test-case");
        TestCase testCase = this.testCaseModificationService.findTestCaseWithSteps(testCaseId);
        this.populateModelWithTestCaseEditionData(mav, testCase, locale);
        return mav;
    }

    @RequestMapping(value={"/edit-from-exec/{execId}"}, method={RequestMethod.GET}, params={"optimized"})
    public ModelAndView editTestCaseFromExecution(@PathVariable long testCaseId, Locale locale, @PathVariable long execId, @RequestParam(value="optimized") boolean optimized) {
        ModelAndView mav = new ModelAndView("page/test-case-workspace/edit-test-case-from-exec");
        TestCase testCase = this.testCaseModificationService.findTestCaseWithSteps(testCaseId);
        this.populateModelWithTestCaseEditionData(mav, testCase, locale);
        mav.addObject("execId", (Object)execId);
        mav.addObject("isIEO", (Object)optimized);
        return mav;
    }

    private void populateModelWithTestCaseEditionData(ModelAndView mav, TestCase testCase, Locale locale) {
        boolean hasCUF = this.cufHelperService.hasCustomFields((BoundEntity)testCase);
        String finalStatusConfiged = null;
        boolean remoteAutomReqExists = false;
        ArrayList<OptionTag> executionModes = new ArrayList<OptionTag>();
        TestCaseExecutionMode[] testCaseExecutionModeArray = TestCaseExecutionMode.values();
        int n = testCaseExecutionModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestCaseExecutionMode executionMode = testCaseExecutionModeArray[n2];
            OptionTag ot = new OptionTag();
            ot.setLabel(this.formatExecutionMode(executionMode, locale));
            ot.setValue(executionMode.toString());
            executionModes.add(ot);
            ++n2;
        }
        mav.addObject(TEST_CASE, (Object)testCase);
        IsScriptedTestCaseVisitor isScriptedTestCaseVisitor = new IsScriptedTestCaseVisitor();
        testCase.accept((TestCaseVisitor)isScriptedTestCaseVisitor);
        boolean isScriptedTestCase = isScriptedTestCaseVisitor.isScripted();
        mav.addObject("isScriptedTestCase", (Object)isScriptedTestCase);
        if (isScriptedTestCase) {
            ScriptedTestCase scriptedTestCase = this.scriptedTestCaseFinder.findById(testCase.getId().longValue());
            mav.addObject("scriptContent", (Object)scriptedTestCase.getScript());
        }
        IsKeywordTestCaseVisitor isKeywordTestCaseVisitor = new IsKeywordTestCaseVisitor();
        testCase.accept((TestCaseVisitor)isKeywordTestCaseVisitor);
        mav.addObject("isKeywordTestCase", (Object)isKeywordTestCaseVisitor.isKeyword());
        mav.addObject("executionModes", executionModes);
        mav.addObject("testCaseImportanceComboJson", (Object)this.buildImportanceComboData(locale));
        mav.addObject("testCaseImportanceLabel", (Object)this.formatImportance(testCase.getImportance(), locale));
        mav.addObject("testCaseNatures", (Object)this.buildNatureComboData(testCase.getId()));
        mav.addObject("testCaseTypes", (Object)this.buildTypeComboData(testCase.getId()));
        mav.addObject("testCaseStatusComboJson", (Object)this.buildStatusComboData(locale));
        mav.addObject("testCaseStatusLabel", (Object)this.formatStatus(testCase.getStatus(), locale));
        mav.addObject("automReqStatusComboJson", (Object)this.buildAutomReqStatusComboData(locale));
        mav.addObject("automReqStatusLabel", (Object)this.formatAutomReqStatus(testCase.getAutomationRequest(), locale));
        mav.addObject("attachmentsModel", (Object)this.attachmentHelper.findPagedAttachments((AttachmentHolder)testCase));
        mav.addObject("callingTestCasesModel", (Object)this.getCallingTestCaseTableModel((long)testCase.getId(), (PagingAndSorting)new DefaultPagingAndSorting("TestCase.name"), ""));
        mav.addObject("hasCUF", (Object)hasCUF);
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(testCase);
        mav.addObject("milestoneConf", (Object)milestoneConf);
        mav.addObject("hasProjectWithTaServer", (Object)(testCase.getProject().getTestAutomationServer() != null ? 1 : 0));
        mav.addObject("automatedTestTechnologies", (Object)this.automatedTestTechnologyFinder.getAllAvailableAutomatedTestTechnology());
        mav.addObject("scmRepositoryList", (Object)this.scmRepositoryManagerService.getAllDeclaredScmRepositories(locale));
        String workflowType = testCase.getProject().getAutomationWorkflowType().getI18nKey();
        Boolean isRemoteAutomationWorkflowUsed = this.projectManager.isProjectUsingWorkflow(testCase.getProject().getId().longValue());
        mav.addObject("isRemoteAutomationWorkflowUsed", (Object)isRemoteAutomationWorkflowUsed);
        if (workflowType.equals(AutomationWorkflowType.REMOTE_WORKFLOW.getI18nKey())) {
            LibraryPluginBinding lpb = this.projectDao.findPluginForProject(testCase.getProject().getId(), PluginType.AUTOMATION);
            Map pluginConfiguration = this.projectManager.getPluginConfigurationWithoutCheck(testCase.getProject().getId().longValue(), WorkspaceType.TEST_CASE_WORKSPACE, lpb.getPluginId());
            finalStatusConfiged = (String)pluginConfiguration.get(FINAL_STATE);
            AutomationRequest automReq = testCase.getAutomationRequest();
            if (automReq != null) {
                boolean bl = remoteAutomReqExists = automReq.getRemoteAutomationRequestExtender() != null;
                if (remoteAutomReqExists) {
                    remoteAutomReqExists = automReq.getRemoteAutomationRequestExtender() != null;
                    RemoteAutomationRequestExtender remoteAutomReq = automReq.getRemoteAutomationRequestExtender();
                    mav.addObject("remoteReqUrl", (Object)this.formatRemoteReqUrl(remoteAutomReq, locale));
                    mav.addObject("remoteIssueKey", (Object)remoteAutomReq.getRemoteIssueKey());
                    mav.addObject("remoteReqAssignedTo", (Object)(!StringUtils.isBlank((String)remoteAutomReq.getRemoteAssignedTo()) ? remoteAutomReq.getRemoteAssignedTo() : this.internationalizationHelper.internationalize(SQUASHTM_NODATA, locale)));
                    mav.addObject("remoteReqStatusLabel", (Object)this.formatRemoteReqStatus(remoteAutomReq, locale));
                    mav.addObject("automReqLastTransmittedOn", automReq.getTransmissionDate() != null ? automReq.getTransmissionDate() : this.internationalizationHelper.internationalize(SQUASHTM_NODATA, locale));
                    mav.addObject("automatedTestCase", (Object)(remoteAutomReq.getRemoteRequestStatus().equals(finalStatusConfiged) ? this.internationalizationHelper.internationalize("label.Yes", locale) : (remoteAutomReq.getRemoteRequestStatus() == null ? this.internationalizationHelper.internationalize(SQUASHTM_NODATA, locale) : this.internationalizationHelper.internationalize("label.No", locale))));
                    mav.addObject("finalStatusConfiged", (Object)finalStatusConfiged);
                    mav.addObject("synchronizableIssueStatus", (Object)remoteAutomReq.getSynchronizableIssueStatus().name());
                }
            } else {
                mav.addObject("remoteReqUrl", (Object)this.internationalizationHelper.internationalize(SQUASHTM_NODATA, locale));
                mav.addObject("remoteReqAssignedTo", (Object)this.internationalizationHelper.internationalize(SQUASHTM_NODATA, locale));
                mav.addObject("remoteReqStatusLabel", (Object)this.internationalizationHelper.internationalize(SQUASHTM_NODATA, locale));
                mav.addObject("automatedTestCase", (Object)this.internationalizationHelper.internationalize(SQUASHTM_NODATA, locale));
                mav.addObject("automReqLastTransmittedOn", null);
                mav.addObject("finalStatusConfiged", (Object)finalStatusConfiged);
                mav.addObject("synchronizableIssueStatus", (Object)"");
            }
        }
        mav.addObject("remoteAutomationRequestExists", (Object)remoteAutomReqExists);
    }

    @RequestMapping(value={"/importance-combo-data"}, method={RequestMethod.GET})
    @ResponseBody
    public String buildImportanceComboData(Locale locale) {
        return ((TestCaseImportanceJeditableComboDataBuilder)((TestCaseImportanceJeditableComboDataBuilder)this.importanceComboBuilderProvider.get()).useLocale(locale)).buildMarshalled();
    }

    @RequestMapping(value={"/nature-combo-data"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonInfoList buildNatureComboData(@PathVariable(value="testCaseId") Long testCaseId) {
        TestCase testCase = this.testCaseModificationService.findById(testCaseId.longValue());
        return this.infoListBuilder.toJson(testCase.getProject().getTestCaseNatures());
    }

    @RequestMapping(value={"/type-combo-data"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonInfoList buildTypeComboData(@PathVariable(value="testCaseId") Long testCaseId) {
        TestCase testCase = this.testCaseModificationService.findById(testCaseId.longValue());
        return this.infoListBuilder.toJson(testCase.getProject().getTestCaseTypes());
    }

    @RequestMapping(value={"/status-combo-data"}, method={RequestMethod.GET})
    @ResponseBody
    private String buildStatusComboData(Locale locale) {
        return ((TestCaseStatusJeditableComboDataBuilder)((TestCaseStatusJeditableComboDataBuilder)this.statusComboBuilderProvider.get()).useLocale(locale)).buildMarshalled();
    }

    private String formatExecutionMode(TestCaseExecutionMode mode, Locale locale) {
        return this.internationalizationHelper.internationalize((Internationalizable)mode, locale);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=test-case-description", "value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String changeDescription(@RequestParam(value="value") String testCaseDescription, @PathVariable long testCaseId) {
        this.testCaseModificationService.changeDescription(testCaseId, testCaseDescription);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(TEST_SPACE_CASE + testCaseId + ": updated description to " + testCaseDescription);
        }
        return HTMLCleanupUtils.cleanHtml(testCaseDescription);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=test-case-automatable", "value"})
    @ResponseBody
    public String changeAutomatable(@RequestParam(value="value") TestCaseAutomatable testCaseAutomatable, @PathVariable long testCaseId, Locale locale) {
        String newAutomatable = "";
        boolean allowAutomationWorkflow = this.testCaseModificationService.changeAutomatable(testCaseAutomatable, Long.valueOf(testCaseId));
        newAutomatable = allowAutomationWorkflow ? this.formatAutomatable(testCaseAutomatable, locale) : "-";
        return newAutomatable;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=automation-request-priority", "value"})
    @ResponseBody
    public String changePriority(@RequestParam(value="value") String priority, @PathVariable long testCaseId, Locale locale) {
        try {
            Integer newPriority = priority.isEmpty() ? null : Integer.valueOf(Integer.parseInt(priority));
            this.automationRequestModificationService.changePriority(Collections.singletonList(testCaseId), newPriority);
            return newPriority != null ? newPriority.toString() : "";
        }
        catch (NumberFormatException nfe) {
            throw new WrongPriorityFormatException((Exception)nfe);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=automation-request-status", "value"})
    @ResponseBody
    public String changeAutomReqStatus(@RequestParam(value="value") AutomationRequestStatus status, @PathVariable long testCaseId, Locale locale) {
        this.automationRequestModificationService.changeStatus(Collections.singletonList(testCaseId), status);
        return this.internationalizationHelper.internationalize((Internationalizable)status, locale);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/automation-request"}, params={"id=automation-request-info"})
    @ResponseBody
    public JsonAutomationRequest getAutomationRequestInfo(@PathVariable long testCaseId) {
        return new JsonAutomationRequest(this.automationRequestModificationService.findRequestByTestCaseId(testCaseId), this.internationalizationHelper);
    }

    @RequestMapping(value={"/associate-TA-script"}, method={RequestMethod.POST})
    @ResponseBody
    public void resolveTAScriptAssociation(@PathVariable long testCaseId) {
        this.automationRequestModificationService.updateTAScript(Collections.singletonList(testCaseId));
    }

    @ResponseBody
    @RequestMapping(value={"/new-version"}, method={RequestMethod.GET})
    public JsonTestCase getNewVersionTemplate(@PathVariable(value="testCaseId") Long testCaseId) {
        TestCase testCase = this.testCaseModificationService.findById(testCaseId.longValue());
        return ((JsonTestCaseBuilder)this.builder.get()).extended().entities(Arrays.asList(testCase)).toJson().get(0);
    }

    @ResponseBody
    @RequestMapping(value={"/new-version"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public JsonTestCase createNewVersion(@PathVariable(value="testCaseId") Long originalId, @RequestBody TestCase newVersionData) {
        TestCase newTestCase = this.testCaseModificationService.addNewTestCaseVersion(originalId.longValue(), newVersionData);
        JsonTestCase jsTestCase = new JsonTestCase();
        jsTestCase.setId(newTestCase.getId());
        jsTestCase.setName(newTestCase.getName());
        return jsTestCase;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=test-case-reference", "value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String changeReference(@RequestParam(value="value") String testCaseReference, @PathVariable long testCaseId) {
        testCaseReference = testCaseReference.substring(0, Math.min(testCaseReference.length(), 50));
        this.testCaseModificationService.changeReference(testCaseId, testCaseReference);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(TEST_SPACE_CASE + testCaseId + ": updated reference to " + testCaseReference);
        }
        return HtmlUtils.htmlEscape((String)testCaseReference);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, params={"id=test-case-importance", "value"})
    public String changeImportance(@PathVariable long testCaseId, @RequestParam(value="value") TestCaseImportance importance, Locale locale) {
        this.testCaseModificationService.changeImportance(testCaseId, importance);
        return this.formatImportance(importance, locale);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=test-case-nature", "value"})
    @ResponseBody
    public String changeNature(@PathVariable long testCaseId, @RequestParam(value="value") String nature, Locale locale) {
        this.testCaseModificationService.changeNature(testCaseId, nature);
        InfoListItem newNature = this.infoListItemService.findByCode(nature);
        return this.formatInfoItem(newNature, locale);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=test-case-newname", "value"})
    @ResponseBody
    public Object changeName(@PathVariable long testCaseId, @RequestParam(value="value") String newName) {
        this.testCaseModificationService.rename(testCaseId, newName);
        LOGGER.info("TestCaseModificationController : renaming {} as {}", (Object)testCaseId, (Object)newName);
        return HtmlUtils.htmlEscape((String)newName);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=test-case-type", "value"})
    @ResponseBody
    public String changeType(@PathVariable long testCaseId, @RequestParam(value="value") String type, Locale locale) {
        this.testCaseModificationService.changeType(testCaseId, type);
        InfoListItem newType = this.infoListItemService.findByCode(type);
        return this.formatInfoItem(newType, locale);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, params={"id=test-case-source-code-repository-url", "value"}, produces={"text/plain;charset=UTF-8"})
    public String changeScmRepository(@RequestParam(value="value") Long scmRepositoryId, @PathVariable long testCaseId, Locale locale) {
        if (scmRepositoryId.equals(0L)) {
            this.testCaseModificationService.unbindSourceCodeRepository(testCaseId);
            return this.internationalizationHelper.internationalize("label.None", locale);
        }
        String newScmRepositoryUrl = this.testCaseModificationService.changeSourceCodeRepository(testCaseId, scmRepositoryId.longValue());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(TEST_SPACE_CASE + testCaseId + ": updated git repository to " + newScmRepositoryUrl);
        }
        return newScmRepositoryUrl;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=test-case-automated-test-reference", "value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String changeAutomatedTestReference(@RequestParam(value="value") String testCaseAutomatedTestReference, @PathVariable long testCaseId) {
        testCaseAutomatedTestReference = testCaseAutomatedTestReference.substring(0, Math.min(testCaseAutomatedTestReference.length(), 255));
        this.testCaseModificationService.changeAutomatedTestReference(testCaseId, testCaseAutomatedTestReference);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(TEST_SPACE_CASE + testCaseId + ": updated automated test reference to " + testCaseAutomatedTestReference);
        }
        return HtmlUtils.htmlEscape((String)testCaseAutomatedTestReference);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=test-case-automated-test-technology", "value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String changeAutomatedTestTechnology(@RequestParam(value="value") long testCaseAutomatedTestTechnologyId, @PathVariable long testCaseId) {
        this.testCaseModificationService.changeAutomatedTestTechnology(testCaseId, testCaseAutomatedTestTechnologyId);
        return Long.toString(testCaseAutomatedTestTechnologyId);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, params={"id=test-case-status", "value"})
    public String changeStatus(@PathVariable long testCaseId, @RequestParam(value="value") TestCaseStatus status, Locale locale) {
        this.testCaseModificationService.changeStatus(testCaseId, status);
        return this.formatStatus(status, locale);
    }

    @RequestMapping(value={"/importanceAuto"}, method={RequestMethod.POST}, params={"importanceAuto"})
    @ResponseBody
    public JsonEnumValue changeImportanceAuto(@PathVariable long testCaseId, @RequestParam(value="importanceAuto") boolean auto, Locale locale) {
        this.testCaseModificationService.changeImportanceAuto(testCaseId, auto);
        TestCase testCase = this.testCaseModificationService.findById(testCaseId);
        return new JsonEnumValue(testCase.getImportance().toString(), this.formatImportance(testCase.getImportance(), locale));
    }

    @GetMapping(value={"/prerequisite"})
    @ResponseBody
    public String getTestCasePrerequisite(@PathVariable long testCaseId) {
        String testCasePrerequisite = this.testCaseModificationService.getPrerequisite(testCaseId);
        return HTMLCleanupUtils.cleanHtml(testCasePrerequisite);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=test-case-prerequisite", "value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String changePrerequisite(@RequestParam(value="value") String testCasePrerequisite, @PathVariable long testCaseId) {
        this.testCaseModificationService.changePrerequisite(testCaseId, testCasePrerequisite);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(TEST_SPACE_CASE + testCaseId + ": updated prerequisite to " + testCasePrerequisite);
        }
        this.testCaseModificationService.addParametersFromPrerequisite(testCaseId);
        return HTMLCleanupUtils.cleanHtml(testCasePrerequisite);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"newName"})
    @ResponseBody
    public Object changeName(HttpServletResponse response, @PathVariable long testCaseId, @RequestParam String newName) {
        this.testCaseModificationService.rename(testCaseId, newName);
        LOGGER.info("TestCaseModificationController : renaming {} as {}", (Object)testCaseId, (Object)newName);
        return new RenameModel(newName);
    }

    @ResponseBody
    @RequestMapping(value={"/importance"}, method={RequestMethod.GET})
    public String getImportance(@PathVariable long testCaseId, Locale locale) {
        TestCase testCase = this.testCaseModificationService.findById(testCaseId);
        TestCaseImportance importance = testCase.getImportance();
        return this.formatImportance(importance, locale);
    }

    @ResponseBody
    @RequestMapping(value={"/nature"}, method={RequestMethod.GET})
    public String getNature(@PathVariable long testCaseId, Locale locale) {
        TestCase testCase = this.testCaseModificationService.findById(testCaseId);
        InfoListItem nature = testCase.getNature();
        return this.formatInfoItem(nature, locale);
    }

    @ResponseBody
    @RequestMapping(value={"/type"}, method={RequestMethod.GET})
    public String getType(@PathVariable long testCaseId, Locale locale) {
        TestCase testCase = this.testCaseModificationService.findById(testCaseId);
        InfoListItem type = testCase.getType();
        return this.formatInfoItem(type, locale);
    }

    @ResponseBody
    @RequestMapping(value={"/status"}, method={RequestMethod.GET})
    public String getStatus(@PathVariable long testCaseId, Locale locale) {
        TestCase testCase = this.testCaseModificationService.findById(testCaseId);
        TestCaseStatus status = testCase.getStatus();
        return this.formatStatus(status, locale);
    }

    private String formatImportance(TestCaseImportance importance, Locale locale) {
        return ((LevelLabelFormatter)this.levelLabelFormatterProvider.get()).useLocale(locale).formatLabel((Level)importance);
    }

    private String formatInfoItem(InfoListItem nature, Locale locale) {
        String item = this.internationalizationHelper.getMessage(nature.getLabel(), null, nature.getLabel(), locale);
        return HtmlUtils.htmlEscape((String)item);
    }

    private String formatStatus(TestCaseStatus status, Locale locale) {
        return ((LevelLabelFormatter)this.levelLabelFormatterProvider.get()).useLocale(locale).formatLabel((Level)status);
    }

    private String formatAutomatable(TestCaseAutomatable automatable, Locale locale) {
        return ((LevelLabelFormatter)this.levelLabelFormatterProvider.get()).useLocale(locale).formatLabel((Level)automatable);
    }

    @RequestMapping(value={"/general"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JsonGeneralInfo refreshGeneralInfos(@PathVariable long testCaseId) {
        TestCase testCase = this.testCaseModificationService.findById(testCaseId);
        return new JsonGeneralInfo((AuditableMixin)testCase);
    }

    @RequestMapping(value={"/calling-test-cases/table"}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getCallingTestCaseTableModel(@PathVariable long testCaseId, DataTableDrawParameters params, Locale locale) {
        LOGGER.trace("TestCaseModificationController: getCallingTestCaseTableModel called ");
        PagingAndSorting paging = this.createPaging(params, this.referencingTestCaseMapper);
        return this.getCallingTestCaseTableModel(testCaseId, paging, params.getsEcho());
    }

    private DataTableModel getCallingTestCaseTableModel(long testCaseId, PagingAndSorting paging, String sEcho) {
        PagedCollectionHolder holder = this.testCaseModificationService.findCallingTestSteps(testCaseId, paging);
        return new CallingTestCasesTableModelBuilder(this.internationalizationHelper).buildDataModel(holder, sEcho);
    }

    @RequestMapping(value={"/milestones"}, method={RequestMethod.GET})
    @ResponseBody
    public DataTableModel getBoundMilestones(@PathVariable long testCaseId, DataTableDrawParameters params) {
        Collection allMilestones = this.testCaseModificationService.findAllMilestones(testCaseId);
        return this.buildMilestoneTableModel(testCaseId, allMilestones, params.getsEcho());
    }

    @RequestMapping(value={"/milestones/{milestoneIds}"}, method={RequestMethod.POST})
    @ResponseBody
    public void bindMilestones(@PathVariable long testCaseId, @PathVariable(value="milestoneIds") List<Long> milestoneIds) {
        this.testCaseModificationService.bindMilestones(testCaseId, milestoneIds);
    }

    @RequestMapping(value={"/milestones/{milestoneIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void unbindMilestones(@PathVariable long testCaseId, @PathVariable(value="milestoneIds") List<Long> milestoneIds) {
        this.testCaseModificationService.unbindMilestones(testCaseId, milestoneIds);
    }

    @RequestMapping(value={"/milestones/associables"}, method={RequestMethod.GET})
    @ResponseBody
    public DataTableModel getNotYetBoundMilestones(@PathVariable long testCaseId, DataTableDrawParameters params) {
        Collection notBoundMilestones = this.testCaseModificationService.findAssociableMilestones(testCaseId);
        return this.buildMilestoneTableModel(testCaseId, notBoundMilestones, params.getsEcho());
    }

    @RequestMapping(value={"/milestones/panel"}, method={RequestMethod.GET})
    public String getMilestonesPanel(@PathVariable Long testCaseId, Model model) {
        MilestonePanelConfiguration conf = new MilestonePanelConfiguration();
        TestCase tc = this.testCaseModificationService.findById(testCaseId.longValue());
        Collection allMilestones = this.testCaseModificationService.findAllMilestones(testCaseId.longValue());
        List currentModel = this.buildMilestoneTableModel(testCaseId, allMilestones, "0").getAaData();
        HashMap<String, String> identity = new HashMap<String, String>();
        identity.put("restype", "test-cases");
        identity.put("resid", testCaseId.toString());
        String rootPath = "test-cases/" + testCaseId.toString();
        Boolean editable = this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "LINK", (Object)tc);
        List mil = tc.getProject().getMilestones();
        CollectionUtils.filter((Collection)mil, (Predicate)new Predicate(){

            public boolean evaluate(Object milestone) {
                return ((Milestone)milestone).getStatus().isBindableToObject();
            }
        });
        Boolean isMilestoneInProject = !mil.isEmpty();
        conf.setNodeType("testcase");
        conf.setRootPath(rootPath);
        conf.setIdentity(identity);
        conf.setCurrentModel(currentModel);
        conf.setEditable(editable);
        conf.setIsMilestoneInProject(isMilestoneInProject);
        model.addAttribute("conf", (Object)conf);
        return "milestones/milestones-tab.html";
    }

    private PagingAndSorting createPaging(DataTableDrawParameters params, DatatableMapper<?> dtMapper) {
        return new DataTableSorting(params, dtMapper);
    }

    private DataTableModel buildMilestoneTableModel(long testCaseId, Collection<Milestone> milestones, String sEcho) {
        TestCase tc = this.testCaseModificationService.findById(testCaseId);
        ArrayList<MetaMilestone> metaMilestones = new ArrayList<MetaMilestone>(milestones.size());
        for (Milestone m : milestones) {
            metaMilestones.add(new MetaMilestone(m, tc.isMemberOf(m)));
        }
        SinglePageCollectionHolder collectionHolder = new SinglePageCollectionHolder(metaMilestones);
        Locale locale = LocaleContextHolder.getLocale();
        return new TestCaseBoundMilestoneTableModelHelper(this.internationalizationHelper, locale).buildDataModel(collectionHolder, sEcho);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"format=printable"})
    public ModelAndView showPrintableTestCase(@PathVariable long testCaseId, Locale locale) {
        LOGGER.debug("get printable test case");
        TestCase testCase = this.testCaseModificationService.findById(testCaseId);
        if (testCase == null) {
            throw new UnknownEntityException(testCaseId, TestCase.class);
        }
        ModelAndView mav = new ModelAndView("print-test-case.html");
        mav.addObject(TEST_CASE, (Object)testCase);
        IsStandardTestCaseVisitor isStandardVisitor = new IsStandardTestCaseVisitor();
        testCase.accept((TestCaseVisitor)isStandardVisitor);
        mav.addObject("isTcStandard", (Object)isStandardVisitor.isStandard());
        IsScriptedTestCaseVisitor isScriptedVisitor = new IsScriptedTestCaseVisitor();
        testCase.accept((TestCaseVisitor)isScriptedVisitor);
        mav.addObject("isTcScripted", (Object)isScriptedVisitor.isScripted());
        IsKeywordTestCaseVisitor isKeywordVisitor = new IsKeywordTestCaseVisitor();
        testCase.accept((TestCaseVisitor)isKeywordVisitor);
        mav.addObject("isTcKeyword", (Object)isKeywordVisitor.isKeyword());
        GetKindTestCaseVisitor kindVisitor = new GetKindTestCaseVisitor();
        testCase.accept((TestCaseVisitor)kindVisitor);
        mav.addObject("tcKind", (Object)kindVisitor.getKind());
        if (testCase.getProject().isBugtrackerConnected()) {
            Project project = testCase.getProject();
            AuthenticationStatus status = this.bugTrackersLocalService.checkBugTrackerStatus(project.getId());
            BugTrackerInterfaceDescriptor descriptor = this.bugTrackersLocalService.getInterfaceDescriptor(project.findBugTracker());
            descriptor.setLocale(locale);
            mav.addObject("interfaceDescriptor", (Object)descriptor);
            mav.addObject("bugTrackerStatus", (Object)status);
            List<DecoratedIssueOwnership> decoratedIssues = Collections.emptyList();
            if (status == AuthenticationStatus.AUTHENTICATED) {
                try {
                    List issuesOwnerShipList = Collections.emptyList();
                    issuesOwnerShipList = this.bugTrackersLocalService.findIssueOwnershipForTestCase(testCaseId);
                    decoratedIssues = new ArrayList(issuesOwnerShipList.size());
                    this.fillDecoratedIssues(decoratedIssues, issuesOwnerShipList, locale);
                }
                catch (BugTrackerRemoteException | NullArgumentException throwable) {}
            }
            mav.addObject("issuesOwnerShipList", decoratedIssues);
        }
        mav.addObject(TEST_CASE, (Object)testCase);
        List customFieldValues = this.cufHelperService.newHelper((BoundEntity)testCase).getCustomFieldValues();
        mav.addObject("testCaseCufValues", (Object)customFieldValues);
        Paging paging = this.createSinglePagePaging();
        List executions = this.executionFinder.findAllByTestCaseIdOrderByRunDate(testCaseId, paging);
        mav.addObject("execs", (Object)executions);
        List steps = this.testCaseModificationService.findStepsByTestCaseId(testCaseId);
        CustomFieldHelper helper = this.cufHelperService.newStepsHelper(steps, testCase.getProject()).setRenderingLocations(new RenderingLocation[]{RenderingLocation.STEP_TABLE}).restrictToCommonFields();
        List<CustomFieldModel> cufDefinitions = this.convertToJsonCustomField(helper.getCustomFieldConfiguration());
        List stepCufValues = helper.getCustomFieldValues();
        TestStepsTableModelBuilder modelBuilder = new TestStepsTableModelBuilder();
        modelBuilder.usingCustomFields(stepCufValues, cufDefinitions.size());
        List<Object> stepsData = modelBuilder.buildRawModel(steps, 1);
        mav.addObject("stepsData", stepsData);
        mav.addObject("cufDefinitions", cufDefinitions);
        if (isScriptedVisitor.isScripted()) {
            ScriptedTestCase scriptedTestCase = this.scriptedTestCaseFinder.findById(testCase.getId().longValue());
            mav.addObject("testCaseScript", (Object)scriptedTestCase.getScript());
        }
        List parameters = this.parameterFinder.findAllParameters(testCaseId);
        Collections.sort(parameters, new ParameterNameComparator(SortOrder.ASCENDING));
        ParametersModelHelper paramHelper = new ParametersModelHelper(testCaseId, this.messageSource, locale);
        List<Object> parameterDatas = paramHelper.buildRawModel(parameters);
        mav.addObject("paramDatas", parameterDatas);
        Map<String, String> paramHeadersByParamId = TestCaseDatasetsController.findDatasetParamHeadersByParamId(testCaseId, locale, parameters, this.messageSource);
        List<Object[]> datasetsparamValuesById = this.getParamValuesById(testCase.getDatasets());
        mav.addObject("paramIds", (Object)IdentifiedUtil.extractIds((Collection)parameters));
        mav.addObject("paramHeadersById", paramHeadersByParamId);
        mav.addObject("datasetsparamValuesById", datasetsparamValuesById);
        List callingSteps = this.testCaseModificationService.findAllCallingTestSteps(testCaseId);
        mav.addObject("callingSteps", (Object)callingSteps);
        List verifReq = this.verifiedRequirementsManagerService.findAllVerifiedRequirementsByTestCaseId(testCaseId);
        mav.addObject("verifiedRequirements", (Object)verifReq);
        Collection allMilestones = this.testCaseModificationService.findAllMilestones(testCaseId);
        List milestoneModels = this.buildMilestoneTableModel(testCaseId, allMilestones, "0").getAaData();
        mav.addObject("milestones", milestoneModels);
        return mav;
    }

    private void fillDecoratedIssues(List<DecoratedIssueOwnership> decoratedIssues, List<IssueOwnership<RemoteIssueDecorator>> issuesOwnerShipList, Locale locale) {
        for (IssueOwnership<RemoteIssueDecorator> ownerShip : issuesOwnerShipList) {
            decoratedIssues.add(new DecoratedIssueOwnership(ownerShip, locale));
        }
    }

    private List<Object[]> getParamValuesById(Set<Dataset> datasets) {
        ArrayList<Object[]> result = new ArrayList<Object[]>(datasets.size());
        for (Dataset dataset : datasets) {
            Set datasetParamValues = dataset.getParameterValues();
            HashMap<String, String> datasetParamValuesById = new HashMap<String, String>(datasetParamValues.size());
            for (DatasetParamValue datasetParamValue : datasetParamValues) {
                datasetParamValuesById.put(datasetParamValue.getParameter().getId().toString(), datasetParamValue.getParamValue());
            }
            String datasetName = dataset.getName();
            Object[] datasetView = new Object[]{datasetName, datasetParamValuesById};
            result.add(datasetView);
        }
        return result;
    }

    private Paging createSinglePagePaging() {
        return new Paging(){

            public boolean shouldDisplayAll() {
                return true;
            }

            public int getPageSize() {
                return 0;
            }

            public int getFirstItemIndex() {
                return 0;
            }
        };
    }

    private List<CustomFieldModel> convertToJsonCustomField(Collection<CustomField> customFields) {
        ArrayList<CustomFieldModel> models = new ArrayList<CustomFieldModel>(customFields.size());
        for (CustomField field : customFields) {
            models.add(this.converter.toJson(field));
        }
        return models;
    }

    private String buildAutomReqStatusComboData(Locale locale) {
        List<AutomationRequestStatus> statuses = Arrays.asList(AutomationRequestStatus.WORK_IN_PROGRESS, AutomationRequestStatus.READY_TO_TRANSMIT, AutomationRequestStatus.SUSPENDED);
        StringBuilder result = new StringBuilder();
        result.append("{\"");
        int i = 0;
        while (i < statuses.size()) {
            result.append(statuses.get(i).name()).append("\":\"").append(this.internationalizationHelper.internationalize(statuses.get(i).getI18nKey(), locale));
            if (i < 2) {
                result.append("\",\"");
            }
            ++i;
        }
        result.append("\"}");
        return result.toString();
    }

    private String formatAutomReqStatus(AutomationRequest request, Locale locale) {
        if (request != null) {
            return this.internationalizationHelper.internationalize(request.getRequestStatus().getI18nKey(), locale);
        }
        return this.internationalizationHelper.internationalize((Internationalizable)AutomationRequestStatus.WORK_IN_PROGRESS, locale);
    }

    private String formatRemoteReqStatus(RemoteAutomationRequestExtender remoteRequest, Locale locale) {
        if (remoteRequest.getRemoteRequestStatus() != null) {
            return remoteRequest.getRemoteRequestStatus();
        }
        return this.internationalizationHelper.internationalize(SQUASHTM_NODATA, locale);
    }

    private String formatRemoteReqUrl(RemoteAutomationRequestExtender remoteRequest, Locale locale) {
        if (remoteRequest.getRemoteRequestUrl() != null && !remoteRequest.getRemoteRequestUrl().isEmpty()) {
            return remoteRequest.getRemoteRequestUrl();
        }
        return this.internationalizationHelper.internationalize(SQUASHTM_NODATA, locale);
    }

    public class DecoratedIssueOwnership {
        private IssueOwnership<RemoteIssueDecorator> ownership;
        private String ownerDesc;

        public DecoratedIssueOwnership(IssueOwnership<RemoteIssueDecorator> ownership, Locale locale) {
            this.ownership = ownership;
            this.ownerDesc = BugTrackerControllerHelper.findOwnerDescForTestCase(ownership.getOwner(), TestCaseModificationController.this.messageSource, locale);
        }

        public String getOwnerDesc() {
            return this.ownerDesc;
        }

        public IssueOwnership<RemoteIssueDecorator> getOwnership() {
            return this.ownership;
        }
    }
}

