/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.testcase.ExportTestCaseData;
import org.squashtest.tm.domain.testcase.ExportTestStepData;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.exception.library.RightsUnsuficientsForOperationException;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.library.LibraryNavigationService;
import org.squashtest.tm.service.statistics.testcase.TestCaseStatisticsBundle;
import org.squashtest.tm.service.testcase.TestCaseLibraryFinderService;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.service.testcase.fromreq.ReqToTestCaseConfiguration;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.generic.LibraryNavigationController;
import org.squashtest.tm.web.internal.controller.testcase.TestCaseFormModel;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.TestCaseLibraryTreeNodeBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/test-case-browser"})
public class TestCaseLibraryNavigationController
extends LibraryNavigationController<TestCaseLibrary, TestCaseFolder, TestCaseLibraryNode> {
    public static final Logger LOGGER = LoggerFactory.getLogger(TestCaseLibraryNavigationController.class);
    private static final String APPLICATION_SLASH_OCTET_STREAM = "application/octet-stream";
    private static final String ATTACHMENT_FILENAME = "attachment; filename=";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String FOLDERS = "folders";
    private static final String DRIVES = "drives";
    private static final String TESTCASES = "test-cases";
    @Inject
    private Provider<TestCaseLibraryTreeNodeBuilder> testCaseLibraryTreeNodeBuilder;
    @Inject
    @Named(value="testCase.driveNodeBuilder")
    private Provider<DriveNodeBuilder<TestCaseLibraryNode>> driveNodeBuilder;
    @Inject
    private TestCaseLibraryNavigationService testCaseLibraryNavigationService;
    @Inject
    private TestCaseLibraryFinderService testCaseLibraryFinderService;
    @Inject
    private WorkspaceDisplayService testCaseWorkspaceDisplayService;
    private static final String JASPER_EXPORT_FILE = "WEB-INF/reports/test-case-export.jasper";
    private static final String ADD_TEST_CASE = "add-test-case";
    private static final String FILENAME = "filename";
    private static final String LIBRARIES = "libraries";
    private static final String NODES = "nodes";
    private static final String CALLS = "calls";

    @Override
    protected LibraryNavigationService<TestCaseLibrary, TestCaseFolder, TestCaseLibraryNode> getLibraryNavigationService() {
        return this.testCaseLibraryNavigationService;
    }

    @Override
    protected JsTreeNode createTreeNodeFromLibraryNode(TestCaseLibraryNode node) {
        TestCaseLibraryTreeNodeBuilder builder = (TestCaseLibraryTreeNodeBuilder)this.testCaseLibraryTreeNodeBuilder.get();
        Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            builder.filterByMilestone((Milestone)activeMilestone.get());
        }
        return builder.setNode(node).build();
    }

    @ResponseBody
    @RequestMapping(value={"/drives/{libraryId}/content/new-test-case"}, method={RequestMethod.POST}, consumes={"application/json"})
    public JsTreeNode addNewTestCaseToLibraryRootContent(@PathVariable long libraryId, @RequestBody TestCaseFormModel testCaseModel) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)testCaseModel, ADD_TEST_CASE);
        TestCaseFormModel.TestCaseFormModelValidator validator = new TestCaseFormModel.TestCaseFormModelValidator(this.getMessageSource());
        validator.validate(testCaseModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
        TestCase testCase = testCaseModel.getTestCase();
        Map<Long, RawValue> customFieldValues = testCaseModel.getCufs();
        ArrayList<Long> milestoneIds = new ArrayList<Long>();
        Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            milestoneIds.add(((Milestone)activeMilestone.get()).getId());
        }
        this.testCaseLibraryNavigationService.addTestCaseToLibrary(libraryId, testCase, customFieldValues, null, milestoneIds);
        return this.createTreeNodeFromLibraryNode((TestCaseLibraryNode)testCase);
    }

    @ResponseBody
    @RequestMapping(value={"/folders/{folderId}/content/new-test-case"}, method={RequestMethod.POST}, consumes={"application/json"})
    public JsTreeNode addNewTestCaseToFolder(@PathVariable long folderId, @RequestBody TestCaseFormModel testCaseModel) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)testCaseModel, ADD_TEST_CASE);
        TestCaseFormModel.TestCaseFormModelValidator validator = new TestCaseFormModel.TestCaseFormModelValidator(this.getMessageSource());
        validator.validate(testCaseModel, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
        TestCase testCase = testCaseModel.getTestCase();
        Map<Long, RawValue> customFieldValues = testCaseModel.getCufs();
        Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        ArrayList<Long> milestoneIds = new ArrayList<Long>();
        if (activeMilestone.isPresent()) {
            milestoneIds.add(((Milestone)activeMilestone.get()).getId());
        }
        this.testCaseLibraryNavigationService.addTestCaseToFolder(folderId, testCase, customFieldValues, null, milestoneIds);
        return this.createTreeNodeFromLibraryNode((TestCaseLibraryNode)testCase);
    }

    @ResponseBody
    @RequestMapping(value={"/{destinationType}/{destinationId}/content/newTestCases"}, method={RequestMethod.POST}, params={"nodeIds[]"})
    public void copyFromReqToTestCases(@RequestParam(value="nodeIds[]") Long[] nodeIds, @PathVariable(value="destinationId") long destinationId, @PathVariable(value="destinationType") String destType, @RequestParam(value="tcKind") String tcKind, Locale locale) {
        ReqToTestCaseConfiguration configuration = new ReqToTestCaseConfiguration(tcKind);
        try {
            switch (destType) {
                case "folders": {
                    this.testCaseLibraryNavigationService.copyReqToTestCasesToFolder(destinationId, nodeIds, configuration);
                    break;
                }
                case "drives": {
                    this.testCaseLibraryNavigationService.copyReqToTestCasesToLibrary(destinationId, nodeIds, configuration);
                    break;
                }
                case "test-cases": {
                    this.testCaseLibraryNavigationService.copyReqToTestCasesToTestCases(destinationId, nodeIds, configuration);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("copy nodes : specified destination type doesn't exists : " + destType);
                }
            }
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @ResponseBody
    @RequestMapping(value={"/drives"}, method={RequestMethod.GET}, params={"linkables"})
    public List<JsTreeNode> getLinkablesRootModel() {
        List<Long> projectId = this.testCaseLibraryFinderService.findLinkableTestCaseLibraries().stream().map(TestCaseLibrary::getProject).map(GenericProject::getId).collect(Collectors.toList());
        return this.createLinkableLibrariesModel(projectId);
    }

    @RequestMapping(value={"/content/csv"}, produces={"application/octet-stream"}, method={RequestMethod.GET}, params={"filename", "libraries", "nodes", "calls", "keep-rte-format"})
    @ResponseBody
    public void exportAsCsv(Locale locale, @RequestParam(value="filename") String filename, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="calls") Boolean includeCalledTests, @RequestParam(value="keep-rte-format") Boolean keepRteFormat, HttpServletResponse response) throws FileNotFoundException {
        response.setContentType(APPLICATION_SLASH_OCTET_STREAM);
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + filename + ".xls");
        List dataSource = this.testCaseLibraryNavigationService.findTestCasesToExport(libraryIds, nodeIds, includeCalledTests.booleanValue());
        if (!keepRteFormat.booleanValue()) {
            this.escapePrerequisiteAndSteps(dataSource);
        }
        this.convertHtmlSpecialCharactersToUnicode(dataSource);
        this.printExport(dataSource, filename, JASPER_EXPORT_FILE, response, locale, "csv", keepRteFormat);
    }

    @RequestMapping(value={"/content/xls"}, produces={"application/octet-stream"}, method={RequestMethod.GET}, params={"filename", "libraries", "nodes", "calls", "keep-rte-format"})
    @ResponseBody
    public FileSystemResource exportAsExcel(@RequestParam(value="filename") String filename, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="calls") Boolean includeCalledTests, @RequestParam(value="keep-rte-format") Boolean keepRteFormat, HttpServletResponse response) throws FileNotFoundException {
        response.setContentType(APPLICATION_SLASH_OCTET_STREAM);
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + filename + ".xls");
        File export = this.testCaseLibraryNavigationService.exportTestCaseAsExcel(libraryIds, nodeIds, includeCalledTests.booleanValue(), keepRteFormat.booleanValue(), this.getMessageSource());
        return new FileSystemResource(export);
    }

    @RequestMapping(value={"/content/features"}, produces={"application/octet-stream"}, method={RequestMethod.GET}, params={"filename", "libraries", "nodes"})
    @ResponseBody
    public FileSystemResource exportGherkinFeatures(Locale locale, @RequestParam(value="filename") String filename, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, HttpServletResponse response) {
        response.setContentType(APPLICATION_SLASH_OCTET_STREAM);
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + filename + ".zip");
        File file = this.testCaseLibraryNavigationService.exportGherkinTestCaseAsFeatureFiles(libraryIds, nodeIds, this.getMessageSource());
        return new FileSystemResource(file);
    }

    @RequestMapping(value={"/content/keyword-scripts"}, produces={"application/octet-stream"}, method={RequestMethod.GET}, params={"filename", "libraries", "nodes"})
    @ResponseBody
    public FileSystemResource exportKeywordScripts(Locale locale, @RequestParam(value="filename") String filename, @RequestParam(value="libraries") List<Long> libraryIds, @RequestParam(value="nodes") List<Long> nodeIds, HttpServletResponse response) {
        response.setContentType(APPLICATION_SLASH_OCTET_STREAM);
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + filename + ".zip");
        File file = this.testCaseLibraryNavigationService.exportKeywordTestCaseAsScriptFiles(libraryIds, nodeIds, this.getMessageSource());
        return new FileSystemResource(file);
    }

    @RequestMapping(value={"/searchExports"}, produces={"application/octet-stream"}, method={RequestMethod.GET}, params={"filename", "nodes", "calls", "keep-rte-format"})
    @ResponseBody
    public FileSystemResource searchExportAsExcel(@RequestParam(value="filename") String filename, @RequestParam(value="nodes") List<Long> nodeIds, @RequestParam(value="calls") Boolean includeCalledTests, @RequestParam(value="type") String type, @RequestParam(value="keep-rte-format") Boolean keepRteFormat, HttpServletResponse response) throws FileNotFoundException {
        response.setContentType(APPLICATION_SLASH_OCTET_STREAM);
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + filename + ".xls");
        File export = this.testCaseLibraryNavigationService.searchExportTestCaseAsExcel(nodeIds, includeCalledTests.booleanValue(), keepRteFormat.booleanValue(), this.getMessageSource(), type);
        return new FileSystemResource(export);
    }

    private void escapePrerequisiteAndSteps(List<ExportTestCaseData> dataSource) {
        for (ExportTestCaseData data : dataSource) {
            String htmlPrerequisite = data.getPrerequisite();
            String prerequisite = HTMLCleanupUtils.htmlToText(htmlPrerequisite);
            data.setPrerequisite(prerequisite);
            String htmlFirstAction = data.getFirstAction();
            String firstAction = HTMLCleanupUtils.htmlToText(htmlFirstAction);
            data.setFirstAction(firstAction);
            String htmlFirstResult = data.getFirstExpectedResult();
            String firstResult = HTMLCleanupUtils.htmlToText(htmlFirstResult);
            data.setFirstExpectedResult(firstResult);
            for (ExportTestStepData step : data.getSteps()) {
                String htmlAction = step.getAction();
                String action = HTMLCleanupUtils.htmlToText(htmlAction);
                step.setAction(action);
                String htmlExpectedResult = step.getExpectedResult();
                String expectedResult = HTMLCleanupUtils.htmlToText(htmlExpectedResult);
                step.setExpectedResult(expectedResult);
            }
        }
    }

    private void convertHtmlSpecialCharactersToUnicode(List<ExportTestCaseData> dataSource) {
        for (ExportTestCaseData data : dataSource) {
            data.setDescription(HtmlUtils.htmlUnescape((String)data.getDescription()));
            data.setPrerequisite(HtmlUtils.htmlUnescape((String)data.getPrerequisite()));
            data.setFirstAction(HtmlUtils.htmlUnescape((String)data.getFirstAction()));
            data.setFirstExpectedResult(HtmlUtils.htmlUnescape((String)data.getFirstExpectedResult()));
            for (ExportTestStepData step : data.getSteps()) {
                step.setAction(HtmlUtils.htmlUnescape((String)step.getAction()));
                step.setExpectedResult(HtmlUtils.htmlUnescape((String)step.getExpectedResult()));
            }
        }
    }

    @ResponseBody
    @RequestMapping(value={"/statistics"}, method={RequestMethod.GET}, produces={"application/json"}, params={"libraries", "nodes"})
    public TestCaseStatisticsBundle getStatisticsAsJson(@RequestParam(value="libraries", defaultValue="") Collection<Long> libraryIds, @RequestParam(value="nodes", defaultValue="") Collection<Long> nodeIds) {
        return this.testCaseLibraryNavigationService.getStatisticsForSelection(libraryIds, nodeIds);
    }

    @RequestMapping(value={"/dashboard"}, method={RequestMethod.GET}, produces={"text/html"}, params={"libraries", "nodes"})
    public String getDashboard(Model model, @RequestParam(value="libraries") Collection<Long> libraryIds, @RequestParam(value="nodes") Collection<Long> nodeIds) {
        TestCaseStatisticsBundle stats = this.testCaseLibraryNavigationService.getStatisticsForSelection(libraryIds, nodeIds);
        model.addAttribute("statistics", (Object)stats);
        return "fragment/test-cases/test-cases-dashboard";
    }

    @RequestMapping(value={"/dashboard-favorite"}, method={RequestMethod.GET}, produces={"text/html"})
    public String getFavoriteDashboard(Model model) {
        boolean shouldShowDashboard = this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.TEST_CASE);
        boolean canShowDashboard = this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.TEST_CASE);
        model.addAttribute("shouldShowDashboard", (Object)shouldShowDashboard);
        model.addAttribute("canShowDashboard", (Object)canShowDashboard);
        return "fragment/dashboard/favorite-dashboard";
    }

    @ResponseBody
    @RequestMapping(value={"/statistics"}, method={RequestMethod.GET}, produces={"application/json"})
    public TestCaseStatisticsBundle getStatisticsAsJson() {
        List nodeIds = this.testCaseLibraryNavigationService.findAllTestCasesLibraryNodeForMilestone((Milestone)this.activeMilestoneHolder.getActiveMilestone().orElse(null));
        return this.testCaseLibraryNavigationService.getStatisticsForSelection(new ArrayList(), (Collection)nodeIds);
    }

    @RequestMapping(value={"/dashboard"}, method={RequestMethod.GET}, produces={"text/html"})
    public String getDashboardByMilestone(Model model) {
        boolean shouldShowDashboard = this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.TEST_CASE);
        boolean canShowDashboard = this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.TEST_CASE);
        model.addAttribute("shouldShowDashboard", (Object)shouldShowDashboard);
        model.addAttribute("canShowDashboard", (Object)canShowDashboard);
        Milestone activeMilestone = this.activeMilestoneHolder.getActiveMilestone().orElse(null);
        model.addAttribute("milestone", (Object)activeMilestone);
        model.addAttribute("isMilestoneDashboard", (Object)true);
        if (!shouldShowDashboard || !canShowDashboard) {
            List nodeIds = this.testCaseLibraryNavigationService.findAllTestCasesLibraryNodeForMilestone(activeMilestone);
            TestCaseStatisticsBundle stats = this.testCaseLibraryNavigationService.getStatisticsForSelection(new ArrayList(), (Collection)nodeIds);
            model.addAttribute("statistics", (Object)stats);
        }
        return "fragment/test-cases/test-cases-milestone-dashboard";
    }

    @Override
    protected WorkspaceDisplayService workspaceDisplayService() {
        return this.testCaseWorkspaceDisplayService;
    }
}

