/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase;

import java.util.Set;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.web.internal.controller.generic.ServiceAwareAttachmentTableModelHelper;

@Controller
@RequestMapping(value={"/test-case-libraries/{libraryId}"})
public class TestCaseLibraryModificationController {
    @Inject
    private TestCaseLibraryNavigationService service;
    @Inject
    private ServiceAwareAttachmentTableModelHelper attachmentsHelper;
    @Inject
    private CustomReportDashboardService customReportDashboardService;

    @RequestMapping(method={RequestMethod.GET})
    public final ModelAndView showTestCaseLibrary(@PathVariable long libraryId) {
        TestCaseLibrary lib = (TestCaseLibrary)this.service.findLibrary(libraryId);
        ModelAndView mav = new ModelAndView("fragment/test-cases/test-case-library");
        Set<Attachment> attachments = this.attachmentsHelper.findAttachments((AttachmentHolder)lib);
        mav.addObject("library", (Object)lib);
        mav.addObject("attachments", attachments);
        mav.addObject("workspaceName", (Object)"test-case");
        boolean shouldShowDashboard = this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.TEST_CASE);
        boolean canShowDashboard = this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.TEST_CASE);
        mav.addObject("shouldShowDashboard", (Object)shouldShowDashboard);
        mav.addObject("canShowDashboard", (Object)canShowDashboard);
        return mav;
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public final ModelAndView showTestCaseLibraryInfo(@PathVariable long libraryId) {
        TestCaseLibrary lib = (TestCaseLibrary)this.service.findLibrary(libraryId);
        ModelAndView mav = new ModelAndView("page/test-case-workspace/show-test-case-library");
        Set<Attachment> attachments = this.attachmentsHelper.findAttachments((AttachmentHolder)lib);
        mav.addObject("library", (Object)lib);
        mav.addObject("attachments", attachments);
        mav.addObject("workspaceName", (Object)"test-case");
        return mav;
    }
}

