/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFactory;
import org.squashtest.tm.service.internal.dto.RawValueModel;

public class TestCaseFormModel {
    private static final String MESSAGE_NOT_BLANK = "message.notBlank";
    private String name;
    private String reference;
    private String description;
    private String scriptLanguage;
    private RawValueModel.RawValueModelMap customFields = new RawValueModel.RawValueModelMap();

    public TestCase getTestCase() {
        TestCase newTC = TestCaseFactory.getTestCase((String)this.scriptLanguage, (String)this.name);
        newTC.setDescription(this.description);
        newTC.setReference(this.reference);
        return newTC;
    }

    @JsonIgnore
    public Map<Long, RawValue> getCufs() {
        HashMap<Long, RawValue> cufs = new HashMap<Long, RawValue>(this.customFields.size());
        for (Map.Entry entry : this.customFields.entrySet()) {
            cufs.put((Long)entry.getKey(), ((RawValueModel)entry.getValue()).toRawValue());
        }
        return cufs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(String scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public RawValueModel.RawValueModelMap getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(RawValueModel.RawValueModelMap customFields) {
        this.customFields = customFields;
    }

    public static class TestCaseFormModelValidator
    implements Validator {
        private MessageSource messageSource;

        public TestCaseFormModelValidator(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public void setMessageSource(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public boolean supports(Class<?> clazz) {
            return clazz.equals(TestCaseFormModel.class);
        }

        public void validate(Object target, Errors errors) {
            Locale locale = LocaleContextHolder.getLocale();
            String notBlank = this.messageSource.getMessage(TestCaseFormModel.MESSAGE_NOT_BLANK, null, locale);
            String lengthMax = this.messageSource.getMessage("message.lengthMax", new Object[]{"50"}, locale);
            TestCaseFormModel model = (TestCaseFormModel)target;
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)TestCaseFormModel.MESSAGE_NOT_BLANK, (String)notBlank);
            if (model.reference != null && model.reference.length() > 50) {
                errors.rejectValue("reference", "message.lengthMax", lengthMax);
            }
            for (Map.Entry entry : model.getCustomFields().entrySet()) {
                RawValueModel value = (RawValueModel)entry.getValue();
                if (!value.isEmpty()) continue;
                errors.rejectValue("customFields[" + entry.getKey() + "]", TestCaseFormModel.MESSAGE_NOT_BLANK, notBlank);
            }
        }
    }
}

