/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.service.library.FolderModificationService;
import org.squashtest.tm.service.testcase.TestCaseLibraryFinderService;
import org.squashtest.tm.web.internal.controller.generic.FolderModificationController;

@Controller
@RequestMapping(value={"/test-case-folders/{folderId}"})
public class TestCaseFolderModificationController
extends FolderModificationController<TestCaseFolder> {
    private FolderModificationService<TestCaseFolder> folderModificationService;
    @Inject
    private TestCaseLibraryFinderService libraryFinderService;

    @Override
    protected FolderModificationService<TestCaseFolder> getFolderModificationService() {
        return this.folderModificationService;
    }

    @Inject
    @Named(value="squashtest.tm.service.TestCaseFolderModificationService")
    public final void setFolderModificationService(FolderModificationService<TestCaseFolder> folderModificationService) {
        this.folderModificationService = folderModificationService;
    }

    @Override
    protected String getWorkspaceName() {
        return "test-case";
    }

    @Override
    @RequestMapping(method={RequestMethod.GET})
    public final ModelAndView showFolder(@PathVariable long folderId, HttpServletRequest request) {
        ModelAndView mav = super.showFolder(folderId, request);
        mav.setViewName("fragment/test-cases/test-case-folder");
        return mav;
    }

    @RequestMapping(value={"/test/{ids}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getPath(@PathVariable(value="ids") List<Long> ids) {
        return this.libraryFinderService.getPathsAsString(ids);
    }
}

