/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.service.requirement.VerifiedRequirementsFinderService;
import org.squashtest.tm.service.testcase.TestCaseFinder;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.web.internal.controller.testcase.TestCaseAutomatableJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.controller.testcase.TestCaseImportanceJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.controller.testcase.TestCaseStatusJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.controller.testcase.TestCaseTreeIconsUpdate;
import org.squashtest.tm.web.internal.model.json.JsonTestCase;
import org.squashtest.tm.web.internal.model.json.JsonTestCaseBuilder;

@RequestMapping(value={"/test-cases"})
@Controller
public class TestCaseController {
    private static final String IDS = "ids[]";
    private static final String FOLDER_IDS = "folderIds[]";
    @Inject
    private Provider<JsonTestCaseBuilder> builder;
    @Inject
    private TestCaseFinder finder;
    @Inject
    private Provider<TestCaseImportanceJeditableComboDataBuilder> importanceComboBuilderProvider;
    @Inject
    private Provider<TestCaseStatusJeditableComboDataBuilder> statusComboBuilderProvider;
    @Inject
    private Provider<TestCaseAutomatableJeditableComboDataBuilder> automatableComboBuilderProvider;
    @Inject
    private VerifiedRequirementsFinderService verifiedRequirementsFinderService;
    @Inject
    private TestCaseModificationService testCaseModificationService;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, params={"ids[]"}, headers={"Accept=application/json, text/javascript"})
    public List<JsonTestCase> getJsonTestCases(@RequestParam(value="ids[]") List<Long> testCaseIds, Locale locale) {
        List testCases = this.finder.findAllByIds(testCaseIds);
        return ((JsonTestCaseBuilder)this.builder.get()).locale(locale).entities(testCases).toJson();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, params={"folderIds[]"}, headers={"Accept=application/json, text/javascript"})
    public List<JsonTestCase> getJsonTestCasesFromFolders(@RequestParam(value="folderIds[]") List<Long> folderIds, Locale locale) {
        return this.buildJsonTestCasesFromAncestorIds(folderIds, locale);
    }

    private List<JsonTestCase> buildJsonTestCasesFromAncestorIds(List<Long> folderIds, Locale locale) {
        List testCases = this.finder.findAllByAncestorIds(folderIds);
        return ((JsonTestCaseBuilder)this.builder.get()).locale(locale).entities(testCases).toJson();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, params={"ids[]", "folderIds[]"}, headers={"Accept=application/json, text/javascript"})
    public List<JsonTestCase> getJsonTestCases(@RequestParam(value="ids[]") List<Long> testCaseIds, @RequestParam(value="folderIds[]") List<Long> folderIds, Locale locale) {
        ArrayList<Long> consolidatedIds = new ArrayList<Long>(testCaseIds.size() + folderIds.size());
        consolidatedIds.addAll(testCaseIds);
        consolidatedIds.addAll(folderIds);
        return this.buildJsonTestCasesFromAncestorIds(consolidatedIds, locale);
    }

    @ResponseBody
    @RequestMapping(value={"/tree-infos"}, method={RequestMethod.POST})
    public List<TestCaseTreeIconsUpdate> getTestCaseTreeInfosToUpdate(@RequestBody Map<String, Object> form) {
        Map updatedIdsAndOldReqString = (Map)form.get("updatedIdsAndOldReq");
        Map<Long, Boolean> updatedIdsAndOldReq = this.transformToLongBooleanMap(updatedIdsAndOldReqString);
        Set<Long> updatedIds = updatedIdsAndOldReq.keySet();
        ArrayList openedNodesIdsString = (ArrayList)form.get("openedNodesIds");
        Set<Long> openedNodesIds = this.transformToLongSet(openedNodesIdsString);
        openedNodesIds.removeAll(updatedIds);
        Map<Long, Boolean> newIsReqCoveredById = this.findNodesWithReqCoverageThatChanged(updatedIdsAndOldReq);
        HashSet<Long> newIsReqCoveredIdsAndCalling = new HashSet<Long>();
        for (Long idChange : new HashSet<Long>(newIsReqCoveredById.keySet())) {
            newIsReqCoveredIdsAndCalling.add(idChange);
            Set callingOpenedNodesIds = this.finder.findCallingTCids(idChange.longValue(), openedNodesIds);
            callingOpenedNodesIds.removeAll(newIsReqCoveredIdsAndCalling);
            newIsReqCoveredById.putAll(this.verifiedRequirementsFinderService.findisReqCoveredOfCallingTCWhenisReqCoveredChanged(idChange.longValue(), (Collection)callingOpenedNodesIds));
            newIsReqCoveredIdsAndCalling.addAll(callingOpenedNodesIds);
        }
        HashSet<Long> sameIsReqCoveredIds = new HashSet<Long>();
        sameIsReqCoveredIds.addAll(updatedIds);
        sameIsReqCoveredIds.removeAll(newIsReqCoveredById.keySet());
        Set<Long> sameIsReqCoveredIdsWCalling = this.addCallingNodesIds(openedNodesIds, sameIsReqCoveredIds);
        HashSet<Long> toUpdateImportanceId = new HashSet<Long>();
        toUpdateImportanceId.addAll(sameIsReqCoveredIdsWCalling);
        toUpdateImportanceId.addAll(newIsReqCoveredIdsAndCalling);
        Map importancesToUpdate = this.finder.findImpTCWithImpAuto(toUpdateImportanceId);
        return this.mergeImportanceAndReqCoverage(newIsReqCoveredById, importancesToUpdate);
    }

    @RequestMapping(value={"/transmit-eligible-tcs"}, method={RequestMethod.POST}, headers={"Accept=application/json, text/javascript"})
    @ResponseBody
    public Map<String, Object> transmitEligibleNodes(@RequestBody Map<String, List<Long>> selectedNodes) {
        return this.testCaseModificationService.transmitEligibleNodes(selectedNodes);
    }

    private Set<Long> transformToLongSet(Collection<String> openedNodesIdsString) {
        HashSet<Long> openedNodesIds = new HashSet<Long>();
        for (String nodeId : openedNodesIdsString) {
            openedNodesIds.add(Long.parseLong(nodeId));
        }
        return openedNodesIds;
    }

    private Map<Long, Boolean> transformToLongBooleanMap(Map<String, String> map) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.put(Long.parseLong(entry.getKey()), Boolean.parseBoolean(entry.getValue()));
        }
        return result;
    }

    private Map<Long, Boolean> findNodesWithReqCoverageThatChanged(Map<Long, Boolean> updatedIdsAndOldReq) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>();
        for (Map.Entry<Long, Boolean> entry : updatedIdsAndOldReq.entrySet()) {
            boolean newReq;
            long id = entry.getKey();
            boolean oldReqbool = updatedIdsAndOldReq.get(id);
            boolean bl = newReq = this.verifiedRequirementsFinderService.testCaseHasDirectCoverage(id) || this.verifiedRequirementsFinderService.testCaseHasUndirectRequirementCoverage(id);
            if (newReq == oldReqbool) continue;
            result.put(id, newReq);
        }
        return result;
    }

    private Set<Long> addCallingNodesIds(Collection<Long> openedNodesIds, Collection<Long> nodesIds) {
        HashSet<Long> idsToUpdate = new HashSet<Long>();
        for (Long id : nodesIds) {
            idsToUpdate.add(id);
            Set callingOpenedNodesIds = this.finder.findCallingTCids(id.longValue(), openedNodesIds);
            idsToUpdate.addAll(callingOpenedNodesIds);
        }
        return idsToUpdate;
    }

    private List<TestCaseTreeIconsUpdate> mergeImportanceAndReqCoverage(Map<Long, Boolean> areReqCoveredToUpdate, Map<Long, TestCaseImportance> importancesToUpdate) {
        Long testCaseId;
        ArrayList<TestCaseTreeIconsUpdate> result = new ArrayList<TestCaseTreeIconsUpdate>();
        for (Map.Entry<Long, TestCaseImportance> entry : importancesToUpdate.entrySet()) {
            testCaseId = entry.getKey();
            TestCaseImportance imp = entry.getValue();
            Boolean isReqCovered = areReqCoveredToUpdate.get(testCaseId);
            if (isReqCovered != null) {
                result.add(new TestCaseTreeIconsUpdate(testCaseId, isReqCovered, imp));
                areReqCoveredToUpdate.remove(testCaseId);
                continue;
            }
            result.add(new TestCaseTreeIconsUpdate((long)testCaseId, imp));
        }
        for (Map.Entry<Long, Object> entry : areReqCoveredToUpdate.entrySet()) {
            testCaseId = entry.getKey();
            Boolean isReqCovered = (Boolean)entry.getValue();
            result.add(new TestCaseTreeIconsUpdate((long)testCaseId, isReqCovered));
        }
        return result;
    }

    @RequestMapping(value={"/importance-combo-data"}, method={RequestMethod.GET})
    @ResponseBody
    public Object buildImportanceComboData(Locale locale) {
        return ((TestCaseImportanceJeditableComboDataBuilder)((TestCaseImportanceJeditableComboDataBuilder)this.importanceComboBuilderProvider.get()).useLocale(locale)).buildMap();
    }

    @RequestMapping(value={"/status-combo-data"}, method={RequestMethod.GET})
    @ResponseBody
    public Object buildStatusComboData(Locale locale) {
        return ((TestCaseStatusJeditableComboDataBuilder)((TestCaseStatusJeditableComboDataBuilder)this.statusComboBuilderProvider.get()).useLocale(locale)).buildMap();
    }

    @RequestMapping(value={"/automatable-combo-data"}, method={RequestMethod.GET})
    @ResponseBody
    public String buildAutomatableComboData(Locale locale) {
        return ((TestCaseAutomatableJeditableComboDataBuilder)((TestCaseAutomatableJeditableComboDataBuilder)this.automatableComboBuilderProvider.get()).useLocale(locale)).buildMarshalled();
    }
}

