/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase;

import java.util.Collection;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.web.internal.model.testautomation.TATestNode;
import org.squashtest.tm.web.internal.model.testautomation.TATestNodeListBuilder;

@Controller
@RequestMapping(value={"/test-cases/{testCaseId}/test-automation"})
public class TestCaseAutomationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseAutomationController.class);
    private TestCaseModificationService testCaseModificationService;
    private static final String NAME_KEY = "name";
    private static final String PATH = "path";
    private static final String TEST_CASE_ID = "testCaseId";
    private static final String PROJECT_ID = "projectId";

    @Inject
    public void setTestCaseModificationService(TestCaseModificationService testCaseModificationService) {
        this.testCaseModificationService = testCaseModificationService;
    }

    @RequestMapping(value={"/tests"}, method={RequestMethod.GET})
    @ResponseBody
    public Collection<TATestNode> findAssignableAutomatedTests(@PathVariable(value="testCaseId") Long testCaseId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Find assignable automated tests for TC#" + testCaseId);
        }
        Collection projectContents = this.testCaseModificationService.findAssignableAutomationTests(testCaseId.longValue());
        return new TATestNodeListBuilder().build(projectContents);
    }

    @RequestMapping(value={"/tests"}, method={RequestMethod.POST}, params={"projectId", "name"})
    @ResponseBody
    public void bindAutomatedTest(@PathVariable(value="testCaseId") long testCaseId, @RequestParam(value="projectId") long projectId, @RequestParam(value="name") String testName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Bind automated test " + testName + " to TC#" + testCaseId);
        }
        this.testCaseModificationService.bindAutomatedTest(Long.valueOf(testCaseId), Long.valueOf(projectId), testName);
    }

    @RequestMapping(value={"/tests"}, method={RequestMethod.POST}, params={"path"})
    @ResponseBody
    public String bindAutomatedTest(@PathVariable(value="testCaseId") long testCaseId, @RequestParam(value="path") String testPath) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Bind automated test " + testPath + " to TC#" + testCaseId);
        }
        this.testCaseModificationService.bindAutomatedTest(Long.valueOf(testCaseId), testPath);
        return testPath;
    }

    @RequestMapping(method={RequestMethod.DELETE})
    @ResponseBody
    public void removeAutomation(@PathVariable(value="testCaseId") long testCaseId) {
        this.testCaseModificationService.removeAutomation(testCaseId);
    }
}

