/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testcase;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

class CallingTestCasesTableModelBuilder
extends DataTableModelBuilder<CallTestStep> {
    private InternationalizationHelper i18nHelper;
    private Locale locale = LocaleContextHolder.getLocale();
    private static final int INT_MAX_DESCRIPTION_LENGTH = 50;

    CallingTestCasesTableModelBuilder(InternationalizationHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    protected Map<String, Object> buildItemData(CallTestStep step) {
        HashMap<String, Object> row = new HashMap<String, Object>(8);
        TestCase caller = step.getTestCase();
        String dsName = this.findDatasetName(step);
        String executionMode = this.i18nHelper.internationalize((Internationalizable)caller.getExecutionMode(), this.locale);
        row.put("tc-id", Long.toString(caller.getId()));
        row.put("tc-index", Long.toString(this.getCurrentIndex()));
        row.put("project-name", HtmlUtils.htmlEscape((String)caller.getProject().getName()));
        row.put("tc-reference", HtmlUtils.htmlEscape((String)caller.getReference()));
        row.put("tc-name", HtmlUtils.htmlEscape((String)caller.getName()));
        row.put("tc-mode", executionMode);
        row.put("ds-name", HtmlUtils.htmlEscape((String)dsName));
        row.put("step-no", step.getIndex() + 1);
        row.put("tc-description", HTMLCleanupUtils.getCleanedBriefText(caller.getDescription(), 50));
        return row;
    }

    protected String findDatasetName(CallTestStep step) {
        String name;
        switch (step.getParameterAssignationMode()) {
            case NOTHING: {
                name = "--";
                break;
            }
            case DELEGATE: {
                name = this.i18nHelper.getMessage("label.callstepdataset.Delegate", null, "label.callstepdataset.Delegate", this.locale);
                break;
            }
            case CALLED_DATASET: {
                name = step.getCalledDataset().getName();
                break;
            }
            default: {
                throw new IllegalArgumentException("the ParameterAssignationMode '" + step.getParameterAssignationMode() + "' is not supported");
            }
        }
        return name;
    }
}

