/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testautomation;

import java.util.Arrays;
import java.util.Locale;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.testautomation.TestAutomationServerCredentialsService;
import org.squashtest.tm.service.testautomation.TestAutomationServerManagerService;
import org.squashtest.tm.web.internal.controller.bugtracker.BugTrackerControllerHelper;
import org.squashtest.tm.web.internal.controller.thirdpartyserver.ThirdPartyServerCredentialsManagementBean;
import org.squashtest.tm.web.internal.controller.thirdpartyserver.ThirdPartyServerCredentialsManagementHelper;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/administration/test-automation-servers/{serverId}"})
public class TestAutomationServerModificationAdminController {
    @Inject
    private TestAutomationServerManagerService service;
    @Inject
    private TestAutomationServerCredentialsService testAutomationServerCredentialsService;
    @Inject
    private ThirdPartyServerCredentialsManagementHelper credentialsBeanHelper;

    @RequestMapping(method={RequestMethod.GET})
    public String showTAServer(@PathVariable(value="serverId") long serverId, Model model, Locale locale) {
        TestAutomationServer server = this.service.findById(serverId);
        ThirdPartyServerCredentialsManagementBean authConf = this.makeAuthBean(server, locale);
        String asteriskedPassword = BugTrackerControllerHelper.retrieveAsteriskedPassword(server.getAuthenticationProtocol(), authConf.getCredentials());
        model.addAttribute("server", (Object)server);
        model.addAttribute("asteriskedPassword", (Object)asteriskedPassword);
        model.addAttribute("authConf", (Object)authConf);
        model.addAttribute("serverDescription", (Object)HTMLCleanupUtils.cleanHtml(server.getDescription()));
        return "test-automation/server-modification.html";
    }

    private ThirdPartyServerCredentialsManagementBean makeAuthBean(TestAutomationServer server, Locale locale) {
        ThirdPartyServerCredentialsManagementBean bean = this.credentialsBeanHelper.initializeFor((ThirdPartyServer)server, locale);
        AuthenticationProtocol[] availableProtos = this.testAutomationServerCredentialsService.getSupportedProtocols(server);
        bean.setAvailableProtos(Arrays.asList(availableProtos));
        bean.setAuthPolicy(AuthenticationPolicy.APP_LEVEL);
        bean.setFeatureAuthPolicySelection(false);
        bean.setFeatureTestCredentialsButton(false);
        bean.setAppLevelCredsAreOptional(false);
        return bean;
    }
}

