/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testautomation;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.collection.Pagings;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.internal.testautomation.TestAutomationConnectorRegistry;
import org.squashtest.tm.service.testautomation.TestAutomationServerManagerService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.model.datatable.SpringPagination;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/administration/test-automation-servers"})
public class TestAutomationServerManagementAdminController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationServerManagementAdminController.class);
    private static final String URL = "url";
    private static final String KIND = "kind";
    private static final String TEST_AUTOMATION_SERVERS = "testAutomationServers";
    private static final String TEST_AUTOMATION_SERVER_KINDS = "taServerKinds";
    @Inject
    private TestAutomationServerManagerService testAutomationServerService;
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private TestAutomationConnectorRegistry testAutomationConnectorRegistry;
    private final DatatableMapper<String> testAutomationServerTableMapper = new NameBasedMapper(6).map("name", "name").map("kind", "kind").map("url", "url").map("created-on", "audit.createdOn").map("created-by", "audit.createdBy").map("last-modified-on", "audit.lastModifiedOn").map("last-modified-by", "audit.lastModifiedBy");

    @ModelAttribute(value="testAutomationServerPageSize")
    public long populateTestAutomationServerPageSize() {
        return Pagings.DEFAULT_PAGING.getPageSize();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String showManager(Model model) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Show test automation servers manager page");
        }
        List testAutomationServers = this.testAutomationServerService.findAllOrderedByName();
        Collection taServerKinds = this.testAutomationConnectorRegistry.listRegisteredConnectors();
        model.addAttribute(TEST_AUTOMATION_SERVERS, (Object)testAutomationServers);
        model.addAttribute(TEST_AUTOMATION_SERVER_KINDS, (Object)taServerKinds);
        return "test-automation/servers-manager.html";
    }

    @RequestMapping(method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getTestAutomationServersTableModel(DataTableDrawParameters params, Locale locale) {
        Pageable pageable = SpringPagination.pageable(params, this.testAutomationServerTableMapper);
        Page servers = this.testAutomationServerService.findSortedTestAutomationServers(pageable);
        return new TestAutomationServerDataTableModelHelper(locale).buildDataModel(servers, params.getsEcho());
    }

    private final class TestAutomationServerDataTableModelHelper
    extends DataTableModelBuilder<TestAutomationServer> {
        private Locale locale;

        private TestAutomationServerDataTableModelHelper(Locale locale) {
            this.locale = locale;
        }

        public Map<String, Object> buildItemData(TestAutomationServer item) {
            TestAutomationServer auditable = item;
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("entity-id", item.getId());
            res.put("entity-index", this.getCurrentIndex());
            res.put("name", HtmlUtils.htmlEscape((String)item.getName()));
            res.put(TestAutomationServerManagementAdminController.KIND, item.getKind());
            res.put(TestAutomationServerManagementAdminController.URL, HtmlUtils.htmlEscape((String)item.getUrl()));
            res.put("created-by", TestAutomationServerDataTableModelHelper.formatUsername(HtmlUtils.htmlEscape((String)auditable.getCreatedBy())));
            res.put("last-modified-by", TestAutomationServerDataTableModelHelper.formatUsername(HTMLCleanupUtils.escapeOrDefault(auditable.getLastModifiedBy(), null)));
            res.put("last-modified-on", TestAutomationServerManagementAdminController.this.messageSource.localizeDate(auditable.getLastModifiedOn(), this.locale));
            res.put("created-on", TestAutomationServerManagementAdminController.this.messageSource.localizeDate(auditable.getCreatedOn(), this.locale));
            res.put("empty-delete-holder", " ");
            return res;
        }
    }
}

