/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testautomation;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.core.foundation.lang.UrlUtils;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;
import org.squashtest.tm.service.testautomation.TestAutomationServerManagerService;
import org.squashtest.tm.service.thirdpartyserver.ThirdPartyServerCredentialsService;
import org.squashtest.tm.web.internal.controller.testautomation.NewTestAutomationServer;
import org.squashtest.tm.web.internal.model.testautomation.TAUsageStatus;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/test-automation-servers"})
public class TestAutomationServerController {
    private static final String SERVER_ID = "serverId";
    @Inject
    private TestAutomationServerManagerService service;
    @Inject
    private ThirdPartyServerCredentialsService credentialsService;
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationServerController.class);

    @RequestMapping(value={"/{serverId}/name"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String changeName(@PathVariable(value="serverId") long serverId, @RequestParam(value="value") String newName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Change name for test automation server of id #{}", (Object)serverId);
        }
        this.service.changeName(serverId, newName);
        return newName;
    }

    @RequestMapping(value={"/{serverId}/description"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String changeDescription(@PathVariable(value="serverId") long serverId, @RequestParam(value="value") String newDescription) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Change description for test automation server of id #{}", (Object)serverId);
        }
        this.service.changeDescription(serverId, newDescription);
        return HTMLCleanupUtils.cleanHtml(newDescription);
    }

    @RequestMapping(value={"/{serverId}/baseURL"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public String changeURL(@PathVariable(value="serverId") long serverId, @RequestParam(value="value") String newURL) {
        URL url = UrlUtils.toUrl((String)newURL);
        this.service.changeURL(serverId, url);
        return newURL;
    }

    @RequestMapping(value={"/{serverId}/authentication-protocol"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public void changeAuthProtocol(@PathVariable(value="serverId") long bugtrackerId, @RequestParam(value="value") AuthenticationProtocol protocol) {
        this.credentialsService.changeAuthenticationProtocol(bugtrackerId, protocol);
    }

    @RequestMapping(value={"/{serverId}/authentication-protocol/configuration"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public void saveAuthConfiguration(@PathVariable(value="serverId") long bugtrackerId, @Valid @RequestBody ServerAuthConfiguration configuration) {
        this.credentialsService.storeAuthConfiguration(bugtrackerId, configuration);
    }

    @RequestMapping(value={"/{serverId}/credentials"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public void storeCredentials(@PathVariable(value="serverId") long testAutomationServerId, @RequestBody ManageableCredentials credentials) {
        this.credentialsService.storeCredentials(testAutomationServerId, credentials);
    }

    @RequestMapping(value={"/{serverId}/manualSelection"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public Boolean changeManualSelection(@PathVariable(value="serverId") long serverId, @RequestParam(value="value") Boolean manualSelection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Change manual slave selection for test automation server of id #{}", (Object)serverId);
        }
        this.service.changeManualSlaveSelection(serverId, manualSelection.booleanValue());
        return manualSelection;
    }

    @RequestMapping(value={"/{serverId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteTestAutomationServer(@PathVariable List<Long> serverId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Delete test automation server of id #{}", serverId);
        }
        this.service.deleteServer(serverId);
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public void createNew(@RequestBody NewTestAutomationServer server) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Add new Test automation server : {}", (Object)ToStringBuilder.reflectionToString((Object)((Object)server)));
        }
        this.service.persist(server.createTransientEntity());
    }

    @RequestMapping(value={"/{serverId}/usage-status"}, method={RequestMethod.GET})
    @ResponseBody
    public TAUsageStatus getTestAutomationUsageStatus(@PathVariable List<Long> serverId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Delete test automation server of id #{}", serverId);
        }
        ArrayList<TAUsageStatus> liste = new ArrayList<TAUsageStatus>();
        for (Long id : serverId) {
            boolean hasBoundProject = this.service.hasBoundProjects(id.longValue());
            boolean hasExecutedTests = this.service.hasExecutedTests(id.longValue());
            TAUsageStatus taUsage = new TAUsageStatus(hasBoundProject, hasExecutedTests);
            liste.add(taUsage);
        }
        TAUsageStatus tABoolean = new TAUsageStatus(true);
        for (TAUsageStatus taUsageStatus : liste) {
            if (taUsageStatus.isHasBoundProject() || taUsageStatus.isHasExecutedTests()) continue;
            tABoolean = new TAUsageStatus(false);
        }
        return tABoolean;
    }
}

