/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testautomation;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.service.testautomation.TestAutomationProjectManagerService;
import org.squashtest.tm.web.internal.controller.testautomation.TestAutomationServerController;
import org.squashtest.tm.web.internal.model.testautomation.TAUsageStatus;

@Controller
@RequestMapping(value={"/test-automation-projects"})
public class TestAutomationProjectController {
    @Inject
    private TestAutomationProjectManagerService service;
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationServerController.class);
    private static final String PROJECT_ID = "/{projectId}";

    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteTestAutomationProject(@PathVariable long projectId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Delete test automation project of id #{}", (Object)projectId);
        }
        this.service.deleteProject(projectId);
    }

    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public void editTestAutomationProject(@PathVariable long projectId, @RequestBody TestAutomationProject newValues) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Edit test automation project of id #{}", (Object)projectId);
        }
        try {
            this.service.editProject(projectId, newValues);
        }
        catch (DomainException de) {
            de.setObjectName("ta-project");
            throw de;
        }
    }

    @RequestMapping(value={"/{projectId}/usage-status"}, method={RequestMethod.GET})
    @ResponseBody
    public TAUsageStatus getTestAutomationUsageStatus(@PathVariable List<Long> projectId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Delete test automation server of id #{}", projectId);
        }
        ArrayList<TAUsageStatus> liste = new ArrayList<TAUsageStatus>();
        for (Long id : projectId) {
            boolean hasExecutedTests = this.service.hasExecutedTests(id.longValue());
            TAUsageStatus taUsage = new TAUsageStatus(hasExecutedTests);
            liste.add(taUsage);
        }
        TAUsageStatus tABoolean = new TAUsageStatus(true);
        for (TAUsageStatus taUsageStatus : liste) {
            if (taUsageStatus.isHasExecutedTests()) continue;
            tABoolean = new TAUsageStatus(false);
        }
        return tABoolean;
    }
}

