/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testautomation;

import java.util.ArrayList;
import java.util.Arrays;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.testautomation.model.TestAutomationProjectContent;

public class TestAutomationProjectContentModel {
    private TestAutomationProjectModel project;
    private AutomatedTestModel[] tests;
    private boolean orderGuaranteed;

    public TestAutomationProjectContentModel(TestAutomationProjectContent content) {
        this.project = new TestAutomationProjectModel(content.getProject());
        this.orderGuaranteed = content.isOrderGuaranteed();
        ArrayList<AutomatedTestModel> tmodels = new ArrayList<AutomatedTestModel>(content.getTests().size());
        for (AutomatedTest test : content.getTests()) {
            tmodels.add(new AutomatedTestModel(test));
        }
        this.tests = tmodels.toArray(new AutomatedTestModel[tmodels.size()]);
    }

    public TestAutomationProjectModel getProject() {
        return this.project;
    }

    public void setProject(TestAutomationProjectModel project) {
        this.project = project;
    }

    public AutomatedTestModel[] getTests() {
        return this.tests;
    }

    public void setTests(AutomatedTestModel[] tests) {
        this.tests = tests == null ? null : Arrays.copyOf(tests, tests.length);
    }

    public boolean isOrderGuaranteed() {
        return this.orderGuaranteed;
    }

    public void setOrderGuaranteed(boolean orderGuaranteed) {
        this.orderGuaranteed = orderGuaranteed;
    }

    private static final class AutomatedTestModel {
        private String name;

        public AutomatedTestModel(AutomatedTest test) {
            this.name = test.getName();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static final class TestAutomationProjectModel {
        private Long id;
        private String jobName;
        private String label;
        private String[] nodes;
        private TestAutomationServerModel server;

        public TestAutomationProjectModel(TestAutomationProject project) {
            this.id = project.getId();
            this.jobName = project.getJobName();
            this.label = project.getLabel();
            this.nodes = project.getSlaves().trim().replaceAll("\\s*;\\s*", ";").split(";");
            if (project.getServer() != null) {
                this.server = new TestAutomationServerModel(project.getServer());
            }
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getJobName() {
            return this.jobName;
        }

        public void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String[] getNodes() {
            return this.nodes;
        }

        public void setNodes(String[] nodes) {
            this.nodes = nodes == null ? null : Arrays.copyOf(nodes, nodes.length);
        }

        public TestAutomationServerModel getServer() {
            return this.server;
        }

        public void setServer(TestAutomationServerModel server) {
            this.server = server;
        }
    }

    public static final class TestAutomationServerModel {
        private Long id;
        private String name;
        private String url;
        private String kind;
        private boolean manualSlaveSelection;

        public TestAutomationServerModel(TestAutomationServer server) {
            this.id = server.getId();
            this.name = server.getName();
            this.url = server.getUrl();
            this.kind = server.getKind();
            this.manualSlaveSelection = server.isManualSlaveSelection();
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getKind() {
            return this.kind;
        }

        public void setKind(String kind) {
            this.kind = kind;
        }

        public boolean isManualSlaveSelection() {
            return this.manualSlaveSelection;
        }

        public void setManualSlaveSelection(boolean manualSlaveSelection) {
            this.manualSlaveSelection = manualSlaveSelection;
        }
    }
}

