/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.testautomation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.testautomation.AutomatedSuiteManagerService;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteCreationSpecification;
import org.squashtest.tm.service.testautomation.model.AutomatedSuitePreview;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteWithSquashAutomAutomatedITPIs;
import org.squashtest.tm.service.testautomation.model.SuiteExecutionConfiguration;
import org.squashtest.tm.service.testautomation.model.TestAutomationProjectContent;
import org.squashtest.tm.web.internal.controller.execution.AutomatedExecutionViewUtils;
import org.squashtest.tm.web.internal.controller.testautomation.TestAutomationProjectContentModel;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

@Controller
@RequestMapping(value={"/automated-suites"})
public class AutomatedSuiteManagementController {
    private static final String SLASH_NEW = "/new";
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomatedSuiteManagementController.class);
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private AutomatedSuiteManagerService service;

    @RequestMapping(value={"/preview"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    @ResponseBody
    public AutomatedSuitePreview generateSuitePreview(@RequestBody AutomatedSuiteCreationSpecification specification) {
        return this.service.preview(specification);
    }

    @RequestMapping(value={"/automated-tpi-ids"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    @ResponseBody
    public List<Long> findTpiIdsWithAutomaticExecutionMode(@RequestBody EntityReference entityReference) {
        return this.service.findTpiIdsWithAutomaticExecutionMode(entityReference);
    }

    @RequestMapping(value={"/preview/test-list"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"}, params={"auto-project-id"})
    @ResponseBody
    public List<String> findTestListPreview(@RequestBody AutomatedSuiteCreationSpecification specification, @RequestParam(value="auto-project-id") Long automatedProjectId) {
        return this.service.findTestListPreview(specification, automatedProjectId.longValue());
    }

    @RequestMapping(value={"/create-and-execute"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    @ResponseBody
    public AutomatedExecutionViewUtils.AutomatedSuiteOverview createAndExecute(@RequestBody AutomatedSuiteCreationSpecification specification, Locale locale) {
        AutomatedSuiteWithSquashAutomAutomatedITPIs suite = this.service.createAndExecute(specification);
        Date startDate = new Date();
        LOGGER.debug("START CREATING AUTOMATED SUITE OVERVIEW " + startDate);
        AutomatedExecutionViewUtils.AutomatedSuiteOverview automatedSuiteOverview = AutomatedExecutionViewUtils.buildExecInfo(suite, locale, this.messageSource);
        Date endDate = new Date();
        LOGGER.debug("END CREATING AUTOMATED SUITE OVERVIEW " + endDate);
        return automatedSuiteOverview;
    }

    @Deprecated
    @RequestMapping(value={"/new"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public AutomatedSuiteDetails createFromSpecification(@RequestBody AutomatedSuiteCreationSpecification specification) {
        AutomatedSuite suite = this.service.createFromSpecification(specification);
        return this.toProjectContentModel(suite);
    }

    @RequestMapping(value={"/{suiteId}/executor"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public AutomatedExecutionViewUtils.AutomatedSuiteOverview runAutomatedSuite(@PathVariable String suiteId, @RequestBody Collection<Map<String, ?>> rawConf, Locale locale) {
        ArrayList<SuiteExecutionConfiguration> configuration = new ArrayList<SuiteExecutionConfiguration>(rawConf.size());
        for (Map<String, ?> rawC : rawConf) {
            long projectId = ((Integer)rawC.get("projectId")).longValue();
            String node = (String)rawC.get("node");
            configuration.add(new SuiteExecutionConfiguration(Long.valueOf(projectId), node));
        }
        this.service.start(suiteId, configuration);
        return this.updateExecutionInfo(suiteId, locale);
    }

    @RequestMapping(value={"/{suiteId}/executions"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public AutomatedExecutionViewUtils.AutomatedSuiteOverview updateExecutionInfo(@PathVariable String suiteId, Locale locale) {
        AutomatedSuite suite = this.service.findById(suiteId);
        return AutomatedExecutionViewUtils.buildExecInfo(suite, locale, this.messageSource);
    }

    @RequestMapping(value={"/{suiteId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteAutomatedSuite(@PathVariable(value="suiteId") String suiteId) {
        this.service.delete(suiteId);
    }

    @RequestMapping(value={"/{suiteId}/details"}, method={RequestMethod.GET}, produces={"application/json"})
    public AutomatedSuiteDetails getSuiteDetails(@PathVariable(value="suiteId") String suiteId) {
        AutomatedSuite suite = this.service.findById(suiteId);
        return this.toProjectContentModel(suite);
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.POST}, params={"iterationId", "!testPlanItemsIds[]"}, produces={"application/json"})
    @ResponseBody
    public AutomatedSuiteDetails createNewAutomatedSuiteForIteration(@RequestParam(value="iterationId") long iterationId) {
        AutomatedSuite suite = this.service.createFromIterationTestPlan(iterationId);
        return this.toProjectContentModel(suite);
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.POST}, params={"testSuiteId", "!testPlanItemsIds[]"}, produces={"application/json"})
    @ResponseBody
    public AutomatedSuiteDetails createNewAutomatedSuiteForTestSuite(@RequestParam(value="testSuiteId") long testSuiteId) {
        AutomatedSuite suite = this.service.createFromTestSuiteTestPlan(testSuiteId);
        return this.toProjectContentModel(suite);
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.POST}, params={"testPlanItemsIds[]", "iterationId"}, produces={"application/json"})
    @ResponseBody
    public AutomatedSuiteDetails createNewAutomatedSuiteForIterationItems(@RequestParam(value="testPlanItemsIds[]") List<Long> testPlanIds, @RequestParam(value="iterationId") long iterationId) {
        if (testPlanIds.isEmpty()) {
            this.createNewAutomatedSuiteForIteration(iterationId);
        }
        AutomatedSuite suite = this.service.createFromItemsAndIteration(testPlanIds, iterationId);
        return this.toProjectContentModel(suite);
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.POST}, params={"testPlanItemsIds[]", "testSuiteId"}, produces={"application/json"})
    @ResponseBody
    public AutomatedSuiteDetails createNewAutomatedSuiteForTestSuiteItems(@RequestParam(value="testPlanItemsIds[]") List<Long> testPlanIds, @RequestParam(value="testSuiteId") long testSuiteId) {
        if (testPlanIds.isEmpty()) {
            this.createNewAutomatedSuiteForTestSuite(testSuiteId);
        }
        AutomatedSuite suite = this.service.createFromItemsAndTestSuite(testPlanIds, testSuiteId);
        return this.toProjectContentModel(suite);
    }

    private AutomatedSuiteDetails toProjectContentModel(AutomatedSuite suite) {
        Collection projectContents = this.service.sortByProject(suite);
        ArrayList<TestAutomationProjectContentModel> models = new ArrayList<TestAutomationProjectContentModel>(projectContents.size());
        for (TestAutomationProjectContent content : projectContents) {
            models.add(new TestAutomationProjectContentModel(content));
        }
        return new AutomatedSuiteDetails(suite, models);
    }

    private static final class AutomatedSuiteDetails {
        private final String id;
        private final Collection<TestAutomationProjectContentModel> contexts;
        private final boolean manualNodeSelection;

        public AutomatedSuiteDetails(AutomatedSuite suite, Collection<TestAutomationProjectContentModel> projectContents) {
            this.id = suite.getId();
            this.contexts = projectContents;
            this.manualNodeSelection = suite.isManualNodeSelection();
        }

        public String getId() {
            return this.id;
        }

        public Collection<TestAutomationProjectContentModel> getContexts() {
            return this.contexts;
        }

        public boolean isManualNodeSelection() {
            return this.manualNodeSelection;
        }
    }
}

