/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.search.advanced.tablemodels;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;

public class TestCaseSearchResultDataTableModelBuilder
extends DataTableModelBuilder<TestCase> {
    private InternationalizationHelper messageSource;
    private Locale locale;
    private PermissionEvaluationService permissionService;
    private IterationModificationService iterationService;
    private boolean isInAssociationContext;
    private Set<Long> associatedTestCaseIds;

    public TestCaseSearchResultDataTableModelBuilder(Locale locale, InternationalizationHelper messageSource, PermissionEvaluationService permissionService, IterationModificationService iterationService, boolean isInAssociationContext, Set<Long> associatedTestCaseIds) {
        this.locale = locale;
        this.messageSource = messageSource;
        this.permissionService = permissionService;
        this.iterationService = iterationService;
        this.isInAssociationContext = isInAssociationContext;
        this.associatedTestCaseIds = associatedTestCaseIds;
    }

    private String formatImportance(TestCaseImportance importance, Locale locale) {
        return String.valueOf(importance.getLevel()) + "-" + this.messageSource.internationalize((Internationalizable)importance, locale);
    }

    private String formatStatus(TestCaseStatus status, Locale locale) {
        return String.valueOf(status.getLevel()) + "-" + this.messageSource.internationalize((Internationalizable)status, locale);
    }

    private String formatAutomatable(TestCaseAutomatable automatable, Locale locale) {
        return String.valueOf(automatable.getLevel()) + "-" + this.messageSource.internationalize((Internationalizable)automatable, locale);
    }

    private String formatAutomationStatus(AutomationRequestStatus automationRequestStatus, Locale locale) {
        return String.valueOf(automationRequestStatus.getLevel()) + "-" + this.messageSource.internationalize((Internationalizable)automationRequestStatus, locale);
    }

    private boolean isTestCaseEditable(TestCase item) {
        return item.isModifiable() && this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "WRITE", (Object)item);
    }

    private boolean isInAssociationContext() {
        return this.isInAssociationContext;
    }

    public Map<String, Object> buildItemData(TestCase item) {
        TestCase auditable = item;
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("project-name", HtmlUtils.htmlEscape((String)item.getProject().getName()));
        res.put("project-id", item.getProject().getId());
        if (this.isInAssociationContext()) {
            res.put("empty-is-associated-holder", " ");
            res.put("is-associated", this.associatedTestCaseIds.contains(item.getId()));
        }
        res.put("entity-index", this.getCurrentIndex());
        res.put("test-case-id", item.getId());
        res.put("test-case-ref", HtmlUtils.htmlEscape((String)item.getReference()));
        res.put("test-case-label", HtmlUtils.htmlEscape((String)item.getName()));
        res.put("editable", this.isTestCaseEditable(item));
        res.put("test-case-weight", this.formatImportance(item.getImportance(), this.locale));
        res.put("test-case-weight-auto", item.getImportanceAuto());
        res.put("test-case-nature", HtmlUtils.htmlEscape((String)this.formatInfoItem(item.getNature(), this.locale)));
        res.put("test-case-type", HtmlUtils.htmlEscape((String)this.formatInfoItem(item.getType(), this.locale)));
        res.put("test-case-status", this.formatStatus(item.getStatus(), this.locale));
        res.put("test-case-milestone-nb", item.getMilestones().size());
        res.put("test-case-requirement-nb", item.getVerifiedRequirementVersions().size());
        res.put("test-case-teststep-nb", item.getSteps().size());
        res.put("test-case-iteration-nb", this.iterationService.findIterationContainingTestCase(item.getId().longValue()).size());
        res.put("test-case-attachment-nb", item.getAllAttachments().size());
        res.put("test-case-created-by", HtmlUtils.htmlEscape((String)TestCaseSearchResultDataTableModelBuilder.formatUsername(auditable.getCreatedBy())));
        res.put("test-case-modified-by", HtmlUtils.htmlEscape((String)TestCaseSearchResultDataTableModelBuilder.formatUsername(auditable.getLastModifiedBy())));
        if (item.getProject().isAllowAutomationWorkflow()) {
            res.put("test-case-automatable", this.formatAutomatable(item.getAutomatable(), this.locale));
            res.put("test-case-automation-request-status", item.getAutomationRequest() != null ? this.formatAutomationStatus(item.getAutomationRequest().getRequestStatus(), this.locale) : "-");
        } else {
            res.put("test-case-automatable", "-");
            res.put("test-case-automation-request-status", "-");
        }
        res.put("empty-openinterface2-holder", " ");
        res.put("empty-opentree-holder", " ");
        return res;
    }

    private String formatInfoItem(InfoListItem item, Locale locale) {
        return this.messageSource.getMessage(item.getLabel(), null, item.getLabel(), locale);
    }
}

