/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.search.advanced.tablemodels;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;

public class RequirementSearchResultDataTableModelBuilder
extends DataTableModelBuilder<RequirementVersion> {
    private boolean isInAssociationContext;
    private Set<Long> associatedRequirementIds;
    private InternationalizationHelper messageSource;
    private PermissionEvaluationService permissionService;
    private Locale locale;

    private boolean isInAssociationContext() {
        return this.isInAssociationContext;
    }

    private String formatStatus(RequirementStatus status, Locale locale) {
        return String.valueOf(status.getLevel()) + "-" + this.messageSource.internationalize((Internationalizable)status, locale);
    }

    private String formatCriticality(RequirementCriticality criticality, Locale locale) {
        return String.valueOf(criticality.getLevel()) + "-" + this.messageSource.internationalize((Internationalizable)criticality, locale);
    }

    private String formatInfoItem(InfoListItem item, Locale locale) {
        return this.messageSource.getMessage(item.getLabel(), null, item.getLabel(), locale);
    }

    public RequirementSearchResultDataTableModelBuilder(Locale locale, InternationalizationHelper messageSource, PermissionEvaluationService permissionService, boolean isInAssociationContext, Set<Long> associatedTestCaseIds) {
        this.locale = locale;
        this.permissionService = permissionService;
        this.messageSource = messageSource;
        this.isInAssociationContext = isInAssociationContext;
        this.associatedRequirementIds = associatedTestCaseIds;
    }

    protected Map<String, Object> buildItemData(RequirementVersion item) {
        RequirementVersion auditable = item;
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("project-name", HtmlUtils.htmlEscape((String)item.getProject().getName()));
        res.put("project-id", item.getProject().getId());
        if (this.isInAssociationContext()) {
            res.put("empty-is-associated-holder", " ");
            res.put("is-associated", this.associatedRequirementIds.contains(item.getId()));
        }
        res.put("entity-index", this.getCurrentIndex());
        res.put("requirement-id", item.getRequirement().getId());
        res.put("requirement-version-id", item.getId());
        res.put("requirement-reference", HtmlUtils.htmlEscape((String)item.getReference()));
        res.put("requirement-label", HtmlUtils.htmlEscape((String)item.getName()));
        res.put("editable", this.isRequirementVersionEditable(item));
        res.put("requirement-criticality", this.formatCriticality(item.getCriticality(), this.locale));
        res.put("requirement-category", this.formatInfoItem(item.getCategory(), this.locale));
        res.put("requirement-status", this.formatStatus(item.getStatus(), this.locale));
        res.put("requirement-milestone-nb", item.getMilestones().size());
        res.put("requirement-version", item.getVersionNumber());
        res.put("requirement-version-nb", item.getRequirement().getRequirementVersions().size());
        res.put("requirement-testcase-nb", item.getVerifyingTestCases().size());
        res.put("requirement-attachment-nb", item.getAttachmentList().size());
        res.put("requirement-created-by", HtmlUtils.htmlEscape((String)RequirementSearchResultDataTableModelBuilder.formatUsername(auditable.getCreatedBy())));
        res.put("requirement-modified-by", HtmlUtils.htmlEscape((String)RequirementSearchResultDataTableModelBuilder.formatUsername(auditable.getLastModifiedBy())));
        res.put("empty-openinterface2-holder", " ");
        res.put("empty-opentree-holder", " ");
        return res;
    }

    private boolean isRequirementVersionEditable(RequirementVersion item) {
        return item.isModifiable() && this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "WRITE", (Object)item);
    }
}

