/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.search.advanced.tablemodels;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;

public class CampaignSearchResultDataTableModelBuilder
extends DataTableModelBuilder<IterationTestPlanItem> {
    private InternationalizationHelper messageSource;
    private Locale locale;
    private PermissionEvaluationService permissionService;

    public CampaignSearchResultDataTableModelBuilder(Locale locale, InternationalizationHelper messageSource, PermissionEvaluationService permissionService) {
        this.locale = locale;
        this.messageSource = messageSource;
        this.permissionService = permissionService;
    }

    private boolean isExecutionEditable(IterationTestPlanItem item) {
        return this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "WRITE", (Object)item);
    }

    public Map<String, Object> buildItemData(IterationTestPlanItem item) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("project-name", HtmlUtils.htmlEscape((String)item.getProject().getName()));
        res.put("project-id", item.getProject().getId());
        res.put("entity-index", this.getCurrentIndex());
        res.put("campaign-name", HtmlUtils.htmlEscape((String)item.getCampaign().getName()));
        res.put("iteration-name", HtmlUtils.htmlEscape((String)item.getIteration().getName()));
        res.put("iteration-id", item.getIteration().getId());
        res.put("editable", this.isExecutionEditable(item));
        res.put("itpi-id", item.getId().toString());
        res.put("tc-weight", item.isTestCaseDeleted() ? "" : this.formatImportance(item.getReferencedTestCase().getImportance(), this.locale));
        res.put("itpi-isauto", item.isAutomated());
        res.put("itpi-label", item.isTestCaseDeleted() ? "" : HtmlUtils.htmlEscape((String)item.getReferencedTestCase().getName()));
        res.put("is-tc-deleted", item.isTestCaseDeleted());
        res.put("itpi-mode", this.formatMode(item.getExecutionMode(), this.locale));
        res.put("itpi-testsuites", item.getTestSuiteNames());
        res.put("itpi-status", this.formatExecutionStatus(item.getExecutionStatus(), this.locale));
        res.put("itpi-executed-by", HtmlUtils.htmlEscape((String)CampaignSearchResultDataTableModelBuilder.formatUsername(item.getLastExecutedBy())));
        res.put("itpi-executed-on", this.formatDateItem(item));
        res.put("itpi-datasets", this.formatDatasetsItem(item));
        res.put("empty-opentree-holder", " ");
        res.put("empty-openinterface2-holder", " ");
        if (item.getProject().isAllowAutomationWorkflow()) {
            res.put("test-case-automation-request-status", item.getReferencedTestCase() != null && item.getReferencedTestCase().getAutomationRequest() != null ? this.formatAutomationRequestStatus(item.getReferencedTestCase().getAutomationRequest().getRequestStatus(), this.locale) : "-");
            res.put("test-case-automatable", item.getReferencedTestCase() != null ? this.formatTcAutomatable(item.getReferencedTestCase().getAutomatable(), this.locale) : "");
        } else {
            res.put("test-case-automatable", "-");
            res.put("test-case-automation-request-status", "-");
        }
        return res;
    }

    private String formatExecutionStatus(ExecutionStatus status, Locale locale) {
        return String.valueOf(status.getLevel()) + "-" + this.messageSource.internationalize((Internationalizable)status, locale);
    }

    private String formatMode(TestCaseExecutionMode mode, Locale locale) {
        return this.messageSource.internationalize((Internationalizable)mode, locale);
    }

    private String formatImportance(TestCaseImportance importance, Locale locale) {
        return String.valueOf(importance.getLevel()) + "-" + this.messageSource.internationalize((Internationalizable)importance, locale);
    }

    private String formatTcAutomatable(TestCaseAutomatable testCaseAutomatable, Locale locale) {
        return String.valueOf(testCaseAutomatable.getLevel()) + "-" + this.messageSource.internationalize((Internationalizable)testCaseAutomatable, locale);
    }

    private String formatAutomationRequestStatus(AutomationRequestStatus automationRequestStatus, Locale locale) {
        return String.valueOf(automationRequestStatus.getLevel()) + "-" + this.messageSource.internationalize((Internationalizable)automationRequestStatus, locale);
    }

    private String formatDatasetsItem(IterationTestPlanItem item) {
        String dataset = "-";
        if (item.getReferencedDataset() != null) {
            dataset = HtmlUtils.htmlEscape((String)item.getReferencedDataset().getName());
        }
        return dataset;
    }

    private String formatDateItem(IterationTestPlanItem item) {
        String reportDate = "-";
        if (item.getLastExecutedOn() != null) {
            reportDate = this.messageSource.localizeDate(item.getLastExecutedOn(), this.locale);
        }
        return reportDate;
    }
}

