/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.search.advanced.searchinterface;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.service.internal.dto.json.JsonInfoList;
import org.squashtest.tm.service.internal.dto.json.JsonInfoListItem;
import org.squashtest.tm.service.internal.dto.json.JsonProject;
import org.squashtest.tm.service.testcase.TestCaseAdvancedSearchService;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputFieldModel;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputPanelModel;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputPossibleValueModel;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInterfaceDescription;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

@Component
public class TestcaseSearchInterfaceDescription
extends SearchInterfaceDescription {
    private static final String COLUMN_1 = "column1";
    @Inject
    private TestCaseAdvancedSearchService advancedSearchService;

    public SearchInputPanelModel createGeneralInfoPanel(Locale locale) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.testcase.generalinfos.panel.title", locale));
        panel.setOpen(true);
        panel.setId("general-information");
        panel.setLocation(COLUMN_1);
        panel.addCssClass("search-icon-information");
        SearchInputFieldModel idField = new SearchInputFieldModel("id", this.getMessageSource().internationalize("label.id", locale), "textfieldid");
        panel.addField(idField);
        SearchInputFieldModel referenceField = new SearchInputFieldModel("reference", this.getMessageSource().internationalize("label.reference", locale), "textfieldreference");
        panel.addField(referenceField);
        SearchInputFieldModel labelField = new SearchInputFieldModel("name", this.getMessageSource().internationalize("label.Label", locale), "textfield");
        panel.addField(labelField);
        SearchInputFieldModel descriptionField = new SearchInputFieldModel("description", this.getMessageSource().internationalize("label.Description", locale), "textarea");
        panel.addField(descriptionField);
        SearchInputFieldModel prerequisiteField = new SearchInputFieldModel("prerequisite", this.getMessageSource().internationalize("test-case.prerequisite.label", locale), "textarea");
        panel.addField(prerequisiteField);
        SearchInputFieldModel testCaseKind = new SearchInputFieldModel("kind", this.getMessageSource().internationalize("test-case.format.label", locale), "multiselect");
        panel.addField(testCaseKind);
        testCaseKind.addPossibleValue(this.optionBuilder(locale).labelI18nKey(TestCaseKind.STANDARD.getI18nKey()).optionKey(TestCase.class.getName()).selected().build());
        testCaseKind.addPossibleValue(this.optionBuilder(locale).labelI18nKey(TestCaseKind.GHERKIN.getI18nKey()).optionKey(ScriptedTestCase.class.getName()).selected().build());
        testCaseKind.addPossibleValue(this.optionBuilder(locale).labelI18nKey(TestCaseKind.KEYWORD.getI18nKey()).optionKey(KeywordTestCase.class.getName()).selected().build());
        return panel;
    }

    public SearchInputPanelModel createAttributePanel(Locale locale, Collection<JsonProject> jsProjects) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.testcase.attributes.panel.title", locale));
        panel.setOpen(true);
        panel.setId("attributes");
        panel.setLocation(COLUMN_1);
        panel.addCssClass("search-icon-attributes");
        SearchInputFieldModel importanceField = new SearchInputFieldModel("importance", this.getMessageSource().internationalize("test-case.importance.label", locale), "multiselect");
        panel.addField(importanceField);
        List<SearchInputPossibleValueModel> importanceOptions = this.levelComboBuilder((Enum[])TestCaseImportance.values()).useLocale(locale).build();
        importanceField.addPossibleValues(importanceOptions);
        SearchInputFieldModel natureField = this.buildNatureFieldModel(locale, jsProjects);
        panel.addField(natureField);
        SearchInputFieldModel typeField = this.buildTypeFieldModel(locale, jsProjects);
        panel.addField(typeField);
        SearchInputFieldModel statusField = new SearchInputFieldModel("status", this.getMessageSource().internationalize("test-case.status.label", locale), "multiselect");
        panel.addField(statusField);
        List<SearchInputPossibleValueModel> statusOptions = this.levelComboBuilder((Enum[])TestCaseStatus.values()).useLocale(locale).build();
        statusField.addPossibleValues(statusOptions);
        return panel;
    }

    public SearchInputPanelModel createAssociationPanel(Locale locale) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.testcase.association.panel.title", locale));
        panel.setOpen(true);
        panel.setId("association");
        panel.setLocation(COLUMN_1);
        panel.addCssClass("search-icon-associations");
        SearchInputFieldModel requirementsField = new SearchInputFieldModel("requirements", this.getMessageSource().internationalize("search.testcase.association.requirement.label", locale), "numericrange");
        panel.addField(requirementsField);
        SearchInputFieldModel iterationsField = new SearchInputFieldModel("iterations", this.getMessageSource().internationalize("search.testcase.association.iteration.label", locale), "exists");
        panel.addField(iterationsField);
        SearchInterfaceDescription.OptionBuilder optionBuilder = this.optionBuilder(locale);
        iterationsField.addPossibleValue(optionBuilder.labelI18nKey("search.testcase.association.iteration.atleastone").optionKey("1").build());
        iterationsField.addPossibleValue(optionBuilder.labelI18nKey("search.testcase.association.iteration.none").optionKey("0").build());
        SearchInputFieldModel executionsField = new SearchInputFieldModel("executions", this.getMessageSource().internationalize("search.testcase.association.execution.label", locale), "exists");
        panel.addField(executionsField);
        executionsField.addPossibleValue(optionBuilder.labelI18nKey("search.testcase.association.execution.atleastone").optionKey("1").build());
        executionsField.addPossibleValue(optionBuilder.labelI18nKey("search.testcase.association.execution.none").optionKey("0").build());
        SearchInputFieldModel issuesField = new SearchInputFieldModel("issues", this.getMessageSource().internationalize("search.testcase.association.issue.label", locale), "numericrange");
        panel.addField(issuesField);
        return panel;
    }

    public SearchInputPanelModel createPerimeterPanel(Locale locale, Collection<JsonProject> jsProjects) {
        return this.perimeterPanelBuilder(locale).cssClass("search-icon-perimeter").htmlId("project.id").build(jsProjects);
    }

    public SearchInputPanelModel createRequirementPerimeterPanel(Locale locale, Collection<JsonProject> jsProjects) {
        return this.perimeterPanelBuilder(locale).cssClass("search-icon-perimeter").htmlId("requirement.project.id").build(jsProjects);
    }

    public SearchInputPanelModel createContentPanel(Locale locale) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.testcase.content.panel.title", locale));
        panel.setOpen(true);
        panel.setId("content");
        panel.setLocation(COLUMN_1);
        panel.addCssClass("search-icon-content");
        SearchInputFieldModel teststepField = new SearchInputFieldModel("steps", this.getMessageSource().internationalize("search.testcase.content.teststep.label", locale), "numericrange");
        panel.addField(teststepField);
        SearchInputFieldModel parameterField = new SearchInputFieldModel("parameters", this.getMessageSource().internationalize("search.testcase.content.parameter.label", locale), "exists");
        panel.addField(parameterField);
        SearchInterfaceDescription.OptionBuilder optionBuilder = this.optionBuilder(locale);
        parameterField.addPossibleValue(optionBuilder.labelI18nKey("search.testcase.content.parameter.atleastone").optionKey("1").build());
        parameterField.addPossibleValue(optionBuilder.labelI18nKey("search.testcase.content.parameter.none").optionKey("0").build());
        SearchInputFieldModel datasetField = new SearchInputFieldModel("datasets", this.getMessageSource().internationalize("search.testcase.content.dataset.label", locale), "exists");
        panel.addField(datasetField);
        datasetField.addPossibleValue(optionBuilder.labelI18nKey("search.testcase.content.dataset.atleastone").optionKey("1").build());
        datasetField.addPossibleValue(optionBuilder.labelI18nKey("search.testcase.content.dataset.none").optionKey("0").build());
        SearchInputFieldModel callstepField = new SearchInputFieldModel("callsteps", this.getMessageSource().internationalize("search.testcase.content.callstep.label", locale), "exists");
        panel.addField(callstepField);
        callstepField.addPossibleValue(optionBuilder.labelI18nKey("search.testcase.content.callstep.atleastone").optionKey("1").build());
        callstepField.addPossibleValue(optionBuilder.labelI18nKey("search.testcase.content.callstep.none").optionKey("0").build());
        SearchInputFieldModel attachmentField = new SearchInputFieldModel("attachments", this.getMessageSource().internationalize("search.testcase.content.attachment.label", locale), "exists");
        panel.addField(attachmentField);
        attachmentField.addPossibleValue(optionBuilder.labelI18nKey("search.testcase.content.attachment.atleastone").optionKey("1").build());
        attachmentField.addPossibleValue(optionBuilder.labelI18nKey("search.testcase.content.attachment.none").optionKey("0").build());
        return panel;
    }

    public SearchInputPanelModel createTestCaseHistoryPanel(Locale locale, List<Long> idList) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.testcase.history.panel.title", locale));
        panel.setOpen(true);
        panel.setId("history");
        panel.setLocation(COLUMN_1);
        panel.addCssClass("search-icon-history");
        SearchInterfaceDescription.OptionBuilder optionBuilder = this.optionBuilder(locale);
        SearchInputFieldModel createdByField = new SearchInputFieldModel("createdBy", this.getMessageSource().internationalize("search.testcase.history.createdBy.label", locale), "multiautocomplete");
        panel.addField(createdByField);
        List users = this.advancedSearchService.findAllUsersWhoCreatedTestCases(idList);
        for (String user : users) {
            createdByField.addPossibleValue(optionBuilder.label(user).optionKey(user).build());
        }
        SearchInputFieldModel createdOnField = new SearchInputFieldModel("createdOn", this.getMessageSource().internationalize("search.testcase.history.createdOn.label", locale), "date");
        panel.addField(createdOnField);
        SearchInputFieldModel modifiedByField = new SearchInputFieldModel("lastModifiedBy", this.getMessageSource().internationalize("search.testcase.history.modifiedBy.label", locale), "multiautocomplete");
        panel.addField(modifiedByField);
        List users2 = this.advancedSearchService.findAllUsersWhoModifiedTestCases(idList);
        for (String user : users2) {
            if (StringUtils.isBlank((CharSequence)user)) {
                modifiedByField.addPossibleValue(optionBuilder.labelI18nKey("label.NeverModified").optionKey("").build());
                continue;
            }
            modifiedByField.addPossibleValue(optionBuilder.label(user).optionKey(user).build());
        }
        SearchInputFieldModel modifiedOnField = new SearchInputFieldModel("lastModifiedOn", this.getMessageSource().internationalize("search.testcase.history.modifiedOn.label", locale), "date");
        panel.addField(modifiedOnField);
        return panel;
    }

    public SearchInputPanelModel createAutomationPanel(Locale locale) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.testcase.automation.panel.title", locale));
        panel.setOpen(true);
        panel.setId("automation");
        panel.setLocation(COLUMN_1);
        panel.addCssClass("search-icon-automation");
        SearchInputFieldModel automationField = new SearchInputFieldModel("automatable", this.getMessageSource().internationalize("test-case.automation-indicator.label", locale), "multiselect");
        panel.addField(automationField);
        List<SearchInputPossibleValueModel> automationOptions = this.levelComboBuilder((Enum[])TestCaseAutomatable.values()).useLocale(locale).build();
        automationField.addPossibleValues(automationOptions);
        SearchInputFieldModel automationRequestField = new SearchInputFieldModel("automationRequest.requestStatus", this.getMessageSource().internationalize("test-case.automation-status.label", locale), "multiselect");
        panel.addField(automationRequestField);
        List<SearchInputPossibleValueModel> automationRequestOptions = this.levelComboBuilder((Enum[])AutomationRequestStatus.values()).useLocale(locale).build();
        automationRequestField.addPossibleValues(automationRequestOptions);
        return panel;
    }

    private SearchInputFieldModel buildNatureFieldModel(Locale locale, Collection<JsonProject> jsProjects) {
        SearchInputFieldModel natureField = new SearchInputFieldModel("nature", this.getMessageSource().internationalize("test-case.nature.label", locale), "multicascadeflat");
        ArrayList<JsonInfoList> natures = new ArrayList<JsonInfoList>();
        for (JsonProject p : jsProjects) {
            natures.add(p.getTestCaseNatures());
        }
        this.populateInfoListFieldModel(natureField, natures, locale);
        return natureField;
    }

    private SearchInputFieldModel buildTypeFieldModel(Locale locale, Collection<JsonProject> jsProjects) {
        SearchInputFieldModel typeField = new SearchInputFieldModel("type", this.getMessageSource().internationalize("test-case.type.label", locale), "multicascadeflat");
        ArrayList<JsonInfoList> types = new ArrayList<JsonInfoList>();
        for (JsonProject p : jsProjects) {
            types.add(p.getTestCaseTypes());
        }
        this.populateInfoListFieldModel(typeField, types, locale);
        return typeField;
    }

    private void populateInfoListFieldModel(SearchInputFieldModel model, Collection<JsonInfoList> infoLists, Locale locale) {
        InternationalizationHelper messages = this.getMessageSource();
        HashMap<String, SearchInputPossibleValueModel> listsByListCode = new HashMap<String, SearchInputPossibleValueModel>();
        for (JsonInfoList list : infoLists) {
            if (listsByListCode.containsKey(list.getCode())) continue;
            String listName = messages.getMessage(list.getLabel(), null, list.getLabel(), locale);
            String listCode = list.getCode();
            SearchInputPossibleValueModel listValues = new SearchInputPossibleValueModel(listName, listCode);
            SearchInputFieldModel subInput = new SearchInputFieldModel();
            for (JsonInfoListItem item : list.getItems()) {
                String itemName = messages.getMessage(item.getLabel(), null, item.getLabel(), locale);
                String itemCode = item.getCode();
                subInput.addPossibleValue(new SearchInputPossibleValueModel(itemName, itemCode));
            }
            listValues.setSubInput(subInput);
            listsByListCode.put(list.getCode(), listValues);
        }
        model.setPossibleValues(new ArrayList<SearchInputPossibleValueModel>(listsByListCode.values()));
    }
}

