/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.search.advanced.searchinterface;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import org.springframework.context.i18n.LocaleContextHolder;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.LevelComparator;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.service.internal.dto.json.JsonMilestone;
import org.squashtest.tm.service.internal.dto.json.JsonProject;
import org.squashtest.tm.service.testcase.TestCaseAdvancedSearchService;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.LevelComboDataBuilder;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputFieldModel;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputPanelModel;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputPossibleValueModel;
import org.squashtest.tm.web.internal.helper.InternationalizableLabelFormatter;
import org.squashtest.tm.web.internal.helper.LevelLabelFormatter;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.EnumJeditableComboDataBuilder;

public abstract class SearchInterfaceDescription {
    protected static final String TEXTFIELD = "textfield";
    protected static final String TEXTFIELDID = "textfieldid";
    protected static final String TEXTFIELDREFERENCE = "textfieldreference";
    protected static final String TEXTAREA = "textarea";
    protected static final String RANGE = "range";
    protected static final String NUMERICRANGE = "numericrange";
    protected static final String EXISTS = "exists";
    protected static final String DATE = "date";
    protected static final String MULTISELECT = "multiselect";
    protected static final String MULTISELECTPERIMETER = "multiselectperimeter";
    protected static final String MULTIAUTOCOMPLETE = "multiautocomplete";
    protected static final String MULTICASCADEFLAT = "multicascadeflat";
    protected static final String RADIOBUTTON = "radiobutton";
    protected static final String CHECKBOX = "checkbox";
    protected static final String ATLEASTONE = "1";
    protected static final String NONE = "0";
    protected static final String EMPTY = "";
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    protected static final String COMBOEXISTSMULTISELECT = "comboexistsmultiselect";
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private Provider<LevelLabelFormatter> levelLabelFormatter;
    @Inject
    private Provider<InternationalizableLabelFormatter> internationalizableLabelFormatter;
    @Inject
    TestCaseAdvancedSearchService advancedSearchService;

    public SearchInputPanelModel createMilestonePanel(Locale locale) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("label.Milestones", locale));
        panel.setOpen(true);
        panel.setId("milestone");
        panel.setLocation("column1");
        panel.addCssClass("search-milestone-icon");
        OptionBuilder optionBuilder = this.optionBuilder(locale);
        SearchInputFieldModel searchByMilestone = new SearchInputFieldModel("searchByMilestone", this.getMessageSource().internationalize("search.milestone.search-by-milestone", locale), CHECKBOX);
        SearchInputFieldModel labelField = new SearchInputFieldModel("milestone.label", this.getMessageSource().internationalize("label.Label", locale), MULTISELECT);
        SearchInputFieldModel statusField = new SearchInputFieldModel("milestone.status", this.getMessageSource().internationalize("label.Status", locale), MULTISELECT);
        SearchInputFieldModel endDateField = new SearchInputFieldModel("milestone.endDate", this.getMessageSource().internationalize("label.EndDate", locale), DATE);
        panel.addField(searchByMilestone);
        panel.addField(labelField);
        panel.addField(statusField);
        panel.addField(endDateField);
        List milestones = this.advancedSearchService.findAllVisibleMilestonesToCurrentUser();
        Collections.sort(milestones, (p1, p2) -> p1.getLabel().compareTo(p2.getLabel()));
        for (JsonMilestone milestone : milestones) {
            String milestoneIdString = String.valueOf(milestone.getId());
            if (milestone.getStatus() == MilestoneStatus.PLANNED) continue;
            labelField.addPossibleValue(optionBuilder.label(milestone.getLabel()).optionKey(milestoneIdString).build());
        }
        List<SearchInputPossibleValueModel> statusOptions = this.levelComboBuilder((Enum[])new MilestoneStatus[]{MilestoneStatus.IN_PROGRESS, MilestoneStatus.FINISHED, MilestoneStatus.LOCKED}).useLocale(locale).build();
        statusField.addPossibleValues(statusOptions);
        return panel;
    }

    protected final <T extends Enum<?>> OptionListBuilder levelComboBuilder(T[] values) {
        return new OptionListBuilder(this.delegateLevelComboBuilder((Enum[])values));
    }

    protected final <T extends Enum<?>, B extends LevelComboDataBuilder<T, B>> EnumJeditableComboDataBuilder<T, B> delegateLevelComboBuilder(T[] values) {
        LevelComboDataBuilder builder = new LevelComboDataBuilder();
        builder.setLabelFormatter(((LevelLabelFormatter)this.levelLabelFormatter.get()).plainText());
        builder.setModel((Enum[])values);
        builder.setModelComparator(LevelComparator.getInstance());
        return builder;
    }

    protected final <T extends Enum<?>> OptionListBuilder internationalizableComboBuilder(T[] values) {
        return new OptionListBuilder(this.delegateInternationalizableComboBuilder((Enum[])values));
    }

    protected final <T extends Enum<?>, B extends EnumJeditableComboDataBuilder<T, B>> EnumJeditableComboDataBuilder<T, B> delegateInternationalizableComboBuilder(T[] values) {
        EnumJeditableComboDataBuilder builder = new EnumJeditableComboDataBuilder();
        builder.setLabelFormatter(((InternationalizableLabelFormatter)this.internationalizableLabelFormatter.get()).plainText());
        builder.setModel((Enum[])values);
        builder.setModelComparator(new InternationalizableComparator());
        return builder;
    }

    protected final InternationalizationHelper getMessageSource() {
        return this.messageSource;
    }

    protected final OptionBuilder optionBuilder(Locale locale) {
        return new OptionBuilder(locale);
    }

    public PerimeterPanelBuilder perimeterPanelBuilder(Locale locale) {
        return new PerimeterPanelBuilder(locale);
    }

    private class InternationalizableComparator
    implements Comparator<Internationalizable> {
        private InternationalizableLabelFormatter helper;

        private InternationalizableComparator() {
            this.helper = (InternationalizableLabelFormatter)((InternationalizableLabelFormatter)SearchInterfaceDescription.this.internationalizableLabelFormatter.get()).useLocale(LocaleContextHolder.getLocale());
        }

        @Override
        public int compare(Internationalizable o1, Internationalizable o2) {
            String name1 = this.helper.formatLabel(o1);
            String name2 = this.helper.formatLabel(o2);
            return name1.compareTo(name2);
        }
    }

    protected final class OptionBuilder {
        private final Locale locale;
        private String label;
        private String key;
        private boolean selected;

        private OptionBuilder(Locale locale) {
            this.locale = locale;
        }

        public OptionBuilder labelI18nKey(String i18nKey) {
            this.label = SearchInterfaceDescription.this.messageSource.internationalize(i18nKey, this.locale);
            return this;
        }

        public OptionBuilder label(String label) {
            this.label = label;
            return this;
        }

        public OptionBuilder optionKey(String key) {
            this.key = key;
            return this;
        }

        public SearchInputPossibleValueModel build() {
            SearchInputPossibleValueModel res = new SearchInputPossibleValueModel(this.label, this.key, this.selected);
            this.reset();
            return res;
        }

        private void reset() {
            this.selected = false;
        }

        public OptionBuilder selected() {
            this.selected = true;
            return this;
        }
    }

    protected final class OptionListBuilder {
        private final EnumJeditableComboDataBuilder<?, ?> delegateBuilder;
        private Locale locale;

        private OptionListBuilder(EnumJeditableComboDataBuilder<?, ?> delegateBuilder) {
            this.delegateBuilder = delegateBuilder;
        }

        public OptionListBuilder useLocale(Locale locale) {
            this.delegateBuilder.useLocale(locale);
            this.locale = locale;
            return this;
        }

        public List<SearchInputPossibleValueModel> build() {
            Map<String, String> map = this.delegateBuilder.buildMap();
            return this.decorate(map);
        }

        private List<SearchInputPossibleValueModel> decorate(Map<String, String> map) {
            OptionBuilder optionBuilder = new OptionBuilder(this.locale);
            ArrayList<SearchInputPossibleValueModel> res = new ArrayList<SearchInputPossibleValueModel>(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                res.add(optionBuilder.optionKey(entry.getKey()).label(entry.getValue()).build());
            }
            return res;
        }
    }

    protected final class PerimeterPanelBuilder {
        private final Locale locale;
        private String cssClass;
        private String htmlId;

        private PerimeterPanelBuilder(Locale locale) {
            this.locale = locale;
        }

        public PerimeterPanelBuilder cssClass(String cssClass) {
            this.cssClass = cssClass;
            return this;
        }

        public PerimeterPanelBuilder htmlId(String id) {
            this.htmlId = id;
            return this;
        }

        public SearchInputPanelModel build(Collection<JsonProject> jsProjects) {
            SearchInputPanelModel panel = new SearchInputPanelModel();
            panel.setTitle(SearchInterfaceDescription.this.messageSource.internationalize("search.testcase.perimeter.field.title", this.locale));
            panel.setOpen(true);
            panel.setId("perimeter");
            panel.setLocation("column1");
            panel.addCssClass(this.cssClass);
            SearchInputFieldModel projectField = new SearchInputFieldModel(this.htmlId, SearchInterfaceDescription.this.messageSource.internationalize("search.testcase.perimeter.field.title", this.locale), SearchInterfaceDescription.MULTISELECTPERIMETER);
            panel.addField(projectField);
            OptionBuilder optionBuilder = SearchInterfaceDescription.this.optionBuilder(this.locale);
            List orderedProjects = jsProjects.stream().sorted(Comparator.comparing(JsonProject::getName)).collect(Collectors.toList());
            for (JsonProject project : orderedProjects) {
                SearchInputPossibleValueModel projectOption = optionBuilder.label(project.getName()).optionKey(String.valueOf(project.getId())).build();
                projectField.addPossibleValue(projectOption);
            }
            return panel;
        }
    }
}

