/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.search.advanced.searchinterface;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.MultiSelectField;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.service.campaign.CampaignAdvancedSearchService;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.dto.CustomFieldModel;
import org.squashtest.tm.service.internal.dto.CustomFieldModelFactory;
import org.squashtest.tm.service.internal.dto.json.JsonProject;
import org.squashtest.tm.service.testcase.TestCaseAdvancedSearchService;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.CampaignSearchInterfaceDescription;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.RequirementVersionSearchInterfaceDescription;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputFieldModel;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputInterfaceModel;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputPanelModel;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputPossibleValueModel;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.TestcaseSearchInterfaceDescription;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

@Component
public class SearchInputInterfaceHelper {
    private static final String TEXTFIELD = "textfield";
    private static final String COMBOMULTISELECT = "combomultiselect";
    private static final String TAGS = "tags";
    private static final String REQUIREMENT = "requirement";
    @Inject
    protected InternationalizationHelper messageSource;
    @Inject
    private RequirementVersionSearchInterfaceDescription requirementVersionSearchInterfaceDescription;
    @Inject
    private TestcaseSearchInterfaceDescription testcaseVersionSearchInterfaceDescription;
    @Inject
    private CampaignSearchInterfaceDescription campaignSearchInterfaceDescription;
    @Inject
    private FeatureManager featureManager;
    @Inject
    private TestCaseAdvancedSearchService advancedSearchService;
    @Inject
    private CampaignAdvancedSearchService campaignAdvancedSearchService;

    public SearchInputInterfaceModel getRequirementSearchInputInterfaceModel(Locale locale, boolean isMilestoneMode, List<Long> readableProjectIds, Collection<JsonProject> jsProjects, Integer allowAutomationWorkflow) {
        SearchInputInterfaceModel model = new SearchInputInterfaceModel();
        model.addPanel(this.requirementVersionSearchInterfaceDescription.createRequirementPerimeterPanel(locale, jsProjects));
        model.addPanel(this.requirementVersionSearchInterfaceDescription.createRequirementInformationPanel(locale));
        model.addPanel(this.requirementVersionSearchInterfaceDescription.createRequirementHistoryPanel(locale, readableProjectIds));
        model.addPanel(this.requirementVersionSearchInterfaceDescription.createRequirementAttributePanel(locale, jsProjects));
        if (!isMilestoneMode && this.featureManager.isEnabled(FeatureManager.Feature.MILESTONE)) {
            model.addPanel(this.requirementVersionSearchInterfaceDescription.createMilestonePanel(locale));
        }
        model.addPanel(this.requirementVersionSearchInterfaceDescription.createRequirementVersionPanel(locale));
        model.addPanel(this.requirementVersionSearchInterfaceDescription.createRequirementContentPanel(locale));
        model.addPanel(this.requirementVersionSearchInterfaceDescription.createRequirementAssociationPanel(locale));
        model.addPanel(this.createCUFPanel(locale, BindableEntity.REQUIREMENT_VERSION, readableProjectIds));
        return model;
    }

    public SearchInputInterfaceModel getTestCaseSearchInputInterfaceModel(Locale locale, boolean isMilestoneMode, List<Long> readableProjectIds, Collection<JsonProject> jsProjects, Integer allowAutomationWorkflow) {
        SearchInputInterfaceModel model = new SearchInputInterfaceModel();
        model.addPanel(this.testcaseVersionSearchInterfaceDescription.createPerimeterPanel(locale, jsProjects));
        model.addPanel(this.testcaseVersionSearchInterfaceDescription.createGeneralInfoPanel(locale));
        model.addPanel(this.testcaseVersionSearchInterfaceDescription.createTestCaseHistoryPanel(locale, readableProjectIds));
        model.addPanel(this.testcaseVersionSearchInterfaceDescription.createAttributePanel(locale, jsProjects));
        if (allowAutomationWorkflow > 0) {
            model.addPanel(this.testcaseVersionSearchInterfaceDescription.createAutomationPanel(locale));
        }
        if (!isMilestoneMode && this.featureManager.isEnabled(FeatureManager.Feature.MILESTONE)) {
            model.addPanel(this.testcaseVersionSearchInterfaceDescription.createMilestonePanel(locale));
        }
        model.addPanel(this.testcaseVersionSearchInterfaceDescription.createContentPanel(locale));
        model.addPanel(this.testcaseVersionSearchInterfaceDescription.createAssociationPanel(locale));
        model.addPanel(this.createCUFPanel(locale, BindableEntity.TEST_CASE, readableProjectIds));
        return model;
    }

    public SearchInputInterfaceModel getCampaignSearchInputInterfaceModel(Locale locale, boolean isMilestoneMode, List<Long> readableProjectIds, Integer allowAutomationWorkflow) {
        SearchInputInterfaceModel model = new SearchInputInterfaceModel();
        List users = this.campaignAdvancedSearchService.findAllAuthorizedUsersForACampaign(readableProjectIds);
        model.addPanel(this.campaignSearchInterfaceDescription.createGeneralInfoPanel(locale));
        model.addPanel(this.campaignSearchInterfaceDescription.createAttributePanel(locale, users));
        if (allowAutomationWorkflow > 0) {
            model.addPanel(this.campaignSearchInterfaceDescription.createAutomationPanel(locale));
        }
        if (!isMilestoneMode && this.featureManager.isEnabled(FeatureManager.Feature.MILESTONE)) {
            model.addPanel(this.requirementVersionSearchInterfaceDescription.createMilestonePanel(locale));
        }
        model.addPanel(this.campaignSearchInterfaceDescription.createExecutionPanel(locale, users));
        return model;
    }

    private SearchInputPanelModel createCUFPanel(Locale locale, BindableEntity bindableEntity, List<Long> readableProjectIds) {
        SearchInputPanelModel panel = this.getCustomFielModel(locale, bindableEntity, readableProjectIds);
        panel.setTitle(this.messageSource.internationalize("search.testcase.cuf.panel.title", locale));
        panel.setOpen(true);
        panel.setId("cuf");
        panel.setLocation("column1");
        panel.addCssClass("search-icon-cuf");
        return panel;
    }

    private SearchInputPanelModel getCustomFielModel(Locale locale, BindableEntity bindableEntity, List<Long> readableProjectIds) {
        List customFields = this.advancedSearchService.findAllQueryableCustomFieldsByBoundEntityType(bindableEntity, readableProjectIds);
        return this.convertToSearchInputPanelModel(customFields, locale);
    }

    private SearchInputPanelModel convertToSearchInputPanelModel(List<CustomFieldModel> customFields, Locale locale) {
        SearchInputPanelModel model = new SearchInputPanelModel();
        for (CustomFieldModel customField : customFields) {
            switch (InputType.valueOf((String)customField.getInputType().getEnumName())) {
                case DROPDOWN_LIST: {
                    SingleSelectField selectField = this.convertToDropdownList(customField);
                    model.getFields().add(this.dropdownConvertToSearchInputFieldModel(selectField, locale));
                    break;
                }
                case PLAIN_TEXT: {
                    model.getFields().add(this.convertToSearchInputFieldModel(customField));
                    break;
                }
                case NUMERIC: {
                    model.getFields().add(this.createNumericRangeField(customField));
                    break;
                }
                case CHECKBOX: {
                    model.getFields().add(this.createCheckBoxField(customField, locale));
                    break;
                }
                case DATE_PICKER: {
                    model.getFields().add(this.createDateCustomFieldSearchModel(customField));
                    break;
                }
                case TAG: {
                    MultiSelectField multiSelectField = this.convertToMultiSelectField(customField);
                    model.getFields().add(this.multiSelectFieldConvertToSearchInputFieldModel(multiSelectField));
                    break;
                }
            }
        }
        return model;
    }

    private SingleSelectField convertToDropdownList(CustomFieldModel customField) {
        CustomFieldModelFactory.SingleSelectFieldModel singleSelectFieldModel = (CustomFieldModelFactory.SingleSelectFieldModel)customField;
        SingleSelectField selectField = new SingleSelectField();
        selectField.setCode(String.valueOf(customField.getId()));
        selectField.setDefaultValue(singleSelectFieldModel.getDefaultValue());
        selectField.setLabel(singleSelectFieldModel.getLabel());
        selectField.setName(singleSelectFieldModel.getName());
        selectField.setOptional(singleSelectFieldModel.isOptional());
        for (CustomFieldModelFactory.CustomFieldOptionModel optionModel : singleSelectFieldModel.getOptions()) {
            CustomFieldOption customFieldModel = new CustomFieldOption(optionModel.getLabel(), optionModel.getCode());
            if (selectField.getOptions().contains(customFieldModel) || !this.checkCodeAndLabel(customFieldModel)) continue;
            selectField.addOption(customFieldModel);
        }
        return selectField;
    }

    private boolean checkCodeAndLabel(CustomFieldOption customFieldOption) {
        return customFieldOption.getCode() != null && customFieldOption.getLabel() != null;
    }

    private MultiSelectField convertToMultiSelectField(CustomFieldModel customField) {
        CustomFieldModelFactory.MultiSelectFieldModel multiSelectFieldModel = (CustomFieldModelFactory.MultiSelectFieldModel)customField;
        MultiSelectField multiSelectField = new MultiSelectField();
        multiSelectField.setCode(String.valueOf(customField.getId()));
        multiSelectField.setLabel(multiSelectFieldModel.getLabel());
        multiSelectField.setName(multiSelectFieldModel.getName());
        multiSelectField.setOptional(multiSelectFieldModel.isOptional());
        for (CustomFieldModelFactory.CustomFieldOptionModel optionModel : multiSelectFieldModel.getOptions()) {
            CustomFieldOption customFieldOptionModel = new CustomFieldOption(optionModel.getLabel());
            if (multiSelectField.getOptions().contains(customFieldOptionModel)) continue;
            multiSelectField.addOption(optionModel.getLabel());
        }
        return multiSelectField;
    }

    private SearchInputFieldModel createDateCustomFieldSearchModel(CustomFieldModel customField) {
        SearchInputFieldModel model = new SearchInputFieldModel();
        model.setInputType("CF_TIME_INTERVAL");
        model.setTitle(customField.getLabel());
        model.setId(String.valueOf(customField.getId()));
        return model;
    }

    private SearchInputFieldModel createCheckBoxField(CustomFieldModel customFieldModel, Locale locale) {
        SearchInputFieldModel model = new SearchInputFieldModel();
        ArrayList<SearchInputPossibleValueModel> possibleValues = new ArrayList<SearchInputPossibleValueModel>();
        possibleValues.add(new SearchInputPossibleValueModel(this.messageSource.internationalize("label.True", locale), "true"));
        possibleValues.add(new SearchInputPossibleValueModel(this.messageSource.internationalize("label.False", locale), "false"));
        model.setPossibleValues(possibleValues);
        model.setInputType("CF_CHECKBOX");
        model.setTitle(customFieldModel.getLabel());
        model.setId(String.valueOf(customFieldModel.getId()));
        return model;
    }

    private SearchInputFieldModel createNumericRangeField(CustomFieldModel customField) {
        SearchInputFieldModel model = new SearchInputFieldModel();
        model.setInputType("CF_NUMERIC_RANGE");
        model.setTitle(customField.getLabel());
        model.setId(String.valueOf(customField.getId()));
        return model;
    }

    private SearchInputFieldModel convertToSearchInputFieldModel(CustomFieldModel customField) {
        SearchInputFieldModel model = new SearchInputFieldModel();
        model.setInputType("CF_SINGLE");
        model.setTitle(customField.getLabel());
        model.setId(String.valueOf(customField.getId()));
        return model;
    }

    private SearchInputFieldModel dropdownConvertToSearchInputFieldModel(SingleSelectField selectField, Locale locale) {
        ArrayList<SearchInputPossibleValueModel> possibleValues = new ArrayList<SearchInputPossibleValueModel>();
        possibleValues.add(new SearchInputPossibleValueModel(this.messageSource.internationalize("label.Empty", locale), ""));
        for (CustomFieldOption option : selectField.getOptions()) {
            possibleValues.add(new SearchInputPossibleValueModel(option.getLabel(), option.getLabel()));
        }
        SearchInputFieldModel model = new SearchInputFieldModel();
        model.setInputType("CF_LIST");
        model.setTitle(selectField.getLabel());
        model.setPossibleValues(possibleValues);
        model.setId(selectField.getCode());
        return model;
    }

    private SearchInputFieldModel multiSelectFieldConvertToSearchInputFieldModel(MultiSelectField multifield) {
        ArrayList<SearchInputPossibleValueModel> possibleValues = new ArrayList<SearchInputPossibleValueModel>(multifield.getOptions().size());
        for (CustomFieldOption option : multifield.getOptions()) {
            possibleValues.add(new SearchInputPossibleValueModel(option.getLabel(), option.getLabel()));
        }
        SearchInputFieldModel model = new SearchInputFieldModel();
        model.setInputType(TAGS);
        model.setTitle(multifield.getLabel());
        model.setPossibleValues(possibleValues);
        model.setId(multifield.getCode());
        return model;
    }
}

