/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.search.advanced.searchinterface;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.service.internal.dto.json.JsonInfoList;
import org.squashtest.tm.service.internal.dto.json.JsonInfoListItem;
import org.squashtest.tm.service.internal.dto.json.JsonProject;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.service.requirement.RequirementVersionAdvancedSearchService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputFieldModel;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputPanelModel;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputPossibleValueModel;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInterfaceDescription;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

@Component
public class RequirementVersionSearchInterfaceDescription
extends SearchInterfaceDescription {
    private static final String COLUMN_1 = "column1";
    private static final String REQUIREMENT_VERSION_LINK_TYPE_LABEL = "requirement-version.link.type";
    @Inject
    private RequirementVersionAdvancedSearchService advancedSearchService;
    @Inject
    protected UserAccountService userAccountService;
    @Inject
    LinkedRequirementVersionManagerService linkedRequirementVersionManagerService;
    private static Comparator<String> ALPHABETICAL_ORDER = new Comparator<String>(){

        @Override
        public int compare(String str1, String str2) {
            int res = String.CASE_INSENSITIVE_ORDER.compare(str1, str2);
            if (res == 0) {
                res = str1.compareTo(str2);
            }
            return res;
        }
    };

    public SearchInputPanelModel createRequirementInformationPanel(Locale locale) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.testcase.generalinfos.panel.title", locale));
        panel.setOpen(true);
        panel.setId("general-information");
        panel.setLocation(COLUMN_1);
        panel.addCssClass("search-icon-information");
        SearchInputFieldModel idField = new SearchInputFieldModel("requirement.id", this.getMessageSource().internationalize("label.id", locale), "textfieldid");
        panel.addField(idField);
        SearchInputFieldModel referenceField = new SearchInputFieldModel("reference", this.getMessageSource().internationalize("label.reference", locale), "textfieldreference");
        panel.addField(referenceField);
        SearchInputFieldModel labelField = new SearchInputFieldModel("name", this.getMessageSource().internationalize("label.Label", locale), "textfield");
        panel.addField(labelField);
        SearchInputFieldModel descriptionField = new SearchInputFieldModel("description", this.getMessageSource().internationalize("label.Description", locale), "textarea");
        panel.addField(descriptionField);
        return panel;
    }

    public SearchInputPanelModel createRequirementAttributePanel(Locale locale, Collection<JsonProject> jsProjects) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.testcase.attributes.panel.title", locale));
        panel.setOpen(true);
        panel.setId("attributes");
        panel.setLocation(COLUMN_1);
        panel.addCssClass("search-icon-attributes");
        SearchInputFieldModel criticalityField = new SearchInputFieldModel("criticality", this.getMessageSource().internationalize("requirement.criticality.label", locale), "multiselect");
        panel.addField(criticalityField);
        List<SearchInputPossibleValueModel> importanceOptions = this.levelComboBuilder((Enum[])RequirementCriticality.values()).useLocale(locale).build();
        criticalityField.addPossibleValues(importanceOptions);
        SearchInputFieldModel categoryField = this.buildCategoryFieldModel(locale, jsProjects);
        panel.addField(categoryField);
        SearchInputFieldModel statusField = new SearchInputFieldModel("status", this.getMessageSource().internationalize("requirement.status.combo.label", locale), "multiselect");
        panel.addField(statusField);
        List<SearchInputPossibleValueModel> statusOptions = this.levelComboBuilder((Enum[])RequirementStatus.values()).useLocale(locale).build();
        statusField.addPossibleValues(statusOptions);
        return panel;
    }

    public SearchInputPanelModel createRequirementVersionPanel(Locale locale) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.requirement.versions.panel.title", locale));
        panel.setOpen(true);
        panel.setId("versions");
        panel.setLocation(COLUMN_1);
        panel.addCssClass("search-icon-version");
        SearchInputFieldModel versionField = new SearchInputFieldModel("isCurrentVersion", this.getMessageSource().internationalize("search.requirement.content.version.label", locale), "radiobutton");
        versionField.setIgnoreBridge(true);
        panel.addField(versionField);
        SearchInterfaceDescription.OptionBuilder optionBuilder = this.optionBuilder(locale);
        versionField.addPossibleValue(optionBuilder.labelI18nKey("search.requirement.allVersions").optionKey("").selected().build());
        versionField.addPossibleValue(optionBuilder.labelI18nKey("search.requirement.onlyLastVersion").optionKey("1").build());
        return panel;
    }

    public SearchInputPanelModel createRequirementContentPanel(Locale locale) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.testcase.content.panel.title", locale));
        panel.setOpen(true);
        panel.setId("content");
        panel.setLocation(COLUMN_1);
        panel.addCssClass("search-icon-content");
        SearchInputFieldModel descriptionField = new SearchInputFieldModel("hasDescription", "", "exists");
        panel.addField(descriptionField);
        SearchInterfaceDescription.OptionBuilder optionBuilder = this.optionBuilder(locale);
        descriptionField.addPossibleValue(optionBuilder.labelI18nKey("search.requirement.emptyDescription").optionKey("0").build());
        descriptionField.addPossibleValue(optionBuilder.labelI18nKey("search.requirement.nonemptyDescription").optionKey("1").build());
        SearchInputFieldModel attachmentField = new SearchInputFieldModel("attachments", this.getMessageSource().internationalize("search.testcase.content.attachment.label", locale), "exists");
        panel.addField(attachmentField);
        attachmentField.addPossibleValue(optionBuilder.labelI18nKey("search.testcase.content.attachment.atleastone").optionKey("1").build());
        attachmentField.addPossibleValue(optionBuilder.labelI18nKey("search.testcase.content.attachment.none").optionKey("0").build());
        return panel;
    }

    public SearchInputPanelModel createRequirementAssociationPanel(Locale locale) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.testcase.association.panel.title", locale));
        panel.setOpen(true);
        panel.setId("association");
        panel.setLocation(COLUMN_1);
        panel.addCssClass("search-icon-associations");
        SearchInputFieldModel testcasesField = new SearchInputFieldModel("testcases", this.getMessageSource().internationalize("search.requirement.association.testcase.label", locale), "numericrange");
        panel.addField(testcasesField);
        SearchInputFieldModel childRequirementsField = new SearchInputFieldModel("requirement.children", this.getMessageSource().internationalize("search.requirement.association.childRequirement.label", locale), "exists");
        panel.addField(childRequirementsField);
        SearchInterfaceDescription.OptionBuilder optionBuilder = this.optionBuilder(locale);
        childRequirementsField.addPossibleValue(optionBuilder.labelI18nKey("search.requirement.association.childRequirement.atleastone").optionKey("1").build());
        childRequirementsField.addPossibleValue(optionBuilder.labelI18nKey("search.requirement.association.childRequirement.none").optionKey("0").build());
        SearchInputFieldModel parentRequirementsField = new SearchInputFieldModel("parent", this.getMessageSource().internationalize("search.requirement.association.parentRequirement.label", locale), "exists");
        panel.addField(parentRequirementsField);
        parentRequirementsField.addPossibleValue(optionBuilder.labelI18nKey("search.requirement.association.parentRequirement.atleastone").optionKey("1").build());
        parentRequirementsField.addPossibleValue(optionBuilder.labelI18nKey("search.requirement.association.parentRequirement.none").optionKey("0").build());
        SearchInputFieldModel linkTypeField = new SearchInputFieldModel("link-type", this.getMessageSource().internationalize("search.requirement.version-links.type.label", locale), "comboexistsmultiselect");
        panel.addField(linkTypeField);
        this.populateRequirementLinkInputs(linkTypeField, locale);
        return panel;
    }

    public SearchInputPanelModel createRequirementHistoryPanel(Locale locale, List<Long> readableProjectIds) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.testcase.history.panel.title", locale));
        panel.setOpen(true);
        panel.setId("history");
        panel.setLocation(COLUMN_1);
        panel.addCssClass("search-icon-history-blue");
        SearchInterfaceDescription.OptionBuilder optionBuilder = this.optionBuilder(locale);
        SearchInputFieldModel createdByField = new SearchInputFieldModel("createdBy", this.getMessageSource().internationalize("search.testcase.history.createdBy.label", locale), "multiautocomplete");
        panel.addField(createdByField);
        List users = this.advancedSearchService.findAllUsersWhoCreatedRequirementVersions(readableProjectIds);
        for (String user : users) {
            createdByField.addPossibleValue(optionBuilder.label(user).optionKey(user).build());
        }
        SearchInputFieldModel createdOnField = new SearchInputFieldModel("createdOn", this.getMessageSource().internationalize("search.testcase.history.createdOn.label", locale), "date");
        panel.addField(createdOnField);
        SearchInputFieldModel modifiedByField = new SearchInputFieldModel("lastModifiedBy", this.getMessageSource().internationalize("search.testcase.history.modifiedBy.label", locale), "multiautocomplete");
        panel.addField(modifiedByField);
        users = this.advancedSearchService.findAllUsersWhoModifiedRequirementVersions(readableProjectIds);
        for (String user : users) {
            if (StringUtils.isBlank((CharSequence)user)) {
                modifiedByField.addPossibleValue(optionBuilder.labelI18nKey("label.NeverModified").optionKey("").build());
                continue;
            }
            modifiedByField.addPossibleValue(optionBuilder.label(user).optionKey(user).build());
        }
        SearchInputFieldModel modifiedOnField = new SearchInputFieldModel("lastModifiedOn", this.getMessageSource().internationalize("search.testcase.history.modifiedOn.label", locale), "date");
        panel.addField(modifiedOnField);
        return panel;
    }

    public SearchInputPanelModel createRequirementPerimeterPanel(Locale locale, Collection<JsonProject> jsProjects) {
        return this.perimeterPanelBuilder(locale).cssClass("search-icon-perimeter-blue").htmlId("requirement.project.id").build(jsProjects);
    }

    private SearchInputFieldModel buildCategoryFieldModel(Locale locale, Collection<JsonProject> jsProjects) {
        SearchInputFieldModel categoryField = new SearchInputFieldModel("category", this.getMessageSource().internationalize("requirement.category.label", locale), "multicascadeflat");
        ArrayList<JsonInfoList> categories = new ArrayList<JsonInfoList>(jsProjects.size());
        for (JsonProject p : jsProjects) {
            categories.add(p.getRequirementCategories());
        }
        if (!categories.isEmpty()) {
            Collections.sort(categories, (p1, p2) -> p1.getLabel().compareTo(p2.getLabel()));
        }
        this.populateInfoListFieldModel(categoryField, categories, locale);
        return categoryField;
    }

    private void populateInfoListFieldModel(SearchInputFieldModel model, Collection<JsonInfoList> infoLists, Locale locale) {
        InternationalizationHelper messages = this.getMessageSource();
        HashMap<String, SearchInputPossibleValueModel> listsByListCode = new HashMap<String, SearchInputPossibleValueModel>();
        for (JsonInfoList list : infoLists) {
            if (listsByListCode.containsKey(list.getCode())) continue;
            String listName = messages.getMessage(list.getLabel(), null, list.getLabel(), locale);
            String listCode = list.getCode();
            SearchInputPossibleValueModel listValues = new SearchInputPossibleValueModel(listName, listCode);
            SearchInputFieldModel subInput = new SearchInputFieldModel();
            list.getItems().sort((i1, i2) -> i1.getItemIndex().compareTo(i2.getItemIndex()));
            for (JsonInfoListItem item : list.getItems()) {
                String itemName = messages.getMessage(item.getLabel(), null, item.getLabel(), locale);
                String itemCode = item.getCode();
                subInput.addPossibleValue(new SearchInputPossibleValueModel(itemName, itemCode));
            }
            listValues.setSubInput(subInput);
            listsByListCode.put(list.getCode(), listValues);
        }
        model.setPossibleValues(new ArrayList<SearchInputPossibleValueModel>(listsByListCode.values()));
    }

    public void populateRequirementLinkInputs(SearchInputFieldModel linkField, Locale locale) {
        ArrayList<SearchInputPossibleValueModel> possibleValues = new ArrayList<SearchInputPossibleValueModel>();
        linkField.addPossibleValue(new SearchInputPossibleValueModel(this.getMessageSource().internationalize("search.requirement.version-links.atleastone", locale), "1"));
        linkField.addPossibleValue(new SearchInputPossibleValueModel(this.getMessageSource().internationalize("search.requirement.version-links.none", locale), "0"));
        List linkedList = this.linkedRequirementVersionManagerService.findAllRequirementVersionLinkType();
        for (RequirementVersionLinkType link : linkedList) {
            String role = this.getRoleFromLinkType(link.getRole1(), locale);
            SearchInputPossibleValueModel searchInputPossibleValueModel1 = new SearchInputPossibleValueModel(role, link.getRole1Code());
            possibleValues.add(searchInputPossibleValueModel1);
            if (link.getRole1Code().equals(link.getRole2Code())) continue;
            role = this.getRoleFromLinkType(link.getRole2(), locale);
            SearchInputPossibleValueModel searchInputPossibleValueModel2 = new SearchInputPossibleValueModel(role, link.getRole2Code());
            possibleValues.add(searchInputPossibleValueModel2);
        }
        linkField.addPossibleValues(possibleValues);
    }

    private String getRoleFromLinkType(String role, Locale locale) {
        return role.contains(REQUIREMENT_VERSION_LINK_TYPE_LABEL) ? this.getMessageSource().internationalize(role, locale) : role;
    }
}

