/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.search.advanced.searchinterface;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.service.internal.dto.json.JsonProject;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputFieldModel;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputPanelModel;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputPossibleValueModel;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInterfaceDescription;

@Component
public class CampaignSearchInterfaceDescription
extends SearchInterfaceDescription {
    private static final String COLUMN_1 = "column1";

    public SearchInputPanelModel createGeneralInfoPanel(Locale locale) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.testcase.generalinfos.panel.title", locale));
        panel.setOpen(true);
        panel.setId("general-information-fullsize");
        panel.setLocation(COLUMN_1);
        panel.addCssClass("search-icon-information");
        SearchInputFieldModel idField = new SearchInputFieldModel("referencedTestCase.id", this.getMessageSource().internationalize("referenced-tc.id", locale), "textfieldid");
        panel.addField(idField);
        SearchInputFieldModel referenceField = new SearchInputFieldModel("referencedTestCase.reference", this.getMessageSource().internationalize("label.reference", locale), "textfieldreference");
        panel.addField(referenceField);
        SearchInputFieldModel labelField = new SearchInputFieldModel("referencedTestCase.name", this.getMessageSource().internationalize("label.Label", locale), "textfield");
        panel.addField(labelField);
        return panel;
    }

    public SearchInputPanelModel createAttributePanel(Locale locale, List<String> users) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.testcase.attributes.panel.title", locale));
        panel.setOpen(true);
        panel.setId("attributes");
        panel.setLocation(COLUMN_1);
        panel.addCssClass("search-icon-attributes");
        SearchInputFieldModel importanceField = new SearchInputFieldModel("referencedTestCase.importance", this.getMessageSource().internationalize("test-case.importance.label", locale), "multiselect");
        panel.addField(importanceField);
        List<SearchInputPossibleValueModel> importanceOptions = this.levelComboBuilder((Enum[])TestCaseImportance.values()).useLocale(locale).build();
        importanceField.addPossibleValues(importanceOptions);
        SearchInputFieldModel assignmentField = new SearchInputFieldModel("user", this.getMessageSource().internationalize("search.execution.assignation", locale), "multiautocomplete");
        panel.addField(assignmentField);
        SearchInterfaceDescription.OptionBuilder optionBuilder = this.optionBuilder(locale);
        for (String user : users) {
            assignmentField.addPossibleValue(optionBuilder.label(user).optionKey(user).build());
        }
        return panel;
    }

    public SearchInputPanelModel createExecutionPanel(Locale locale, List<String> users) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.execution.label", locale));
        panel.setOpen(true);
        panel.setId("execution");
        panel.setLocation(COLUMN_1);
        panel.addCssClass("search-icon-execution");
        SearchInputFieldModel lastExecuted = new SearchInputFieldModel("lastExecutedOn", this.getMessageSource().internationalize("search.execution.executed.label", locale), "date");
        panel.addField(lastExecuted);
        SearchInterfaceDescription.OptionBuilder optionBuilder = this.optionBuilder(locale);
        SearchInputFieldModel authorizedUsersField = new SearchInputFieldModel("lastExecutedBy", this.getMessageSource().internationalize("search.execution.executedby.label", locale), "multiautocomplete");
        for (String user : users) {
            authorizedUsersField.addPossibleValue(optionBuilder.label(user).optionKey(user).build());
        }
        panel.addField(authorizedUsersField);
        SearchInputFieldModel statusField = new SearchInputFieldModel("executionStatus", this.getMessageSource().internationalize("test-case.status.label", locale), "multiselect");
        panel.addField(statusField);
        ExecutionStatus[] values = ExecutionStatus.values();
        List<SearchInputPossibleValueModel> statusOptions = this.levelComboBuilder((Enum[])values).useLocale(locale).build();
        statusField.addPossibleValues(statusOptions);
        SearchInputFieldModel executionModeField = new SearchInputFieldModel("executionMode", this.getMessageSource().internationalize("search.execution.mode.label", locale), "multiselect");
        panel.addField(executionModeField);
        List<SearchInputPossibleValueModel> modeOptions = this.levelComboBuilder((Enum[])TestCaseExecutionMode.values()).useLocale(locale).build();
        executionModeField.addPossibleValues(modeOptions);
        return panel;
    }

    public SearchInputPanelModel createPerimeterPanel(Locale locale, Collection<JsonProject> jsProjects) {
        return this.perimeterPanelBuilder(locale).cssClass("search-icon-perimeter").htmlId("project.id").build(jsProjects);
    }

    public SearchInputPanelModel createAutomationPanel(Locale locale) {
        SearchInputPanelModel panel = new SearchInputPanelModel();
        panel.setTitle(this.getMessageSource().internationalize("search.testcase.automation.panel.title", locale));
        panel.setOpen(true);
        panel.setId("automation");
        panel.setLocation(COLUMN_1);
        SearchInputFieldModel automationField = new SearchInputFieldModel("referencedTestCase.automatable", this.getMessageSource().internationalize("test-case.automation-indicator.label", locale), "multiselect");
        panel.addField(automationField);
        List<SearchInputPossibleValueModel> automationOptions = this.levelComboBuilder((Enum[])TestCaseAutomatable.values()).useLocale(locale).build();
        automationField.addPossibleValues(automationOptions);
        SearchInputFieldModel automationRequestField = new SearchInputFieldModel("referencedTestCase.automationRequest.requestStatus", this.getMessageSource().internationalize("test-case.automation-status.label", locale), "multiselect");
        panel.addField(automationRequestField);
        List<SearchInputPossibleValueModel> automationRequestOptions = this.levelComboBuilder((Enum[])AutomationRequestStatus.values()).useLocale(locale).build();
        automationRequestField.addPossibleValues(automationRequestOptions);
        return panel;
    }
}

