/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.search.advanced;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.IdentifiedUtil;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.search.AdvancedSearchModel;
import org.squashtest.tm.domain.search.AdvancedSearchQueryModel;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.campaign.CampaignTestPlanManagerService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.campaign.TestSuiteTestPlanManagerService;
import org.squashtest.tm.service.testcase.TestCaseAdvancedSearchService;
import org.squashtest.tm.service.testcase.VerifyingTestCaseManagerService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.search.advanced.GlobalSearchController;
import org.squashtest.tm.web.internal.controller.search.advanced.tablemodels.TestCaseSearchResultDataTableModelBuilder;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.SpringPagination;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
public class TestCaseSearchController
extends GlobalSearchController {
    private DatatableMapper<String> testCaseSearchResultMapper = new NameBasedMapper(15).mapAttribute("project-name", "name", Project.class).mapAttribute("test-case-id", "id", TestCase.class).mapAttribute("test-case-ref", "reference", TestCase.class).mapAttribute("test-case-label", "labelUpperCased", TestCase.class).mapAttribute("test-case-weight", "importance", TestCase.class).mapAttribute("test-case-nature", "nature", TestCase.class).mapAttribute("test-case-type", "type", TestCase.class).mapAttribute("test-case-status", "status", TestCase.class).mapAttribute("test-case-automatable", "automatable", TestCase.class).mapAttribute("test-case-milestone-nb", "milestones", TestCase.class).mapAttribute("test-case-requirement-nb", "requirements", TestCase.class).mapAttribute("test-case-teststep-nb", "steps", TestCase.class).mapAttribute("test-case-iteration-nb", "iterations", TestCase.class).mapAttribute("test-case-attachment-nb", "attachments", TestCase.class).mapAttribute("test-case-created-by", "createdBy", TestCase.class).mapAttribute("test-case-modified-by", "lastModifiedBy", TestCase.class);
    @Inject
    private TestCaseAdvancedSearchService testCaseAdvancedSearchService;
    @Inject
    private VerifyingTestCaseManagerService verifyingTestCaseManagerService;
    @Inject
    private CampaignTestPlanManagerService campaignTestPlanManagerService;
    @Inject
    private IterationTestPlanManagerService iterationTestPlanManagerService;
    @Inject
    private TestSuiteTestPlanManagerService testSuiteTestPlanManagerService;
    @Inject
    private IterationModificationService iterationService;
    @Inject
    @Named(value="testCaseWorkspaceDisplayService")
    private WorkspaceDisplayService testCaseWorkspaceDisplayService;

    @RequestMapping(method={RequestMethod.GET}, params={"searchDomain=test-case"})
    public String showTestCaseSearchPage(Model model, @RequestParam(required=false, defaultValue="") String associationType, @RequestParam(required=false, defaultValue="") Long associationId) {
        this.initSearchPageModel(model, "", associationType, associationId, "test-case");
        return "test-case-search-input.html";
    }

    @RequestMapping(method={RequestMethod.POST}, params={"searchDomain=test-case"})
    public String showTestCaseSearchPageWithSearchModel(Model model, @RequestParam String searchModel, @RequestParam(required=false) String associationType, @RequestParam(required=false) Long associationId) {
        this.initSearchPageModel(model, searchModel, associationType, associationId, "test-case");
        return "test-case-search-input.html";
    }

    @RequestMapping(method={RequestMethod.GET}, params={"searchDomain=testcaseViaRequirement"})
    public String showTestCaseViaRequirementSearchPage(Model model, @RequestParam(required=false, defaultValue="") String associationType, @RequestParam(required=false, defaultValue="") Long associationId) {
        this.initSearchPageModel(model, "", associationType, associationId, "testcaseViaRequirement");
        return "requirement-search-input.html";
    }

    @RequestMapping(method={RequestMethod.POST}, params={"searchDomain=testcaseViaRequirement"})
    public String showTestCaseViaRequirementSearchPageWithSearchModel(Model model, @RequestParam String searchModel, @RequestParam(required=false) String associationType, @RequestParam(required=false) Long associationId) {
        this.initSearchPageModel(model, searchModel, associationType, associationId, "testcaseViaRequirement");
        return "requirement-search-input.html";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/results"}, params={"searchDomain=test-case"})
    public String showTestCaseSearchResultPageFilledWithSearchModel(Model model, @RequestParam String searchModel, @RequestParam(required=false) String associationType, @RequestParam(required=false) Long associationId) {
        this.initResultModel(model, searchModel, associationType, associationId, "test-case");
        return "test-case-search-result.html";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/results"}, params={"searchDomain=test-case"})
    public String getTestCaseSearchResultPage(Model model, @RequestParam(required=false) String associationType, @RequestParam(required=false) Long associationId) {
        this.initResultModel(model, "", associationType, associationId, "test-case");
        return "test-case-search-result.html";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/results"}, params={"searchDomain=testcaseViaRequirement"})
    public String showTestCaseViaRequirementSearchResultPageFilledWithSearchModel(Model model, @RequestParam String searchModel, @RequestParam(required=false) String associationType, @RequestParam(required=false) Long associationId) {
        this.initResultModel(model, searchModel, associationType, associationId, "testcaseViaRequirement");
        return "test-case-search-result.html";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/results"}, params={"searchDomain=testcaseViaRequirement"})
    public String getTestCaseViaRequirementSearchResultPage(Model model, @RequestParam(required=false) String associationType, @RequestParam(required=false) Long associationId) {
        this.initResultModel(model, "", associationType, associationId, "testcaseViaRequirement");
        return "test-case-search-result.html";
    }

    @RequestMapping(value={"/table"}, method={RequestMethod.POST}, params={"model", "testcaseViaRequirement", "sEcho"})
    @ResponseBody
    public DataTableModel getTestCaseThroughRequirementTableModel(DataTableDrawParameters params, Locale locale, @RequestParam(value="model") String model, @RequestParam(required=false) String associationType, @RequestParam(required=false) Long associationId) throws IOException {
        AdvancedSearchModel searchModel = (AdvancedSearchModel)new ObjectMapper().readValue(model, AdvancedSearchModel.class);
        this.addMilestoneToSearchModel(searchModel);
        Pageable paging = SpringPagination.pageable(params, this.testCaseSearchResultMapper, key -> key);
        AdvancedSearchQueryModel queryModel = new AdvancedSearchQueryModel(paging, this.testCaseSearchResultMapper.getMappedKeys(), searchModel);
        Page holder = this.testCaseAdvancedSearchService.searchForTestCasesThroughRequirementModel(queryModel, paging, locale);
        boolean isInAssociationContext = this.isInAssociationContext(associationType);
        Set<Long> ids = null;
        if (isInAssociationContext) {
            ids = this.getIdsOfTestCasesAssociatedWithObjects(associationType, associationId);
        }
        return new TestCaseSearchResultDataTableModelBuilder(locale, this.getMessageSource(), this.getPermissionService(), this.iterationService, isInAssociationContext, ids).buildDataModel(holder, params.getsEcho());
    }

    @RequestMapping(value={"/table"}, method={RequestMethod.POST}, params={"model", "test-case", "sEcho"})
    @ResponseBody
    public DataTableModel getTestCaseTableModel(DataTableDrawParameters params, Locale locale, @RequestParam(value="model") String model, @RequestParam(required=false) String associationType, @RequestParam(required=false) Long associationId) throws IOException {
        AdvancedSearchModel searchModel = (AdvancedSearchModel)new ObjectMapper().readValue(model, AdvancedSearchModel.class);
        this.addMilestoneToSearchModel(searchModel);
        Pageable paging = SpringPagination.pageable(params, this.testCaseSearchResultMapper, key -> key);
        AdvancedSearchQueryModel queryModel = new AdvancedSearchQueryModel(paging, this.testCaseSearchResultMapper.getMappedKeys(), searchModel);
        Page holder = this.testCaseAdvancedSearchService.searchForTestCases(queryModel, paging, locale);
        boolean isInAssociationContext = this.isInAssociationContext(associationType);
        Set<Long> ids = null;
        if (isInAssociationContext) {
            ids = this.getIdsOfTestCasesAssociatedWithObjects(associationType, associationId);
        }
        return new TestCaseSearchResultDataTableModelBuilder(locale, this.getMessageSource(), this.getPermissionService(), this.iterationService, isInAssociationContext, ids).buildDataModel(holder, params.getsEcho());
    }

    private Set<Long> getIdsOfTestCasesAssociatedWithObjects(String associationType, Long id) {
        HashSet<Long> ids = new HashSet<Long>();
        if ("requirement".equals(associationType)) {
            List testCases = this.verifyingTestCaseManagerService.findAllByRequirementVersion(id.longValue());
            List tcIds = IdentifiedUtil.extractIds((Collection)testCases);
            ids.addAll(tcIds);
        } else if ("campaign".equals(associationType)) {
            List referencedTestCasesIds = this.campaignTestPlanManagerService.findPlannedTestCasesIds(id);
            ids.addAll(referencedTestCasesIds);
        } else if ("iteration".equals(associationType)) {
            List testCases = this.iterationTestPlanManagerService.findPlannedTestCases(id);
            List tcIds = IdentifiedUtil.extractIds((Collection)testCases);
            ids.addAll(tcIds);
        } else if ("testsuite".equals(associationType)) {
            List referencedTestCasesIds = this.testSuiteTestPlanManagerService.findPlannedTestCasesIds(id);
            ids.addAll(referencedTestCasesIds);
        }
        return ids;
    }

    @Override
    protected WorkspaceDisplayService workspaceDisplayService() {
        return this.testCaseWorkspaceDisplayService;
    }
}

