/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.search.advanced;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.context.MessageSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.search.AdvancedSearchModel;
import org.squashtest.tm.domain.search.AdvancedSearchQueryModel;
import org.squashtest.tm.service.requirement.RequirementVersionAdvancedSearchService;
import org.squashtest.tm.service.requirement.VerifiedRequirement;
import org.squashtest.tm.service.requirement.VerifiedRequirementsManagerService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.search.advanced.GlobalSearchController;
import org.squashtest.tm.web.internal.controller.search.advanced.tablemodels.RequirementSearchResultDataTableModelBuilder;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.SpringPagination;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
public class RequirementSearchController
extends GlobalSearchController {
    @Inject
    private VerifiedRequirementsManagerService verifiedRequirementsManagerService;
    @Inject
    private RequirementVersionAdvancedSearchService requirementVersionAdvancedSearchService;
    @Inject
    private WorkspaceDisplayService requirementWorkspaceDisplayService;
    private DatatableMapper<String> requirementSearchResultMapper = new NameBasedMapper(14).mapAttribute("project-name", "name", Project.class).mapAttribute("requirement-id", "requirement.id", RequirementVersion.class).mapAttribute("requirement-reference", "reference", RequirementVersion.class).mapAttribute("requirement-label", "labelUpperCased", RequirementVersion.class).mapAttribute("requirement-criticality", "criticality", RequirementVersion.class).mapAttribute("requirement-category", "category", RequirementVersion.class).mapAttribute("requirement-status", "status", RequirementVersion.class).mapAttribute("requirement-milestone-nb", "milestones", RequirementVersion.class).mapAttribute("requirement-version", "versionNumber", RequirementVersion.class).mapAttribute("requirement-version-nb", "versions", Requirement.class).mapAttribute("requirement-testcase-nb", "testcases", RequirementVersion.class).mapAttribute("requirement-attachment-nb", "attachments", RequirementVersion.class).mapAttribute("requirement-created-by", "createdBy", RequirementVersion.class).mapAttribute("requirement-modified-by", "lastModifiedBy", RequirementVersion.class).mapAttribute("links", "links", RequirementVersion.class);

    @RequestMapping(method={RequestMethod.GET}, params={"searchDomain=requirement"})
    public String showRequirementSearchPage(Model pageModel, @RequestParam(required=false, defaultValue="") String associationType, @RequestParam(required=false) Long associationId) {
        this.initSearchPageModel(pageModel, "", associationType, associationId, "requirement");
        return "requirement-search-input.html";
    }

    @RequestMapping(method={RequestMethod.POST}, params={"searchDomain=requirement"})
    public String showRequirementSearchPagedWithSearchModel(Model pageModel, @RequestParam String searchModel, @RequestParam(required=false, defaultValue="") String associationType, @RequestParam(required=false) Long associationId) {
        this.initSearchPageModel(pageModel, searchModel, associationType, associationId, "requirement");
        return "requirement-search-input.html";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/results"}, params={"searchDomain=requirement"})
    public String showRequirementSearchResultPageWithSearchModel(Model pageModel, @RequestParam String searchModel, @RequestParam(required=false) String associationType, @RequestParam(required=false) Long associationId) {
        this.initResultModel(pageModel, searchModel, associationType, associationId, "requirement");
        return "requirement-search-result.html";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/results"}, params={"searchDomain=requirement"})
    public String showRequirementSearchResultPage(Model pageModel, @RequestParam(required=false) String associationType, @RequestParam(required=false) Long associationId) {
        this.initResultModel(pageModel, "", associationType, associationId, "requirement");
        return "requirement-search-result.html";
    }

    @RequestMapping(value={"/table"}, method={RequestMethod.POST}, params={"model", "requirement", "sEcho"})
    @ResponseBody
    public DataTableModel getRequirementTableModel(DataTableDrawParameters params, Locale locale, @RequestParam(value="model") String model, @RequestParam(required=false) String associationType, @RequestParam(required=false) Long associationId) throws IOException {
        AdvancedSearchModel searchModel = (AdvancedSearchModel)new ObjectMapper().readValue(model, AdvancedSearchModel.class);
        this.addMilestoneToSearchModel(searchModel);
        Pageable paging = SpringPagination.pageable(params, this.requirementSearchResultMapper, key -> key);
        AdvancedSearchQueryModel queryModel = new AdvancedSearchQueryModel(paging, this.requirementSearchResultMapper.getMappedKeys(), searchModel);
        Page holder = this.requirementVersionAdvancedSearchService.searchForRequirementVersions(queryModel, paging, (MessageSource)this.getMessageSource(), locale);
        boolean isInAssociationContext = this.isInAssociationContext(associationType);
        Set<Long> ids = null;
        if (isInAssociationContext) {
            ids = this.getIdsOfRequirementsAssociatedWithObjects(associationType, associationId);
        }
        return new RequirementSearchResultDataTableModelBuilder(locale, this.getMessageSource(), this.getPermissionService(), isInAssociationContext, ids).buildDataModel(holder, params.getsEcho());
    }

    private Set<Long> getIdsOfRequirementsAssociatedWithObjects(String associationType, Long id) {
        HashSet<Long> ids = new HashSet<Long>();
        if ("test-case".equals(associationType)) {
            List requirements = this.verifiedRequirementsManagerService.findAllVerifiedRequirementsByTestCaseId(id.longValue());
            for (VerifiedRequirement requirement : requirements) {
                ids.add(requirement.getId());
            }
        }
        return ids;
    }

    @Override
    protected WorkspaceDisplayService workspaceDisplayService() {
        return this.requirementWorkspaceDisplayService;
    }
}

