/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.search.advanced;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.search.AdvancedSearchFieldModel;
import org.squashtest.tm.domain.search.AdvancedSearchListFieldModel;
import org.squashtest.tm.domain.search.AdvancedSearchModel;
import org.squashtest.tm.domain.search.AdvancedSearchSingleFieldModel;
import org.squashtest.tm.service.campaign.CampaignAdvancedSearchService;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.dto.json.JsonProject;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputInterfaceHelper;
import org.squashtest.tm.web.internal.controller.search.advanced.searchinterface.SearchInputInterfaceModel;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;

@RequestMapping(value={"advanced-search"})
public abstract class GlobalSearchController {
    protected static final String PROJECTS_META = "projects";
    protected static final Logger LOGGER = LoggerFactory.getLogger(GlobalSearchController.class);
    protected static final String NAME = "name";
    protected static final String IDS = "ids[]";
    protected static final String CAMPAIGN = "campaign";
    protected static final String TESTCASE = "test-case";
    protected static final String REQUIREMENT = "requirement";
    protected static final String SEARCH_MODEL = "searchModel";
    protected static final String FORM_MODEL = "formModel";
    protected static final String SEARCH_DOMAIN = "searchDomain";
    protected static final String TESTCASE_VIA_REQUIREMENT = "testcaseViaRequirement";
    protected static final String RESULTS = "/results";
    protected static final String TABLE = "/table";
    protected Map<String, FormModelBuilder> formModelBuilder = new HashMap<String, FormModelBuilder>();
    @Inject
    private SearchInputInterfaceHelper searchInputInterfaceHelper;
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private CampaignAdvancedSearchService campaignAdvancedSearchService;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private ProjectFinder projectFinder;

    public GlobalSearchController() {
        this.formModelBuilder.put(TESTCASE, new FormModelBuilder(){

            @Override
            public SearchInputInterfaceModel build(Locale locale, boolean isMilestoneMode) {
                UserDto currentUser = GlobalSearchController.this.userAccountService.findCurrentUserDto();
                List readableProjectIds = GlobalSearchController.this.projectFinder.findAllReadableIds(currentUser);
                Collection jsProjects = GlobalSearchController.this.projectFinder.findAllProjects(readableProjectIds, currentUser);
                Integer allowAutomationWorkflow = GlobalSearchController.this.projectFinder.countProjectsAllowAutomationWorkflow();
                SearchInputInterfaceModel model = GlobalSearchController.this.searchInputInterfaceHelper.getTestCaseSearchInputInterfaceModel(locale, isMilestoneMode, readableProjectIds, jsProjects, allowAutomationWorkflow);
                GlobalSearchController.this.populateMetadata(model, jsProjects);
                return model;
            }
        });
        this.formModelBuilder.put(TESTCASE_VIA_REQUIREMENT, new FormModelBuilder(){

            @Override
            public SearchInputInterfaceModel build(Locale locale, boolean isMilestoneMode) {
                UserDto currentUser = GlobalSearchController.this.userAccountService.findCurrentUserDto();
                List readableProjectIds = GlobalSearchController.this.projectFinder.findAllReadableIds(currentUser);
                Collection jsProjects = GlobalSearchController.this.projectFinder.findAllProjects(readableProjectIds, currentUser);
                Integer allowAutomationWorkflow = GlobalSearchController.this.projectFinder.countProjectsAllowAutomationWorkflow();
                SearchInputInterfaceModel model = GlobalSearchController.this.searchInputInterfaceHelper.getRequirementSearchInputInterfaceModel(locale, isMilestoneMode, readableProjectIds, jsProjects, allowAutomationWorkflow);
                GlobalSearchController.this.populateMetadata(model, jsProjects);
                return model;
            }
        });
        this.formModelBuilder.put(CAMPAIGN, new FormModelBuilder(){

            @Override
            public SearchInputInterfaceModel build(Locale locale, boolean isMilestoneMode) {
                UserDto currentUser = GlobalSearchController.this.userAccountService.findCurrentUserDto();
                List readableProjectIds = GlobalSearchController.this.projectFinder.findAllReadableIds(currentUser);
                Collection jsProjects = GlobalSearchController.this.projectFinder.findAllProjects(readableProjectIds, currentUser);
                Integer allowAutomationWorkflow = GlobalSearchController.this.projectFinder.countProjectsAllowAutomationWorkflow();
                SearchInputInterfaceModel model = GlobalSearchController.this.searchInputInterfaceHelper.getCampaignSearchInputInterfaceModel(locale, isMilestoneMode, readableProjectIds, allowAutomationWorkflow);
                GlobalSearchController.this.populateMetadata(model, jsProjects);
                return model;
            }
        });
        this.formModelBuilder.put(REQUIREMENT, new FormModelBuilder(){

            @Override
            public SearchInputInterfaceModel build(Locale locale, boolean isMilestoneMode) {
                UserDto currentUser = GlobalSearchController.this.userAccountService.findCurrentUserDto();
                List readableProjectIds = GlobalSearchController.this.projectFinder.findAllReadableIds(currentUser);
                Collection jsProjects = GlobalSearchController.this.projectFinder.findAllProjects(readableProjectIds, currentUser);
                Integer allowAutomationWorkflow = GlobalSearchController.this.projectFinder.countProjectsAllowAutomationWorkflow();
                SearchInputInterfaceModel model = GlobalSearchController.this.searchInputInterfaceHelper.getRequirementSearchInputInterfaceModel(locale, isMilestoneMode, readableProjectIds, jsProjects, allowAutomationWorkflow);
                GlobalSearchController.this.populateMetadata(model, jsProjects);
                return model;
            }
        });
    }

    public InternationalizationHelper getMessageSource() {
        return this.messageSource;
    }

    public PermissionEvaluationService getPermissionService() {
        return this.permissionService;
    }

    public ActiveMilestoneHolder getActiveMilestoneHolder() {
        return this.activeMilestoneHolder;
    }

    protected void initSearchPageModel(Model model, String searchModel, String associationType, Long associationId, String domain) {
        this.initModelForPage(model, associationType, associationId);
        model.addAttribute(SEARCH_DOMAIN, (Object)domain);
        FormModelBuilder builder = this.formModelBuilder.get(domain);
        if (builder != null) {
            Locale locale = LocaleContextHolder.getLocale();
            Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
            model.addAttribute(FORM_MODEL, (Object)builder.build(locale, activeMilestone.isPresent()));
        } else {
            LOGGER.error("Could not find a FormModelBuilder for search domain : {}. This is either caused by a bug or a hand-written request", (Object)domain);
        }
        if (!searchModel.isEmpty()) {
            model.addAttribute(SEARCH_MODEL, (Object)searchModel);
        }
    }

    protected void initResultModel(Model model, String searchModel, String associationType, Long associationId, String domain) {
        this.initModelForPage(model, associationType, associationId);
        if (!searchModel.isEmpty()) {
            model.addAttribute(SEARCH_MODEL, (Object)searchModel);
        }
        model.addAttribute(SEARCH_DOMAIN, (Object)domain);
        this.populateMetadata(model);
    }

    protected void addMilestoneToSearchModel(AdvancedSearchModel searchModel) {
        Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            AdvancedSearchListFieldModel milestoneIds = new AdvancedSearchListFieldModel();
            AdvancedSearchSingleFieldModel activeMilestoneMode = new AdvancedSearchSingleFieldModel();
            ArrayList<String> milestones = new ArrayList<String>();
            milestones.add(((Milestone)activeMilestone.get()).getId().toString());
            milestoneIds.setValues(milestones);
            activeMilestoneMode.setValue("true");
            searchModel.addField("milestones.id", (AdvancedSearchFieldModel)milestoneIds);
            searchModel.addField("searchByMilestone", (AdvancedSearchFieldModel)activeMilestoneMode);
        }
    }

    protected boolean isInAssociationContext(String associationType) {
        return associationType != null;
    }

    private void initModelForPage(Model model, String associationType, Long associationId) {
        Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        model.addAttribute("isMilestoneMode", (Object)activeMilestone.isPresent());
        Integer projectsAllowAtuomationWorkflow = this.projectFinder.countProjectsAllowAutomationWorkflow();
        Boolean automationColVisible = false;
        if (projectsAllowAtuomationWorkflow > 0) {
            automationColVisible = true;
        }
        model.addAttribute("automationColVisible", (Object)automationColVisible);
        if (StringUtils.isNotBlank((CharSequence)associationType)) {
            model.addAttribute("associateResult", (Object)true);
            model.addAttribute("associationType", (Object)associationType);
            model.addAttribute("associationId", (Object)associationId);
        } else {
            model.addAttribute("associateResult", (Object)false);
        }
    }

    private void populateMetadata(Model model) {
        model.addAttribute(PROJECTS_META, this.readableJsonProjects());
    }

    private void populateMetadata(SearchInputInterfaceModel model, Collection<JsonProject> jsProjects) {
        model.addMetadata(PROJECTS_META, jsProjects);
    }

    private Collection<JsonProject> readableJsonProjects() {
        UserDto currentUser = new UserDto(null, null, null, true);
        return this.projectFinder.findAllProjects(this.campaignAdvancedSearchService.findAllReadablesId(), currentUser);
    }

    protected abstract WorkspaceDisplayService workspaceDisplayService();

    protected static interface FormModelBuilder {
        public SearchInputInterfaceModel build(Locale var1, boolean var2);
    }
}

