/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.search.advanced;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.search.AdvancedSearchModel;
import org.squashtest.tm.domain.search.AdvancedSearchQueryModel;
import org.squashtest.tm.exception.customfield.CodeDoesNotMatchesPatternException;
import org.squashtest.tm.service.campaign.CampaignAdvancedSearchService;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.milestone.MilestoneMembershipFinder;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.search.advanced.GlobalSearchController;
import org.squashtest.tm.web.internal.controller.search.advanced.tablemodels.CampaignSearchResultDataTableModelBuilder;
import org.squashtest.tm.web.internal.helper.JsTreeHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.SpringPagination;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
public class CampaignSearchController
extends GlobalSearchController {
    @Inject
    private CampaignAdvancedSearchService campaignAdvancedSearchService;
    @Inject
    private MilestoneMembershipFinder milestoneMembershipFinder;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private CampaignLibraryNavigationService campaignLibraryNavigationService;
    @Inject
    @Named(value="campaignWorkspaceDisplayService")
    private WorkspaceDisplayService workspaceDisplayService;
    private DatatableMapper<String> campaignSearchResultMapper = new NameBasedMapper(11).mapAttribute("project-name", "name", Project.class).mapAttribute("campaign-name", "campaign.label", IterationTestPlanItem.class).mapAttribute("iteration-name", "iteration.name", IterationTestPlanItem.class).mapAttribute("itpi-id", "id", IterationTestPlanItem.class).mapAttribute("itpi-label", "label", IterationTestPlanItem.class).mapAttribute("itpi-mode", "executionMode", IterationTestPlanItem.class).mapAttribute("itpi-testsuites", "", IterationTestPlanItem.class).mapAttribute("itpi-status", "executionStatus", IterationTestPlanItem.class).mapAttribute("itpi-executed-by", "lastExecutedBy", IterationTestPlanItem.class).mapAttribute("itpi-executed-on", "lastExecutedOn", IterationTestPlanItem.class).mapAttribute("itpi-datasets", "datasets", IterationTestPlanItem.class).mapAttribute("tc-weight", "referencedTestCase.importance", IterationTestPlanItem.class).mapAttribute("test-case-automatable", "referencedTestCase.automatable", IterationTestPlanItem.class);

    @RequestMapping(method={RequestMethod.GET}, params={"searchDomain=campaign"})
    public String showCampaignSearchPage(Model pageModel, @RequestParam(value="jstree_open", required=false, defaultValue="") String[] openedNodes, @RequestParam(value="workspace-prefs", required=false, defaultValue="") String elementEntityReference, @RequestParam(required=false, defaultValue="") String associationType, @RequestParam(required=false, defaultValue="") Long associationId) {
        this.prepareSearchPageModel(pageModel, "", openedNodes, elementEntityReference, associationType, associationId);
        return "campaign-search-input.html";
    }

    @RequestMapping(method={RequestMethod.POST}, params={"searchDomain=campaign"})
    public String showCampaignSearchPageWithSearchModel(Model pageModel, @RequestParam String searchModel, @RequestParam(value="jstree_open", required=false, defaultValue="") String[] openedNodes, @RequestParam(value="workspace-prefs", required=false, defaultValue="") String elementEntityReference, @RequestParam(required=false) String associationType, @RequestParam(required=false) Long associationId) {
        this.prepareSearchPageModel(pageModel, searchModel, openedNodes, elementEntityReference, associationType, associationId);
        return "campaign-search-input.html";
    }

    private void prepareSearchPageModel(Model pageModel, String searchModel, String[] openedNodes, String elementEntityReference, String associationType, Long associationId) {
        String[] nodesToOpen = new String[]{};
        if (StringUtils.isBlank((CharSequence)elementEntityReference) || "null".equals(elementEntityReference)) {
            nodesToOpen = openedNodes;
            pageModel.addAttribute("selectedNode", (Object)"");
        } else {
            try {
                EntityReference entityReference = EntityReference.fromString((String)elementEntityReference.toUpperCase());
                nodesToOpen = this.getNodeParentsInWorkspace(entityReference);
                pageModel.addAttribute("selectedNode", (Object)this.getTreeElementIdInWorkspace(entityReference.getId()));
            }
            catch (IllegalArgumentException | CodeDoesNotMatchesPatternException e) {
                LOGGER.warn("Error during conversion of the 'workspace-prefs' cookie to an EntityReference.", e);
            }
        }
        MultiMap expansionCandidates = this.mapIdsByType(nodesToOpen);
        this.initSearchPageModel(pageModel, searchModel, associationType, associationId, "campaign");
        List projectIds = this.campaignAdvancedSearchService.findAllReadablesId();
        UserDto user = this.userAccountService.findCurrentUserDto();
        Optional activeMilestoneId = this.getActiveMilestoneHolder().getActiveMilestoneId();
        Collection rootNodes = this.workspaceDisplayService().findAllLibraries(projectIds, user, expansionCandidates, (Long)activeMilestoneId.get());
        boolean isCampaignAvailable = true;
        Optional activeMilestone = this.getActiveMilestoneHolder().getActiveMilestone();
        if (activeMilestone.isPresent()) {
            isCampaignAvailable = this.milestoneMembershipFinder.isMilestoneBoundToACampainInProjects(((Milestone)activeMilestone.get()).getId(), projectIds);
        }
        pageModel.addAttribute("rootModel", (Object)rootNodes);
        pageModel.addAttribute("isCampaignAvailable", (Object)isCampaignAvailable);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/results"}, params={"searchDomain=campaign"})
    public String getCampaignSearchResultPage(Model pageModel, @RequestParam(required=false) String associationType, @RequestParam(required=false) Long associationId) {
        this.initResultModel(pageModel, "", associationType, associationId, "campaign");
        return "campaign-search-result.html";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/results"}, params={"searchDomain=campaign"})
    public String showCampaignResultSearchResultPageWithSearchModel(Model pageModel, @RequestParam String searchModel, @RequestParam(required=false) String associationType, @RequestParam(required=false) Long associationId) {
        this.initResultModel(pageModel, searchModel, associationType, associationId, "campaign");
        return "campaign-search-result.html";
    }

    @RequestMapping(value={"/table"}, method={RequestMethod.POST}, params={"model", "campaign", "sEcho"})
    @ResponseBody
    public DataTableModel getCampaignTableModel(DataTableDrawParameters params, Locale locale, @RequestParam(value="model") String model) throws IOException {
        AdvancedSearchModel searchModel = (AdvancedSearchModel)new ObjectMapper().readValue(model, AdvancedSearchModel.class);
        this.addMilestoneToSearchModel(searchModel);
        Pageable paging = SpringPagination.pageable(params, this.campaignSearchResultMapper, key -> key);
        AdvancedSearchQueryModel queryModel = new AdvancedSearchQueryModel(paging, this.campaignSearchResultMapper.getMappedKeys(), searchModel);
        Page holder = this.campaignAdvancedSearchService.searchForIterationTestPlanItem(queryModel, paging, locale);
        return new CampaignSearchResultDataTableModelBuilder(locale, this.getMessageSource(), this.getPermissionService()).buildDataModel(holder, params.getsEcho());
    }

    @Override
    protected WorkspaceDisplayService workspaceDisplayService() {
        return this.workspaceDisplayService;
    }

    protected String getTreeElementIdInWorkspace(Long elementId) {
        return "Campaign-" + elementId;
    }

    protected String[] getNodeParentsInWorkspace(EntityReference entityReference) {
        List parents = this.campaignLibraryNavigationService.getParentNodesAsStringList(entityReference);
        return parents.toArray(new String[parents.size()]);
    }

    protected MultiMap mapIdsByType(String[] openedNodes) {
        return JsTreeHelper.mapIdsByType(openedNodes);
    }
}

