/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.search.advanced;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.web.internal.controller.administration.MilestoneDataTableModelHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.search.MilestoneMassModifData;

@Controller
@RequestMapping(value={"advanced-search"})
public class AdvancedSearchMilestoneModificationController {
    private static final String IDS = "ids[]";
    @Inject
    private RequirementVersionManagerService versionService;
    @Inject
    private TestCaseModificationService testCaseModificationService;
    @Inject
    private InternationalizationHelper internationalizationHelper;

    @RequestMapping(value={"/milestones/tc-mass-modif-associables/{testCaseIds}"}, method={RequestMethod.GET})
    @ResponseBody
    public DataTableModel getMilestonesForMassTcModif(@PathVariable List<Long> testCaseIds, Locale locale) {
        Collection milestones = this.testCaseModificationService.findAssociableMilestonesForMassModif(testCaseIds);
        return this.buildMilestoneTableModelForMassModif(milestones, locale);
    }

    @RequestMapping(value={"/milestones/reqV-mass-modif-associables/{reqVersionIds}"}, method={RequestMethod.GET})
    @ResponseBody
    public DataTableModel getMilestonesForMassReqVersionModif(@PathVariable List<Long> reqVersionIds, Locale locale) {
        Collection milestones = this.versionService.findAssociableMilestonesForMassModif(reqVersionIds);
        return this.buildMilestoneTableModelForMassModif(milestones, locale);
    }

    @RequestMapping(value={"/milestones/tc-mass-modif-data/{testCaseIds}"}, method={RequestMethod.GET})
    @ResponseBody
    public MilestoneMassModifData getMilestoneMassModifDataForTc(@PathVariable List<Long> testCaseIds) {
        MilestoneMassModifData data = new MilestoneMassModifData();
        data.setCheckedIds(this.testCaseModificationService.findBindedMilestonesIdForMassModif(testCaseIds));
        boolean hasData = !this.testCaseModificationService.findAssociableMilestonesForMassModif(testCaseIds).isEmpty();
        data.setHasData(hasData);
        data.setSamePerimeter(this.testCaseModificationService.haveSamePerimeter(testCaseIds));
        return data;
    }

    @RequestMapping(value={"/milestones/reqV-mass-modif-data/{reqVersionIds}"}, method={RequestMethod.GET})
    @ResponseBody
    public MilestoneMassModifData getMilestoneMassModifDataForReqVersion(@PathVariable List<Long> reqVersionIds) {
        MilestoneMassModifData data = new MilestoneMassModifData();
        data.setCheckedIds(this.versionService.findBindedMilestonesIdForMassModif(reqVersionIds));
        boolean hasData = !this.versionService.findAssociableMilestonesForMassModif(reqVersionIds).isEmpty();
        data.setHasData(hasData);
        data.setSamePerimeter(this.versionService.haveSamePerimeter(reqVersionIds));
        return data;
    }

    @RequestMapping(value={"/tcs/{testCaseIds}/milestones"}, method={RequestMethod.POST}, params={"ids[]"})
    @ResponseBody
    public void bindMilestonesToTcs(@PathVariable List<Long> testCaseIds, @RequestParam(value="ids[]") List<Long> milestoneIds) {
        Collection bindedBefore = this.testCaseModificationService.findBindedMilestonesIdForMassModif(testCaseIds);
        bindedBefore.removeAll(milestoneIds);
        for (Long testCaseId : testCaseIds) {
            this.testCaseModificationService.bindMilestones(testCaseId.longValue(), milestoneIds);
            this.testCaseModificationService.unbindMilestones(testCaseId.longValue(), bindedBefore);
        }
    }

    @RequestMapping(value={"/reqVersions/{reqVIds}/milestones"}, method={RequestMethod.POST}, params={"ids[]"})
    @ResponseBody
    public boolean bindMilestonesToReqV(@PathVariable List<Long> reqVIds, @RequestParam(value="ids[]") List<Long> milestoneIds) {
        Collection bindedBefore = this.versionService.findBindedMilestonesIdForMassModif(reqVIds);
        bindedBefore.removeAll(milestoneIds);
        boolean isOneVersionAlreadyBind = !milestoneIds.isEmpty() && this.versionService.isOneMilestoneAlreadyBindToAnotherRequirementVersion(reqVIds, milestoneIds);
        for (Long reqVId : reqVIds) {
            this.versionService.bindMilestones(reqVId.longValue(), milestoneIds);
            this.versionService.unbindMilestones(reqVId.longValue(), bindedBefore);
        }
        return isOneVersionAlreadyBind;
    }

    private DataTableModel buildMilestoneTableModelForMassModif(Collection<Milestone> data, Locale locale) {
        MilestoneDataTableModelHelper helper = new MilestoneDataTableModelHelper(this.internationalizationHelper, locale);
        List<Object> aaData = helper.buildRawModel(data);
        DataTableModel<Object> model = new DataTableModel<Object>("");
        model.setAaData(aaData);
        return model;
    }
}

