/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.search;

import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.service.library.SearchService;

@Controller
@RequestMapping(value={"/search"})
public class SearchController {
    private static final String RESULT_LIST = "resultList";
    private static final String WORKSPACE = "workspace";
    private static final String NODE_NAME = "nodeName";
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchController.class);
    private static final String NODE_NAME_REJEX = "-";
    @Inject
    private SearchService searchService;

    @RequestMapping(value={"campaigns/breadcrumb"}, method={RequestMethod.POST}, params={"nodeName"})
    @ResponseBody
    public List<String> findBreadCrumbCampaign(@RequestParam(value="nodeName") String nodeName) {
        LOGGER.trace("search breadcrumb");
        String[] splitedNodeName = nodeName.split(NODE_NAME_REJEX);
        String className = splitedNodeName[0];
        Long nodeId = Long.parseLong(splitedNodeName[1]);
        return this.searchService.findBreadCrumbForCampaign(className, nodeId, NODE_NAME_REJEX);
    }

    @RequestMapping(value={"/campaigns"}, method={RequestMethod.GET}, params={"order"})
    public ModelAndView searchOrderedCampaigns(@RequestParam(value="name") String name, @RequestParam String order) {
        LOGGER.info("SQUASH INFO: TRY Campaign search with name : " + name);
        boolean isOrdered = Boolean.parseBoolean(order);
        List resultList = this.searchService.findCampaignByName(name, isOrdered);
        LOGGER.info("SQUASH INFO: DONE Campaign search with name : " + name);
        ModelAndView mav = isOrdered ? new ModelAndView("fragment/campaigns/camp-search-result-ordered") : new ModelAndView("fragment/campaigns/camp-search-result");
        mav.addObject(RESULT_LIST, (Object)resultList);
        return mav;
    }
}

