/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.scm;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.service.internal.scmserver.ScmConnectorRegistry;
import org.squashtest.tm.service.scmserver.ScmRepositoryManagerService;
import org.squashtest.tm.service.scmserver.ScmServerCredentialsService;
import org.squashtest.tm.service.scmserver.ScmServerManagerService;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;
import org.squashtest.tm.service.thirdpartyserver.ThirdPartyServerCredentialsService;
import org.squashtest.tm.web.internal.controller.bugtracker.BugTrackerControllerHelper;
import org.squashtest.tm.web.internal.controller.scm.ScmRepositoryFormModel;
import org.squashtest.tm.web.internal.controller.thirdpartyserver.ThirdPartyServerCredentialsManagementBean;
import org.squashtest.tm.web.internal.controller.thirdpartyserver.ThirdPartyServerCredentialsManagementHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.model.datatable.SpringPagination;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
@RequestMapping(value={"/administration/scm-server/{scmServerId}"})
public class ScmServerModificationController {
    private static final String SERVER_ID = "scmServerId";
    private static final String NAME = "name";
    private static final String URL = "url";
    private static final String COMMITTER_MAIL = "committerMail";
    private static final String PATH = "path";
    private static final String REPOSITORY_PATH = "repositoryPath";
    private static final String FOLDER = "folder";
    private static final String WORKING_FOLDER_PATH = "workingFolderPath";
    private static final String BRANCH = "branch";
    private static final String WORKING_BRANCH = "workingBranch";
    private static final DatatableMapper<String> scmRepositoryTableMapper = new NameBasedMapper(4).map("name", "name").map("path", "repositoryPath").map("folder", "workingFolderPath").map("branch", "workingBranch");
    @Inject
    private ScmServerManagerService scmServerManager;
    @Inject
    private ScmConnectorRegistry scmServerRegistry;
    @Inject
    private ScmRepositoryManagerService scmRepositoryManager;
    @Inject
    private ScmServerCredentialsService credentialsService;
    @Inject
    private ThirdPartyServerCredentialsService thirdPartyServerCredentialsService;
    @Inject
    private ThirdPartyServerCredentialsManagementHelper credentialsBeanHelper;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showInfos(@PathVariable long scmServerId, Locale locale) {
        ScmServer scmServer = this.scmServerManager.findScmServer(scmServerId);
        Set scmServerKinds = this.scmServerRegistry.getRegisteredScmKinds();
        List scmRepositories = this.scmRepositoryManager.findByScmServerOrderByPath(Long.valueOf(scmServerId));
        ThirdPartyServerCredentialsManagementBean authConf = this.makeAuthBean(scmServer, locale);
        String asteriskedPassword = BugTrackerControllerHelper.retrieveAsteriskedPassword(scmServer.getAuthenticationProtocol(), authConf.getCredentials());
        ModelAndView mav = new ModelAndView("scm-servers/scm-server-details.html");
        mav.addObject("scmServer", (Object)scmServer);
        mav.addObject("asteriskedPassword", (Object)asteriskedPassword);
        mav.addObject("scmServerKinds", (Object)scmServerKinds);
        mav.addObject("scmRepositories", (Object)scmRepositories);
        mav.addObject("authConf", (Object)authConf);
        return mav;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"name"})
    @ResponseBody
    public String updateName(@PathVariable long scmServerId, @RequestParam String name) {
        return this.scmServerManager.updateName(scmServerId, name);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"url"})
    @ResponseBody
    public String updateUrl(@PathVariable long scmServerId, @RequestParam String url) {
        return this.scmServerManager.updateUrl(scmServerId, url);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"committerMail"})
    @ResponseBody
    public String updateCommitterMail(@PathVariable long scmServerId, @RequestParam String committerMail) {
        return this.scmServerManager.updateCommitterMail(scmServerId, committerMail);
    }

    @RequestMapping(value={"/repositories"}, method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getScmRepositoriesTableModel(@PathVariable long scmServerId, DataTableDrawParameters params) {
        Pageable pageable = SpringPagination.pageable(params, scmRepositoryTableMapper);
        Page scmRepositories = this.scmRepositoryManager.findPagedScmRepositoriesByScmServer(Long.valueOf(scmServerId), pageable);
        return new ScmRepositoryDataTableModelHelper().buildDataModel(scmRepositories, params.getsEcho());
    }

    @RequestMapping(value={"/repositories"}, method={RequestMethod.POST})
    @ResponseBody
    public void createNewScmRepository(@PathVariable long scmServerId, @Valid ScmRepositoryFormModel scmRepositoryFormModel) throws IOException {
        this.scmRepositoryManager.createNewScmRepository(scmServerId, scmRepositoryFormModel.getScmRepository(), scmRepositoryFormModel.getCloneRepository());
    }

    @RequestMapping(value={"/authentication-protocol"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public void changeAuthProtocol(@PathVariable(value="scmServerId") long bugtrackerId, @RequestParam(value="value") AuthenticationProtocol protocol) {
        this.thirdPartyServerCredentialsService.changeAuthenticationProtocol(bugtrackerId, protocol);
    }

    @RequestMapping(value={"/authentication-protocol/configuration"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public void saveAuthConfiguration(@PathVariable(value="scmServerId") long bugtrackerId, @Valid @RequestBody ServerAuthConfiguration configuration) {
        this.thirdPartyServerCredentialsService.storeAuthConfiguration(bugtrackerId, configuration);
    }

    @RequestMapping(value={"/credentials"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public void storeCredentials(@PathVariable(value="scmServerId") long bugtrackerId, @RequestBody ManageableCredentials credentials) {
        this.thirdPartyServerCredentialsService.storeCredentials(bugtrackerId, credentials);
    }

    private ThirdPartyServerCredentialsManagementBean makeAuthBean(ScmServer server, Locale locale) {
        ThirdPartyServerCredentialsManagementBean bean = this.credentialsBeanHelper.initializeFor((ThirdPartyServer)server, locale);
        AuthenticationProtocol[] availableProtos = this.credentialsService.getSupportedProtocols(server);
        bean.setAvailableProtos(Arrays.asList(availableProtos));
        bean.setAuthPolicy(AuthenticationPolicy.APP_LEVEL);
        bean.setFeatureAuthPolicySelection(false);
        bean.setFeatureTestCredentialsButton(false);
        bean.setAppLevelCredsAreOptional(false);
        return bean;
    }

    private class ScmRepositoryDataTableModelHelper
    extends DataTableModelBuilder<ScmRepository> {
        private ScmRepositoryDataTableModelHelper() {
        }

        @Override
        protected Object buildItemData(ScmRepository item) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("repository-id", item.getId().toString());
            row.put("repository-index", Long.toString(this.getCurrentIndex()));
            row.put(ScmServerModificationController.NAME, item.getName());
            row.put(ScmServerModificationController.PATH, item.getRepositoryPath());
            row.put(ScmServerModificationController.FOLDER, item.getWorkingFolderPath());
            row.put(ScmServerModificationController.BRANCH, item.getWorkingBranch());
            row.put("empty-delete-holder", null);
            return row;
        }
    }
}

