/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.scm;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.service.internal.scmserver.ScmConnectorRegistry;
import org.squashtest.tm.service.scmserver.ScmServerManagerService;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.model.datatable.SpringPagination;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
@RequestMapping(value={"/administration/scm-servers"})
public class ScmServerManagementAdminController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScmServerManagementAdminController.class);
    private static final String URL = "url";
    private static final String KIND = "kind";
    private static final String ID_EQUALS_IS_BOUND = "id=is-bound";
    private final DatatableMapper<String> scmServerTableMapper = new NameBasedMapper().map("name", "name").map("kind", "kind").map("url", "url");
    @Inject
    private ScmConnectorRegistry scmConnectorRegistry;
    @Inject
    private ScmServerManagerService scmServerManager;

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showManager() {
        LOGGER.trace("Loading scm servers management page.");
        List scmServers = this.scmServerManager.findAllOrderByName();
        Set scmKinds = this.scmConnectorRegistry.getRegisteredScmKinds();
        ModelAndView mav = new ModelAndView("scm-servers/scm-servers-manager.html");
        mav.addObject("scmServers", (Object)scmServers);
        mav.addObject("scmKinds", (Object)scmKinds);
        return mav;
    }

    @RequestMapping(method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getScmServersTableModel(DataTableDrawParameters params) {
        Pageable pageable = SpringPagination.pageable(params, this.scmServerTableMapper);
        Page scmServers = this.scmServerManager.findAllSortedScmServers(pageable);
        return new ScmServerDataTableModelHelper().buildDataModel(scmServers, params.getsEcho());
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public ScmServer createNewScmServer(@Valid ScmServer newScmServer) {
        return this.scmServerManager.createNewScmServer(newScmServer);
    }

    @RequestMapping(value={"/{scmServerIds}"}, method={RequestMethod.GET}, params={"id=is-bound"})
    @ResponseBody
    public boolean isOneServerBoundToProject(@PathVariable List<Long> scmServerIds) {
        return this.scmServerManager.isOneServerBoundToProject(scmServerIds);
    }

    @RequestMapping(value={"/{scmServerIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteScmServers(@PathVariable List<Long> scmServerIds) {
        this.scmServerManager.deleteScmServers(scmServerIds);
    }

    private class ScmServerDataTableModelHelper
    extends DataTableModelBuilder<ScmServer> {
        private ScmServerDataTableModelHelper() {
        }

        @Override
        protected Object buildItemData(ScmServer item) {
            HashMap<String, String> row = new HashMap<String, String>(6);
            row.put("server-id", item.getId().toString());
            row.put("server-index", Long.toString(this.getCurrentIndex()));
            row.put("name", item.getName());
            row.put(ScmServerManagementAdminController.KIND, item.getKind());
            row.put(ScmServerManagementAdminController.URL, item.getUrl());
            row.put("empty-delete-holder", null);
            return row;
        }
    }
}

