/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.scm;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.service.scmserver.ScmRepositoryManagerService;

@Controller
@RequestMapping(value={"/administration/scm-repositories"})
public class ScmRepositoryManagementAdminController {
    private static final String SCM_SERVER_ID = "scmServerId";
    private static final String FOLDER = "folder";
    private static final String BRANCH = "branch";
    private static final String ID_EQUAL_IS_BOUND = "id=is-bound";
    @Inject
    ScmRepositoryManagerService scmRepositoryManager;

    @RequestMapping(value={"/{scmRepositoriesIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteScmRepositories(@PathVariable List<Long> scmRepositoriesIds) {
        this.scmRepositoryManager.deleteScmRepositories(scmRepositoriesIds);
    }

    @RequestMapping(value={"/{scmRepositoryId}"}, method={RequestMethod.POST}, params={"branch"})
    @ResponseBody
    public String updateBranch(@PathVariable long scmRepositoryId, String branch) throws IOException {
        return this.scmRepositoryManager.updateBranch(scmRepositoryId, branch);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"scmServerId"})
    @ResponseBody
    public List<ScmRepository> getScmRepositories(@RequestParam(value="scmServerId") long scmServerId) {
        return this.scmRepositoryManager.findClonedByScmServerOrderByName(scmServerId);
    }

    @RequestMapping(value={"/{scmRepositoryIds}"}, method={RequestMethod.GET}, params={"id=is-bound"})
    @ResponseBody
    public boolean isOneRepositoryBoundToProjectOrTestCase(@PathVariable Collection<Long> scmRepositoryIds) {
        return this.scmRepositoryManager.isOneRepositoryBoundToProjectOrTestCase(scmRepositoryIds);
    }
}

