/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.rest;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.testcase.TestCaseFinder;
import org.squashtest.tm.service.testcase.TestStepFinder;
import org.squashtest.tm.web.internal.model.rest.RestTestCase;
import org.squashtest.tm.web.internal.model.rest.RestTestStep;

@Controller
@RequestMapping(value={"/api/testcase"})
public class TestCaseRestController {
    @Inject
    private TestCaseFinder testCaseFinder;
    @Inject
    private TestStepFinder testStepFinder;

    private TestCase findTestCase(Long id) {
        TestCase testCase;
        block3: {
            testCase = null;
            try {
                testCase = this.testCaseFinder.findById(id.longValue());
            }
            catch (RuntimeException e) {
                if (!e.getCause().getClass().equals(InvocationTargetException.class)) break block3;
                throw new ResourceNotFoundException((Throwable)e);
            }
        }
        if (testCase == null) {
            throw new ResourceNotFoundException();
        }
        return testCase;
    }

    private List<TestStep> findTestSteps(Long id) {
        List testSteps;
        try {
            testSteps = this.testCaseFinder.findStepsByTestCaseId(id.longValue());
        }
        catch (RuntimeException e) {
            if (e.getCause().getClass().equals(InvocationTargetException.class)) {
                throw new ResourceNotFoundException((Throwable)e);
            }
            throw e;
        }
        return testSteps;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public RestTestCase getTestCaseById(@PathVariable Long id) {
        TestCase testCase = this.findTestCase(id);
        return new RestTestCase(testCase);
    }

    @RequestMapping(value={"/{id}/teststeps"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<RestTestStep> getTestStepsByTestCaseId(@PathVariable Long id) {
        List<TestStep> testSteps = this.findTestSteps(id);
        ArrayList<RestTestStep> restTestSteps = new ArrayList<RestTestStep>(testSteps.size());
        for (TestStep testStep : testSteps) {
            restTestSteps.add(new RestTestStep(testStep));
        }
        return restTestSteps;
    }

    @Deprecated
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    private final class ResourceNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = -649887942614579558L;

        public ResourceNotFoundException() {
        }

        public ResourceNotFoundException(Throwable cause) {
            super(cause);
        }
    }
}

