/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.rest;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.service.execution.ExecutionFinder;
import org.squashtest.tm.service.testcase.TestCaseLibraryFinderService;
import org.squashtest.tm.web.exception.ResourceNotFoundException;
import org.squashtest.tm.web.internal.model.rest.RestExecution;
import org.squashtest.tm.web.internal.model.rest.RestExecutionStep;

@Controller
@RequestMapping(value={"/api/execution"})
public class ExecutionRestController {
    @Inject
    private ExecutionFinder executionFinder;
    @Inject
    private TestCaseLibraryFinderService testCaseLibraryFinder;

    private Execution findExecution(Long id) {
        Execution execution = null;
        if (this.executionFinder.exists(id.longValue())) {
            execution = this.executionFinder.findById(id.longValue());
        }
        if (execution == null) {
            throw new ResourceNotFoundException();
        }
        return execution;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public RestExecution getExecutionById(@PathVariable Long id) {
        String path = "";
        Execution execution = this.findExecution(id);
        if (execution.getReferencedTestCase() != null) {
            path = this.testCaseLibraryFinder.getPathAsString(execution.getReferencedTestCase().getId().longValue());
        }
        return new RestExecution(execution, path);
    }

    @RequestMapping(value={"/{id}/executionsteps"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<RestExecutionStep> getExecutionStepsById(@PathVariable Long id) {
        Execution execution = this.findExecution(id);
        List steps = execution.getSteps();
        ArrayList<RestExecutionStep> restExecutionSteps = new ArrayList<RestExecutionStep>(steps.size());
        for (ExecutionStep step : steps) {
            restExecutionSteps.add(new RestExecutionStep(step));
        }
        return restExecutionSteps;
    }
}

