/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.rest;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.web.internal.model.rest.RestExecutionStub;

@Controller
@RequestMapping(value={"/api/bugtracker"})
public class BugtrackerRestController {
    @Inject
    private BugTrackersLocalService bugTrackersLocalService;

    @RequestMapping(value={"/{name}/issue/{remoteid}/executions"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<RestExecutionStub> getExecutionsByRemotedId(@PathVariable String name, @PathVariable String remoteid) {
        List executions = this.bugTrackersLocalService.findExecutionsByRemoteIssue(remoteid, name);
        ArrayList<RestExecutionStub> restExecutions = new ArrayList<RestExecutionStub>(executions.size());
        for (Execution execution : executions) {
            restExecutions.add(new RestExecutionStub(execution));
        }
        return restExecutions;
    }
}

