/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.requirement.importer;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.service.batchimport.excel.TemplateMismatchException;
import org.squashtest.tm.service.importer.ImportLog;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.web.importer.ImportHelper;
import org.squashtest.tm.web.internal.controller.testcase.importer.ImportFormatFailure;
import org.squashtest.tm.web.internal.controller.testcase.importer.RequirementImportLogHelper;

@Controller
@RequestMapping(value={"/requirements/importer"})
public class RequirementImportController {
    @Inject
    private RequirementLibraryNavigationService requirementLibraryNavigationService;
    @Inject
    private ImportHelper importHelper;
    @Inject
    private RequirementImportLogHelper logHelper;
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementImportController.class);
    private static final String REQ_IMPORT = "Req-Import";

    @RequestMapping(value={"/xls"}, method={RequestMethod.POST}, params={"dry-run"})
    public ModelAndView dryRunExcelWorkbook(@RequestParam(value="archive") MultipartFile uploadedFile, WebRequest request) {
        LOGGER.debug("Req-ImportIn controller, DRY RUN");
        return this.importWorkbook(uploadedFile, request, new Command<File, ImportLog>(){

            @Override
            public ImportLog execute(File xls) {
                return RequirementImportController.this.requirementLibraryNavigationService.simulateImportExcelRequirement(xls);
            }
        });
    }

    @RequestMapping(value={"/xls"}, params={"!dry-run"}, method={RequestMethod.POST})
    public ModelAndView importExcelWorkbook(@RequestParam(value="archive") MultipartFile uploadedFile, WebRequest request) {
        LOGGER.debug("Req-ImportIn controller, RUN");
        return this.importWorkbook(uploadedFile, request, new Command<File, ImportLog>(){

            @Override
            public ImportLog execute(File xls) {
                return RequirementImportController.this.requirementLibraryNavigationService.importExcelRequirement(xls);
            }
        });
    }

    private ModelAndView importWorkbook(MultipartFile uploadedFile, WebRequest request, Command<File, ImportLog> callback) {
        ModelAndView mav;
        block9: {
            mav = new ModelAndView("fragment/import/import-summary");
            File xls = null;
            try {
                xls = this.importHelper.multipartToImportFile(uploadedFile, "requirement-import-", ".xls");
                ImportLog summary = callback.execute(xls);
                summary.recompute();
                this.generateImportLog(request, summary);
                mav.addObject("summary", (Object)summary);
            }
            catch (IOException e) {
                LOGGER.error("An exception prevented processing of requirement import file", (Throwable)e);
                if (xls != null) {
                    xls.deleteOnExit();
                }
                break block9;
            }
            catch (TemplateMismatchException tme) {
                try {
                    ImportFormatFailure importFormatFailure = new ImportFormatFailure(tme);
                    mav.addObject("summary", (Object)importFormatFailure);
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (xls != null) {
                        xls.deleteOnExit();
                    }
                }
            }
            if (xls == null) break block9;
            xls.deleteOnExit();
        }
        mav.addObject("workspace", (Object)"requirement");
        LOGGER.debug("Req-ImportOUT controller, RUN");
        return mav;
    }

    private void generateImportLog(WebRequest request, ImportLog summary) {
        File xlsSummary = null;
        try {
            try {
                xlsSummary = this.importLogToLogFile(summary);
                String reportUrl = String.valueOf(request.getContextPath()) + "/requirement/import-logs/" + xlsSummary.getName();
                summary.setReportUrl(reportUrl);
            }
            catch (IOException e) {
                LOGGER.warn("An error occured during import log generation", (Throwable)e);
                if (xlsSummary != null) {
                    xlsSummary.deleteOnExit();
                }
            }
        }
        finally {
            if (xlsSummary != null) {
                xlsSummary.deleteOnExit();
            }
        }
    }

    private File importLogToLogFile(ImportLog summary) throws IOException {
        return this.logHelper.storeLogFile(summary);
    }

    private static interface Command<T, U> {
        public U execute(T var1);
    }
}

