/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.requirement;

import java.util.HashMap;
import java.util.Locale;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneModelUtils;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

class VerifyingTestCasesTableModelHelper
extends DataTableModelBuilder<TestCase> {
    private InternationalizationHelper helper;
    private Locale locale = LocaleContextHolder.getLocale();
    private PermissionEvaluationService permService;
    private static final int INT_MAX_DESCRIPTION_LENGTH = 50;

    public VerifyingTestCasesTableModelHelper(InternationalizationHelper helper, PermissionEvaluationService permService) {
        this.helper = helper;
        this.permService = permService;
    }

    @Override
    protected Object buildItemData(TestCase tc) {
        String type = this.formatExecutionMode(tc.getExecutionMode());
        HashMap<String, Object> row = new HashMap<String, Object>(7);
        row.put("tc-id", tc.getId().toString());
        row.put("tc-index", Long.toString(this.getCurrentIndex()));
        row.put("project-name", HtmlUtils.htmlEscape((String)tc.getProject().getName()));
        row.put("tc-reference", HtmlUtils.htmlEscape((String)tc.getReference()));
        row.put("tc-name", HtmlUtils.htmlEscape((String)tc.getName()));
        row.put("tc-type", type);
        row.put("milestone-dates", MilestoneModelUtils.timeIntervalToString(tc.getMilestones(), this.helper, this.locale));
        row.put("empty-delete-holder", null);
        row.put("milestone", MilestoneModelUtils.milestoneLabelsOrderByDate(tc.getMilestones()));
        row.put("tc-description", HTMLCleanupUtils.getCleanedBriefText(tc.getDescription(), 50));
        row.put("readable", this.permService.canRead((Object)tc));
        return row;
    }

    private String formatExecutionMode(TestCaseExecutionMode mode) {
        return this.helper.internationalize((Internationalizable)mode, this.locale);
    }
}

