/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.requirement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.collections.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.acls.domain.IdentityUnavailableException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.core.foundation.collection.DefaultPagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementCoverageStat;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.exception.requirement.VerifiedRequirementException;
import org.squashtest.tm.service.campaign.CampaignModificationService;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.milestone.MilestoneModelService;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.requirement.VerifiedRequirementsManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testcase.VerifyingTestCaseManagerService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.controller.requirement.VerifyingTestCasesTableModelHelper;
import org.squashtest.tm.web.internal.helper.JsTreeHelper;
import org.squashtest.tm.web.internal.helper.VerifiedRequirementActionSummaryBuilder;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableSorting;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
public class VerifyingTestCaseManagerController {
    @Inject
    @Named(value="testCase.driveNodeBuilder")
    private Provider<DriveNodeBuilder<TestCaseLibraryNode>> driveNodeBuilder;
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private VerifyingTestCaseManagerService verifyingTestCaseManager;
    @Inject
    private RequirementVersionManagerService requirementVersionFinder;
    @Inject
    private VerifiedRequirementsManagerService verifiedRequirementsManagerService;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    @Inject
    private CampaignModificationService campaignModificationService;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    @Named(value="testCaseWorkspaceDisplayService")
    private WorkspaceDisplayService testCaseWorkspaceDisplayService;
    @Inject
    private PermissionEvaluationService permService;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private MilestoneModelService milestoneModelService;
    private static final String campaign_name = "Campaign";
    private static final String iteration_name = "Iteration";
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifyingTestCaseManagerController.class);
    private final DatatableMapper<String> verifyingTcMapper = new NameBasedMapper(6).mapAttribute("project-name", "name", Project.class).mapAttribute("tc-reference", "reference", TestCase.class).mapAttribute("tc-name", "name", TestCase.class).mapAttribute("tc-type", "executionMode", TestCase.class).map("milestone-dates", "endDate");

    public void setUserAccountService(UserAccountService userAccountService) {
        this.userAccountService = userAccountService;
    }

    @RequestMapping(value={"/requirement-versions/{requirementVersionId}/verifying-test-cases/manager"}, method={RequestMethod.GET})
    public String showManager(@PathVariable long requirementVersionId, Model model, @CookieValue(value="jstree_verif_open", required=false, defaultValue="") String[] openedNodes) {
        RequirementVersion requirementVersion = this.requirementVersionFinder.findById(requirementVersionId);
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(requirementVersion);
        MultiMap expansionCandidates = JsTreeHelper.mapIdsByType(openedNodes);
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List projectIds = this.verifyingTestCaseManager.findLinkableTestCaseLibraries().stream().map(TestCaseLibrary::getProject).map(GenericProject::getId).collect(Collectors.toList());
        Optional activeMilestoneId = this.activeMilestoneHolder.getActiveMilestoneId();
        Collection linkableLibrariesModel = this.testCaseWorkspaceDisplayService.findAllLibraries(projectIds, currentUser, expansionCandidates, (Long)activeMilestoneId.get());
        DefaultPagingAndSorting pas = new DefaultPagingAndSorting("Project.name");
        DataTableModel verifyingTCModel = this.buildVerifyingTestCaseModel(requirementVersionId, (PagingAndSorting)pas, "");
        model.addAttribute("requirement", (Object)requirementVersion.getRequirement());
        model.addAttribute("requirementVersion", (Object)requirementVersion);
        model.addAttribute("linkableLibrariesModel", (Object)linkableLibrariesModel);
        model.addAttribute("verifyingTestCaseModel", (Object)verifyingTCModel);
        model.addAttribute("milestoneConf", (Object)milestoneConf);
        return "page/requirement-workspace/show-verifying-testcase-manager";
    }

    @ResponseBody
    @RequestMapping(value={"/requirement-versions/{requirementVersionId}/verifying-test-cases/{testCaseIds}"}, method={RequestMethod.POST})
    public Map<String, Object> addVerifyingTestCasesToRequirement(@PathVariable(value="testCaseIds") List<Long> testCasesIds, @PathVariable long requirementVersionId) {
        Map rejectionsAndIds = this.verifyingTestCaseManager.addVerifyingTestCasesToRequirementVersion(testCasesIds, requirementVersionId);
        Collection rejections = (Collection)rejectionsAndIds.get("REJECTION");
        Collection ids = (Collection)rejectionsAndIds.get("IDS");
        Map<String, Object> result = this.buildSummary(rejections);
        result.put("linkedIds", ids);
        return result;
    }

    private Map<String, Object> buildSummary(Collection<VerifiedRequirementException> rejections) {
        return VerifiedRequirementActionSummaryBuilder.buildAddActionSummary(rejections);
    }

    @ResponseBody
    @RequestMapping(value={"/requirement-versions/{requirementVersionId}/verifying-test-cases/{testCaseIds}"}, method={RequestMethod.DELETE})
    public void removeVerifyingTestCaseFromRequirement(@PathVariable(value="requirementVersionId") long requirementVersionId, @PathVariable(value="testCaseIds") List<Long> testCaseIds) {
        this.verifyingTestCaseManager.removeVerifyingTestCasesFromRequirementVersion(testCaseIds, requirementVersionId);
    }

    @ResponseBody
    @RequestMapping(value={"/requirement-versions/{requirementVersionId}/verifying-test-cases/table"}, params={"sEcho"})
    public DataTableModel getVerifiedTestCasesTableModel(@PathVariable long requirementVersionId, DataTableDrawParameters params) {
        DataTableSorting filter = new DataTableSorting(params, this.verifyingTcMapper);
        return this.buildVerifyingTestCaseModel(requirementVersionId, filter, params.getsEcho());
    }

    protected DataTableModel buildVerifyingTestCaseModel(long requirementVersionId, PagingAndSorting pas, String sEcho) {
        PagedCollectionHolder holder = this.verifyingTestCaseManager.findAllByRequirementVersion(requirementVersionId, pas);
        return new VerifyingTestCasesTableModelHelper(this.i18nHelper, this.permService).buildDataModel(holder, sEcho);
    }

    @ResponseBody
    @RequestMapping(value={"/requirement-versions/{requirementVersionId}/coverage-stats"}, method={RequestMethod.GET}, params={"perimeter"})
    public RequirementCoverageStat getCoverageStat(@PathVariable long requirementVersionId, @RequestParam String perimeter) {
        List ids;
        MultiMap mapIdsByType = JsTreeHelper.mapIdsByType(new String[]{perimeter});
        ArrayList<Long> iterationIds = new ArrayList<Long>();
        RequirementCoverageStat stat = new RequirementCoverageStat();
        if (mapIdsByType.containsKey((Object)campaign_name)) {
            ids = (List)mapIdsByType.get((Object)campaign_name);
            try {
                Campaign campaign = this.campaignModificationService.findCampaigWithExistenceCheck(((Long)ids.get(0)).longValue());
                if (campaign != null) {
                    iterationIds.addAll(this.getIterationsIdsForCampagain(campaign));
                } else {
                    stat.setCorruptedPerimeter(true);
                }
            }
            catch (IdentityUnavailableException e) {
                LOGGER.debug("Unavailable Identity", (Throwable)e);
                stat.setCorruptedPerimeter(true);
            }
        }
        if (mapIdsByType.containsKey((Object)iteration_name)) {
            ids = (List)mapIdsByType.get((Object)iteration_name);
            iterationIds.addAll(ids);
        }
        this.verifiedRequirementsManagerService.findCoverageStat(Long.valueOf(requirementVersionId), iterationIds, stat);
        return stat;
    }

    private List<Long> getIterationsIdsForCampagain(Campaign campaign) {
        ArrayList<Long> iterationIds = new ArrayList<Long>();
        for (Iteration it : campaign.getIterations()) {
            iterationIds.add(it.getId());
        }
        return iterationIds;
    }
}

