/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.requirement;

import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.service.library.WorkspaceService;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.generic.WorkspaceController;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;
import org.squashtest.tm.web.internal.model.rest.RestLibrary;

@Controller
@RequestMapping(value={"/requirement-workspace"})
public class RequirementWorkspaceController
extends WorkspaceController<RequirementLibraryNode<?>> {
    @Inject
    @Named(value="squashtest.tm.service.RequirementsWorkspaceService")
    private WorkspaceService<RequirementLibrary> workspaceService;
    @Inject
    @Named(value="requirement.driveNodeBuilder")
    private Provider<DriveNodeBuilder<RequirementLibraryNode<?>>> driveNodeBuilderProvider;
    @Inject
    private RequirementLibraryNavigationService requirementLibraryNavigationService;
    @Inject
    private WorkspaceDisplayService requirementWorkspaceDisplayService;

    @Override
    protected WorkspaceService<RequirementLibrary> getWorkspaceService() {
        return this.workspaceService;
    }

    @Override
    protected String getWorkspaceViewName() {
        return "requirement-workspace.html";
    }

    @Override
    protected void populateModel(Model model, Locale locale) {
        List<RestLibrary> libraries = this.getEditableLibraries(model);
        model.addAttribute("editableLibraries", libraries);
    }

    @Override
    protected WorkspaceType getWorkspaceType() {
        return WorkspaceType.REQUIREMENT_WORKSPACE;
    }

    @Override
    protected Provider<DriveNodeBuilder<RequirementLibraryNode<?>>> driveNodeBuilderProvider() {
        return this.driveNodeBuilderProvider;
    }

    @Override
    protected String[] getNodeParentsInWorkspace(EntityReference entityReference) {
        List parents = this.requirementLibraryNavigationService.getParentNodesAsStringList(entityReference.getId());
        return parents.toArray(new String[parents.size()]);
    }

    @Override
    protected String getTreeElementIdInWorkspace(EntityReference entityReference) {
        return "Requirement-" + entityReference.getId();
    }

    @Override
    protected WorkspaceDisplayService workspaceDisplayService() {
        return this.requirementWorkspaceDisplayService;
    }
}

