/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.requirement;

import javax.inject.Inject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.requirement.RequirementVersionResolverService;
import org.squashtest.tm.web.internal.model.jquery.RenameModel;

@Controller
@RequestMapping(value={"/requirements/{requirementId}"})
public class RequirementVersionResolverController {
    @Inject
    private RequirementVersionResolverService versionResolver;
    @Inject
    private RequirementVersionManagerService requirementVersionManager;

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.MOVED_PERMANENTLY)
    public String resolveRequirementInfo(@PathVariable(value="requirementId") long requirementId) {
        RequirementVersion version = this.versionResolver.resolveByRequirementId(requirementId);
        return "redirect:/requirement-versions/" + version.getId() + "/info";
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.MOVED_PERMANENTLY)
    public String resolveRequirement(@PathVariable(value="requirementId") long requirementId) {
        RequirementVersion version = this.versionResolver.resolveByRequirementId(requirementId);
        return "redirect:/requirement-versions/" + version.getId();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, params={"newName"})
    public Object rename(@PathVariable(value="requirementId") long requirementId, @RequestParam(value="newName") String newName) {
        RequirementVersion version = this.versionResolver.resolveByRequirementId(requirementId);
        this.requirementVersionManager.rename(version.getId().longValue(), newName);
        return new RenameModel(newName);
    }
}

