/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.requirement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.collection.DefaultPagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.SinglePageCollectionHolder;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.bugtracker.RemoteIssueDecorator;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCoverageStat;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.synchronisation.SynchronisationStatus;
import org.squashtest.tm.exception.UnknownEntityException;
import org.squashtest.tm.service.audit.RequirementAuditTrailService;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.bugtracker.RequirementVersionIssueOwnership;
import org.squashtest.tm.service.customfield.CustomFieldHelperService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.internal.dto.json.JsonInfoList;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.service.requirement.RequirementBulkUpdate;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testcase.VerifyingTestCaseManagerService;
import org.squashtest.tm.web.internal.controller.audittrail.RequirementAuditEventTableModelBuilder;
import org.squashtest.tm.web.internal.controller.bugtracker.BugTrackerControllerHelper;
import org.squashtest.tm.web.internal.controller.generic.ServiceAwareAttachmentTableModelHelper;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestonePanelConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneTableModelHelper;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.controller.requirement.LinkedRequirementVersionsTableModelHelper;
import org.squashtest.tm.web.internal.controller.requirement.RequirementCriticalityComboDataBuilder;
import org.squashtest.tm.web.internal.controller.requirement.RequirementStatusComboDataBuilder;
import org.squashtest.tm.web.internal.controller.requirement.VerifyingTestCaseManagerController;
import org.squashtest.tm.web.internal.controller.requirement.VerifyingTestCasesTableModelHelper;
import org.squashtest.tm.web.internal.helper.LevelLabelFormatter;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.JsonInfoListBuilder;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.jquery.RenameModel;
import org.squashtest.tm.web.internal.model.json.JsonGeneralInfo;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/requirement-versions/{requirementVersionId}"})
public class RequirementVersionModificationController {
    private static final String REQUIREMENT_VERSION_ID = "requirementVersionId";
    @Inject
    private Provider<RequirementCriticalityComboDataBuilder> criticalityComboBuilderProvider;
    @Inject
    private Provider<RequirementStatusComboDataBuilder> statusComboDataBuilderProvider;
    @Inject
    private Provider<LevelLabelFormatter> levelFormatterProvider;
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private VerifyingTestCaseManagerService verifyingTestCaseManager;
    @Inject
    private LinkedRequirementVersionManagerService linkedReqVersionManager;
    @Inject
    private ServiceAwareAttachmentTableModelHelper attachmentsHelper;
    @Inject
    private CustomFieldHelperService cufHelperService;
    @Inject
    private RequirementVersionManagerService requirementVersionManager;
    @Inject
    private CustomFieldValueFinderService cufValueService;
    @Inject
    private InfoListItemFinderService infoListItemService;
    @Inject
    private JsonInfoListBuilder infoListBuilder;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private BugTrackerControllerHelper bugTrackerControllerHelper;
    @Inject
    private BugTrackersLocalService bugTrackersLocalService;
    @Inject
    private VerifyingTestCaseManagerController verifyingTestCaseManagerController;
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementVersionModificationController.class);
    private RequirementAuditTrailService auditTrailService;

    @RequestMapping(value={"/editor-fragment"}, method={RequestMethod.GET})
    public String getRequirementEditor(@PathVariable long requirementVersionId, Model model, Locale locale) {
        this.populateRequirementEditorModel(requirementVersionId, model, locale);
        return "fragment/requirements/requirement-version-editor";
    }

    @RequestMapping(method={RequestMethod.GET})
    public String showRequirementVersion(@PathVariable long requirementVersionId, Model model, Locale locale) {
        this.populateRequirementEditorModel(requirementVersionId, model, locale);
        return "fragment/requirements/requirement-version";
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public String showRequirementVersionInfos(@PathVariable long requirementVersionId, Model model, Locale locale) {
        this.populateRequirementEditorModel(requirementVersionId, model, locale);
        return "page/requirement-workspace/show-requirement-version";
    }

    @ResponseBody
    @GetMapping(value={"/name"}, produces={"text/plain"})
    public String getRequirementVersionFullName(@PathVariable long requirementVersionId) {
        RequirementVersion version = this.requirementVersionManager.findById(requirementVersionId);
        return version.getName();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, params={"id=requirement-description", "value"}, produces={"text/plain;charset=UTF-8"})
    public String changeDescription(@PathVariable long requirementVersionId, @RequestParam(value="value") String newDescription) {
        this.requirementVersionManager.changeDescription(requirementVersionId, newDescription);
        return HTMLCleanupUtils.cleanHtml(newDescription);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=requirement-criticality", "value"})
    @ResponseBody
    public String changeCriticality(@PathVariable long requirementVersionId, @RequestParam(value="value") RequirementCriticality criticality, Locale locale) {
        this.requirementVersionManager.changeCriticality(requirementVersionId, criticality);
        return this.internationalize((Level)criticality, locale);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=requirement-category", "value"})
    @ResponseBody
    public String changeCategory(@PathVariable long requirementVersionId, @RequestParam(value="value") String categoryCode, Locale locale) {
        this.requirementVersionManager.changeCategory(requirementVersionId, categoryCode);
        InfoListItem category = this.infoListItemService.findByCode(categoryCode);
        return this.formatInfoItem(category, locale);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=requirement-status", "value"})
    @ResponseBody
    public String changeStatus(@PathVariable long requirementVersionId, @RequestParam(value="value") String value, Locale locale) {
        RequirementStatus status = RequirementStatus.valueOf((String)value);
        this.requirementVersionManager.changeStatus(requirementVersionId, status);
        return this.internationalize((Level)status, locale);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=requirement-reference", "value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    String changeReference(@PathVariable long requirementVersionId, @RequestParam(value="value") String requirementReference) {
        this.requirementVersionManager.changeReference(requirementVersionId, requirementReference.trim());
        return HtmlUtils.htmlEscape((String)requirementReference);
    }

    @RequestMapping(value={"/bulk-update"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    void bulkUpdate(@PathVariable(value="requirementVersionId") List<Long> requirementId, @RequestBody RequirementBulkUpdate bulkUpdate) {
        this.requirementVersionManager.bulkUpdate(requirementId, bulkUpdate);
    }

    private String internationalize(Level level, Locale locale) {
        return ((LevelLabelFormatter)this.levelFormatterProvider.get()).useLocale(locale).formatLabel(level);
    }

    private void populateRequirementEditorModel(long requirementVersionId, Model model, Locale locale) {
        RequirementVersion requirementVersion = this.requirementVersionManager.findById(requirementVersionId);
        String criticalities = this.buildMarshalledCriticalities(locale);
        boolean hasCUF = this.cufValueService.hasCustomFields((BoundEntity)requirementVersion);
        JsonInfoList categories = this.infoListBuilder.toJson(requirementVersion.getProject().getRequirementCategories());
        DataTableModel verifyingTCModel = this.getVerifyingTCModel(requirementVersion);
        DataTableModel linkedReqVersionsModel = this.getLinkedReqVersionsModel(requirementVersion);
        DataTableModel attachmentsModel = this.attachmentsHelper.findPagedAttachments((AttachmentHolder)requirementVersion);
        DataTableModel auditTrailModel = this.getEventsTableModel(requirementVersion);
        model.addAttribute("requirementVersion", (Object)requirementVersion);
        model.addAttribute("criticalityList", (Object)criticalities);
        model.addAttribute("categoryList", (Object)categories);
        model.addAttribute("hasCUF", (Object)hasCUF);
        model.addAttribute("verifyingTestCasesModel", (Object)verifyingTCModel);
        model.addAttribute("linkedRequirementVersionsModel", (Object)linkedReqVersionsModel);
        model.addAttribute("attachmentsModel", (Object)attachmentsModel);
        model.addAttribute("auditTrailModel", (Object)auditTrailModel);
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(requirementVersion);
        model.addAttribute("milestoneConf", (Object)milestoneConf);
        this.addSynchronizedAttributes(model, requirementVersion, locale);
    }

    private void addSynchronizedAttributes(Model model, RequirementVersion requirementVersion, Locale locale) {
        if (requirementVersion.getRequirement().isSynchronized()) {
            RequirementSyncExtender syncExtender = requirementVersion.getRequirement().getSyncExtender();
            model.addAttribute("requirementURL", (Object)syncExtender.getRemoteUrl());
            this.addSyncStatus(model, syncExtender, locale);
        }
    }

    private void addSyncStatus(Model model, RequirementSyncExtender syncExtender, Locale locale) {
        RemoteSynchronisation remoteSynchronisation = syncExtender.getRemoteSynchronisation();
        if (remoteSynchronisation != null) {
            SynchronisationStatus status = remoteSynchronisation.getLastSynchronisationStatus();
            String i18nStatus = this.i18nHelper.internationalize("label." + status.getI18nKey(), locale);
            model.addAttribute("remoteSynchronisationStatus", (Object)i18nStatus);
        }
    }

    private DataTableModel getVerifyingTCModel(RequirementVersion version) {
        PagedCollectionHolder holder = this.verifyingTestCaseManager.findAllByRequirementVersion(version.getId().longValue(), (PagingAndSorting)new DefaultPagingAndSorting("Project.name"));
        return new VerifyingTestCasesTableModelHelper(this.i18nHelper, this.permissionService).buildDataModel(holder, "0");
    }

    private DataTableModel getLinkedReqVersionsModel(RequirementVersion version) {
        PagedCollectionHolder holder = this.linkedReqVersionManager.findAllByRequirementVersion(version.getId().longValue(), (PagingAndSorting)new DefaultPagingAndSorting("Project.name"));
        return new LinkedRequirementVersionsTableModelHelper(this.i18nHelper).buildDataModel(holder, "0");
    }

    private DataTableModel getKnownIssuesDataForRequirementVersion(String entityType, Long id, String panelSource, PagingAndSorting paging, String sEcho) {
        PagedCollectionHolder filteredCollection = this.bugTrackersLocalService.findSortedIssueOwnershipForRequirmentVersion(id, panelSource, paging);
        return this.bugTrackerControllerHelper.createModelBuilderForRequirementVersion().buildDataModel((PagedCollectionHolder<List<RequirementVersionIssueOwnership<RemoteIssueDecorator>>>)filteredCollection, sEcho);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/next-status"})
    @ResponseBody
    public Map<String, String> getNextStatusList(Locale locale, @PathVariable long requirementVersionId) {
        RequirementVersion requirementVersion = this.requirementVersionManager.findById(requirementVersionId);
        RequirementStatus status = requirementVersion.getStatus();
        return ((RequirementStatusComboDataBuilder)((RequirementStatusComboDataBuilder)((RequirementStatusComboDataBuilder)this.statusComboDataBuilderProvider.get()).useLocale(locale)).selectItem(status)).buildMap();
    }

    @RequestMapping(value={"/general"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JsonGeneralInfo refreshGeneralInfos(@PathVariable long requirementVersionId) {
        RequirementVersion version = this.requirementVersionManager.findById(requirementVersionId);
        return new JsonGeneralInfo((AuditableMixin)version);
    }

    private String buildMarshalledCriticalities(Locale locale) {
        return ((RequirementCriticalityComboDataBuilder)((RequirementCriticalityComboDataBuilder)this.criticalityComboBuilderProvider.get()).useLocale(locale)).buildMarshalled();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, params={"newName"})
    public Object rename(@PathVariable long requirementVersionId, @RequestParam(value="newName") String newName) {
        this.requirementVersionManager.rename(requirementVersionId, newName);
        return new RenameModel(newName);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=requirement-name", "value"})
    @ResponseBody
    public String changeName(@PathVariable long requirementVersionId, @RequestParam(value="value") String value, Locale locale) {
        this.requirementVersionManager.rename(requirementVersionId, value);
        return HtmlUtils.htmlEscape((String)value);
    }

    private DataTableModel getEventsTableModel(RequirementVersion requirementVersion) {
        PageRequest pageable = new PageRequest(0, 50, Sort.Direction.DESC, new String[]{"date"});
        Page auditTrail = this.auditTrailService.findAllByRequirementVersionIdOrderedByDate(requirementVersion.getId().longValue(), (Pageable)pageable);
        RequirementAuditEventTableModelBuilder builder = new RequirementAuditEventTableModelBuilder(LocaleContextHolder.getLocale(), this.i18nHelper);
        return builder.buildDataModel(auditTrail, "");
    }

    @RequestMapping(value={"/version-numbers"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> showAllVersions(Locale locale, @PathVariable long requirementVersionId) {
        LinkedHashMap<String, String> versionsNumbersById = new LinkedHashMap<String, String>();
        RequirementVersion requirementVersion = this.requirementVersionManager.findById(requirementVersionId);
        Requirement requirement = requirementVersion.getRequirement();
        List requirementVersions = requirement.getRequirementVersions();
        ArrayList<RequirementVersion> cloneRequirementVersions = new ArrayList<RequirementVersion>();
        for (RequirementVersion rv : requirementVersions) {
            cloneRequirementVersions.add(rv);
        }
        Collections.sort(cloneRequirementVersions, new MyRequirementVersionsDecOrder());
        for (RequirementVersion version : cloneRequirementVersions) {
            if (version.getStatus() == RequirementStatus.OBSOLETE) continue;
            String status = this.i18nHelper.internationalize("requirement.status." + version.getStatus().name(), locale);
            versionsNumbersById.put(String.valueOf(version.getId()), String.valueOf(version.getVersionNumber()) + " (" + status + ")");
        }
        versionsNumbersById.put("selected", String.valueOf(requirementVersionId));
        return versionsNumbersById;
    }

    @Inject
    public void setAuditTrailService(RequirementAuditTrailService auditTrailService) {
        this.auditTrailService = auditTrailService;
    }

    private String formatInfoItem(InfoListItem nature, Locale locale) {
        return this.i18nHelper.getMessage(nature.getLabel(), null, nature.getLabel(), locale);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"format=printable"})
    public ModelAndView printRequirementVersion(@PathVariable long requirementVersionId, Locale locale, @RequestParam(value="perimeter") String perimeter, @RequestParam(value="name") String name) {
        ModelAndView mav = new ModelAndView("print-requirement-version.html");
        RequirementVersion version = this.requirementVersionManager.findById(requirementVersionId);
        if (version == null) {
            throw new UnknownEntityException(requirementVersionId, RequirementVersion.class);
        }
        mav.addObject("requirementVersion", (Object)version);
        List customFieldValues = this.cufHelperService.newHelper((BoundEntity)version).getCustomFieldValues();
        mav.addObject("requirementVersionCufValues", (Object)customFieldValues);
        List verifyingTC = this.verifyingTestCaseManager.findAllByRequirementVersion(requirementVersionId);
        mav.addObject("verifyingTestCases", (Object)verifyingTC);
        List versions = this.requirementVersionManager.findAllByRequirement(version.getRequirement().getId().longValue());
        mav.addObject("siblingVersions", (Object)versions);
        Page auditTrail = this.auditTrailService.findAllByRequirementVersionIdOrderedByDate(requirementVersionId);
        RequirementAuditEventTableModelBuilder builder = new RequirementAuditEventTableModelBuilder(locale, this.i18nHelper);
        DataTableModel auditTrailModel = builder.buildDataModel(auditTrail, "1");
        mav.addObject("auditTrailDatas", auditTrailModel.getAaData());
        RequirementVersion requirementVersion = this.requirementVersionManager.findById(requirementVersionId);
        DataTableModel linkedReqVersionsModel = this.getLinkedReqVersionsModel(requirementVersion);
        mav.addObject("linkRequirement", linkedReqVersionsModel.getAaData());
        Collection milestones = this.requirementVersionManager.findAllMilestones(requirementVersionId);
        mav.addObject("milestone", (Object)milestones);
        DataTableModel issueModel = this.getKnownIssuesDataForRequirementVersion("requirement-version", requirementVersionId, "all", (PagingAndSorting)new DefaultPagingAndSorting(), "0");
        mav.addObject("issueModel", issueModel.getAaData());
        RequirementCoverageStat stat = this.verifyingTestCaseManagerController.getCoverageStat(requirementVersionId, perimeter);
        if (stat.isCorruptedPerimeter() || name.equals("")) {
            name = this.i18nHelper.internationalize("label.None", locale);
            mav.addObject("name", (Object)name);
        } else {
            mav.addObject("name", (Object)name);
        }
        mav.addObject("stat", (Object)stat.getRates());
        return mav;
    }

    @RequestMapping(value={"/milestones"}, method={RequestMethod.GET})
    @ResponseBody
    public DataTableModel getBoundMilestones(@PathVariable(value="requirementVersionId") long requirementVersionId, DataTableDrawParameters params) {
        Collection allMilestones = this.requirementVersionManager.findAllMilestones(requirementVersionId);
        return this.buildMilestoneModel(new ArrayList<Milestone>(allMilestones), params.getsEcho());
    }

    @RequestMapping(value={"/milestones/{milestoneIds}"}, method={RequestMethod.POST})
    @ResponseBody
    public void bindMilestones(@PathVariable(value="requirementVersionId") long requirementVersionId, @PathVariable(value="milestoneIds") List<Long> milestoneIds) {
        this.requirementVersionManager.bindMilestones(requirementVersionId, milestoneIds);
    }

    @RequestMapping(value={"/milestones/{milestoneIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void unbindMilestones(@PathVariable(value="requirementVersionId") long requirementVersionId, @PathVariable(value="milestoneIds") List<Long> milestoneIds) {
        this.requirementVersionManager.unbindMilestones(requirementVersionId, milestoneIds);
    }

    @RequestMapping(value={"/milestones/associables"}, method={RequestMethod.GET})
    @ResponseBody
    public DataTableModel getNotYetBoundMilestones(@PathVariable(value="requirementVersionId") long requirementVersionId, DataTableDrawParameters params) {
        Collection notBoundMilestones = this.requirementVersionManager.findAssociableMilestones(requirementVersionId);
        return this.buildMilestoneModel(new ArrayList<Milestone>(notBoundMilestones), params.getsEcho());
    }

    @RequestMapping(value={"/milestones/panel"}, method={RequestMethod.GET})
    public String getMilestonesPanel(@PathVariable(value="requirementVersionId") Long requirementVersionId, Model model) {
        MilestonePanelConfiguration conf = new MilestonePanelConfiguration();
        RequirementVersion version = this.requirementVersionManager.findById(requirementVersionId.longValue());
        Collection allMilestones = this.requirementVersionManager.findAllMilestones(requirementVersionId.longValue());
        List currentModel = this.buildMilestoneModel(new ArrayList<Milestone>(allMilestones), "0").getAaData();
        HashMap<String, String> identity = new HashMap<String, String>();
        identity.put("restype", "requirements");
        identity.put("resid", version.getRequirement().getId().toString());
        String rootPath = "requirement-versions/" + requirementVersionId.toString();
        Boolean editable = this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "LINK", (Object)version);
        List mil = version.getProject().getMilestones();
        CollectionUtils.filter((Collection)mil, (Predicate)new Predicate(){

            public boolean evaluate(Object milestone) {
                return ((Milestone)milestone).getStatus().isBindableToObject();
            }
        });
        Boolean isMilestoneInProject = !mil.isEmpty();
        conf.setNodeType("requirement-version");
        conf.setRootPath(rootPath);
        conf.setIdentity(identity);
        conf.setCurrentModel(currentModel);
        conf.setEditable(editable);
        conf.setIsMilestoneInProject(isMilestoneInProject);
        model.addAttribute("conf", (Object)conf);
        return "milestones/milestones-tab.html";
    }

    private DataTableModel buildMilestoneModel(List<Milestone> milestones, String sEcho) {
        SinglePageCollectionHolder collectionHolder = new SinglePageCollectionHolder(milestones);
        Locale locale = LocaleContextHolder.getLocale();
        return new MilestoneTableModelHelper(this.i18nHelper, locale).buildDataModel(collectionHolder, sEcho);
    }

    public static class MyRequirementVersionsDecOrder
    implements Comparator<RequirementVersion> {
        @Override
        public int compare(RequirementVersion rV1, RequirementVersion rV2) {
            return rV1.getVersionNumber() > rV2.getVersionNumber() ? -1 : (rV1.getVersionNumber() == rV2.getVersionNumber() ? 0 : 1);
        }
    }
}

