/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.requirement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.collection.DefaultPagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.SinglePageCollectionHolder;
import org.squashtest.tm.core.foundation.collection.SpringPaginationUtils;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.audit.RequirementAuditTrailService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testcase.VerifyingTestCaseManagerService;
import org.squashtest.tm.web.internal.controller.audittrail.RequirementAuditEventTableModelBuilder;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneModelUtils;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.controller.requirement.LinkedRequirementVersionsTableModelHelper;
import org.squashtest.tm.web.internal.controller.requirement.RequirementCriticalityComboDataBuilder;
import org.squashtest.tm.web.internal.controller.requirement.VerifyingTestCasesTableModelHelper;
import org.squashtest.tm.web.internal.helper.LevelLabelFormatter;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.JsonInfoListBuilder;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.model.datatable.SpringPagination;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
@RequestMapping(value={"/requirements/{requirementId}/versions"})
public class RequirementVersionManagerController {
    private static final String REFERENCE = "reference";
    private static final String STATUS = "status";
    private static final String CRITICALITY = "criticality";
    private static final String CATEGORY = "category";
    @Inject
    private RequirementVersionManagerService versionService;
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private Provider<LevelLabelFormatter> levelFormatterProvider;
    @Inject
    private CustomFieldValueFinderService cufValueService;
    @Inject
    private JsonInfoListBuilder infoListBuilder;
    @Inject
    private Provider<RequirementCriticalityComboDataBuilder> criticalityComboBuilderProvider;
    @Inject
    private VerifyingTestCaseManagerService verifyingTestCaseManager;
    @Inject
    private LinkedRequirementVersionManagerService linkedRequirementsManager;
    @Inject
    private RequirementAuditTrailService auditTrailService;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private PermissionEvaluationService permService;
    private final DatatableMapper<String> versionMapper = new NameBasedMapper().map("version-number", "versionNumber").map("reference", "reference").map("name", "name").map("status", "status").map("criticality", "criticality").map("category", "category");

    @RequestMapping(value={"/new"}, method={RequestMethod.POST}, params={"inheritReqLinks", "inheritTestcasesReqLinks"})
    @ResponseBody
    public void createNewVersion(@PathVariable long requirementId, @RequestParam(value="inheritReqLinks") boolean inheritReqLinks, @RequestParam(value="inheritTestcasesReqLinks") boolean inheritTestcasesReqLinks) {
        Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            ArrayList<Long> milestoneIds = new ArrayList<Long>();
            milestoneIds.add(((Milestone)activeMilestone.get()).getId());
            this.versionService.createNewVersion(requirementId, milestoneIds, inheritReqLinks, inheritTestcasesReqLinks);
        } else {
            this.versionService.createNewVersion(requirementId, inheritReqLinks, inheritTestcasesReqLinks);
        }
    }

    @RequestMapping(value={"/manager"})
    public String showRequirementVersionsManager(@PathVariable long requirementId, Model model, Locale locale) {
        Requirement req = this.versionService.findRequirementById(requirementId);
        SinglePageCollectionHolder holder = new SinglePageCollectionHolder((Collection)req.getUnmodifiableVersions());
        DataTableModel tableModel = new RequirementVersionDataTableModel(locale, this.levelFormatterProvider, this.i18nHelper).buildDataModel(holder, "0");
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(req.getCurrentVersion());
        model.addAttribute("requirement", (Object)req);
        model.addAttribute("versions", (Object)req.getUnmodifiableVersions());
        model.addAttribute("versionsTableModel", (Object)tableModel);
        model.addAttribute("selectedVersion", (Object)req.getCurrentVersion());
        model.addAttribute("criticalityList", (Object)this.buildMarshalledCriticalities(locale));
        model.addAttribute("categoryList", (Object)this.infoListBuilder.toJson(req.getProject().getRequirementCategories()));
        model.addAttribute("verifyingTestCasesModel", (Object)this.getVerifyingTCModel(req.getCurrentVersion()));
        model.addAttribute("linkedRequirementVersionsModel", (Object)this.getLinkedReqVersionsModel(req.getCurrentVersion()));
        model.addAttribute("auditTrailModel", (Object)this.getEventsTableModel(req));
        model.addAttribute("milestoneConf", (Object)milestoneConf);
        boolean hasCUF = this.cufValueService.hasCustomFields((BoundEntity)req.getCurrentVersion());
        model.addAttribute("hasCUF", (Object)hasCUF);
        return "page/requirement-workspace/versions-manager";
    }

    @RequestMapping(value={"/table"}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getRequirementVersionsTableModel(@PathVariable long requirementId, DataTableDrawParameters params, Locale locale) {
        Pageable pageable = SpringPagination.pageable(params, this.versionMapper);
        Page page = this.versionService.findAllByRequirement(requirementId, pageable);
        return new RequirementVersionDataTableModel(locale, this.levelFormatterProvider, this.i18nHelper).buildDataModel(page, params.getsEcho());
    }

    private String buildMarshalledCriticalities(Locale locale) {
        return ((RequirementCriticalityComboDataBuilder)((RequirementCriticalityComboDataBuilder)this.criticalityComboBuilderProvider.get()).useLocale(locale)).buildMarshalled();
    }

    private DataTableModel getVerifyingTCModel(RequirementVersion version) {
        PagedCollectionHolder holder = this.verifyingTestCaseManager.findAllByRequirementVersion(version.getId().longValue(), (PagingAndSorting)new DefaultPagingAndSorting("Project.name"));
        return new VerifyingTestCasesTableModelHelper(this.i18nHelper, this.permService).buildDataModel(holder, "0");
    }

    private DataTableModel getLinkedReqVersionsModel(RequirementVersion version) {
        PagedCollectionHolder holder = this.linkedRequirementsManager.findAllByRequirementVersion(version.getId().longValue(), (PagingAndSorting)new DefaultPagingAndSorting("Project.name"));
        return new LinkedRequirementVersionsTableModelHelper(this.i18nHelper).buildDataModel(holder, "0");
    }

    private DataTableModel getEventsTableModel(Requirement requirement) {
        Page auditTrail = this.auditTrailService.findAllByRequirementVersionIdOrderedByDate(requirement.getCurrentVersion().getId().longValue(), SpringPaginationUtils.defaultPaging((String)"date"));
        RequirementAuditEventTableModelBuilder builder = new RequirementAuditEventTableModelBuilder(LocaleContextHolder.getLocale(), this.i18nHelper);
        return builder.buildDataModel(auditTrail, "");
    }

    private static String internationalize(Level level, Locale locale, Provider<LevelLabelFormatter> levelFormatterProvider) {
        return ((LevelLabelFormatter)levelFormatterProvider.get()).useLocale(locale).formatLabel(level);
    }

    private static final class RequirementVersionDataTableModel
    extends DataTableModelBuilder<RequirementVersion> {
        private Locale locale;
        private Provider<LevelLabelFormatter> levelFormatterProvider;
        private InternationalizationHelper i18nHelper;

        private RequirementVersionDataTableModel(Locale locale, Provider<LevelLabelFormatter> levelFormatterProvider, InternationalizationHelper helper) {
            this.locale = locale;
            this.levelFormatterProvider = levelFormatterProvider;
            this.i18nHelper = helper;
        }

        public Map<String, Object> buildItemData(RequirementVersion version) {
            HashMap<String, Object> row = new HashMap<String, Object>(7);
            row.put("entity-id", version.getId());
            row.put("version-number", version.getVersionNumber());
            row.put(RequirementVersionManagerController.REFERENCE, HtmlUtils.htmlEscape((String)version.getReference()));
            row.put("name", HtmlUtils.htmlEscape((String)version.getName()));
            row.put(RequirementVersionManagerController.STATUS, RequirementVersionManagerController.internationalize((Level)version.getStatus(), this.locale, (Provider<LevelLabelFormatter>)this.levelFormatterProvider));
            row.put(RequirementVersionManagerController.CRITICALITY, RequirementVersionManagerController.internationalize((Level)version.getCriticality(), this.locale, (Provider<LevelLabelFormatter>)this.levelFormatterProvider));
            row.put(RequirementVersionManagerController.CATEGORY, this.i18nHelper.getMessage(version.getCategory().getLabel(), null, version.getCategory().getLabel(), this.locale));
            row.put("milestone-dates", MilestoneModelUtils.timeIntervalToString(version.getMilestones(), this.i18nHelper, this.locale));
            row.put("milestone", HtmlUtils.htmlEscape((String)MilestoneModelUtils.milestoneLabelsOrderByDate(version.getMilestones())));
            return row;
        }
    }
}

