/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.requirement;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.service.requirement.RequirementVersionLinkTypeManagerService;

@Controller
@RequestMapping(value={"/requirement-link-type"})
public class RequirementVersionLinkTypeController {
    public static final String LINK_TYPE_ID_MAPPING = "/{linkTypeId}";
    public static final String VALUE = "value";
    @Inject
    private RequirementVersionLinkTypeManagerService linkTypeManagerService;

    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @RequestMapping(method={RequestMethod.POST})
    public void addLinkType(@Valid @ModelAttribute RequirementVersionLinkType newLinkType) {
        this.linkTypeManagerService.addLinkType(newLinkType);
    }

    @ResponseBody
    @RequestMapping(value={"/check-codes"}, method={RequestMethod.GET}, produces={"application/json"})
    public Map<String, Object> doesLinkTypeCodesExist(@Valid @ModelAttribute RequirementVersionLinkType linkType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("code1Exists", this.linkTypeManagerService.doesLinkTypeCodeAlreadyExist(linkType.getRole1Code()));
        resultMap.put("code2Exists", this.linkTypeManagerService.doesLinkTypeCodeAlreadyExist(linkType.getRole2Code()));
        resultMap.put("areCodesAndRolesConsistent", this.linkTypeManagerService.areCodesAndRolesConsistent(linkType));
        return resultMap;
    }

    @ResponseBody
    @RequestMapping(value={"/{linkTypeId}"}, method={RequestMethod.POST}, params={"id=requirement-link-type-default"})
    public void changeDefault(@PathVariable Long linkTypeId) {
        this.linkTypeManagerService.changeDefault(linkTypeId);
    }

    @ResponseBody
    @RequestMapping(value={"/{linkTypeId}"}, method={RequestMethod.POST}, params={"id=requirement-link-type-role1", "value"})
    public Map<String, Boolean> changeRole1(@PathVariable Long linkTypeId, @RequestParam(value="value") String newRole1) {
        return this.linkTypeManagerService.changeRole1(linkTypeId, newRole1);
    }

    @ResponseBody
    @RequestMapping(value={"/{linkTypeId}"}, method={RequestMethod.POST}, params={"id=requirement-link-type-role2", "value"})
    public Map<String, Boolean> changeRole2(@PathVariable Long linkTypeId, @RequestParam(value="value") String newRole2) {
        return this.linkTypeManagerService.changeRole2(linkTypeId, newRole2);
    }

    @ResponseBody
    @RequestMapping(value={"/{linkTypeId}"}, method={RequestMethod.POST}, params={"id=requirement-link-type-code1", "value"})
    public Map<String, Boolean> changeCode1(@PathVariable Long linkTypeId, @RequestParam(value="value") String newCode1) {
        return this.linkTypeManagerService.changeCode1(linkTypeId, newCode1);
    }

    @ResponseBody
    @RequestMapping(value={"/{linkTypeId}"}, method={RequestMethod.POST}, params={"id=requirement-link-type-code2", "value"})
    public Map<String, Boolean> changeCode2(@PathVariable Long linkTypeId, @RequestParam(value="value") String codeRole2) {
        return this.linkTypeManagerService.changeCode2(linkTypeId, codeRole2);
    }

    @ResponseBody
    @RequestMapping(value={"/{linkTypeId}"}, method={RequestMethod.GET}, produces={"application/json"}, params={"id=check-code", "value"})
    public Map<String, Object> doesLinkTypeCodeAlreadyExist(@PathVariable Long linkTypeId, @RequestParam(value="value") String code) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
        resultMap.put("codeExists", this.linkTypeManagerService.doesLinkTypeCodeAlreadyExist(code, linkTypeId));
        return resultMap;
    }

    @ResponseBody
    @RequestMapping(value={"/{linkTypeId}"}, method={RequestMethod.GET}, produces={"application/json"}, params={"id=isDefault"})
    public Map<String, Object> isLinkTypeDefault(@PathVariable Long linkTypeId) {
        HashedMap resultMap = new HashedMap(1);
        resultMap.put("isTypeDefault", this.linkTypeManagerService.isLinkTypeDefault(linkTypeId));
        return resultMap;
    }

    @ResponseBody
    @RequestMapping(value={"/{linkTypeId}"}, method={RequestMethod.GET}, produces={"application/json"}, params={"id=isUsed"})
    public Map<String, Object> isLinkTypeUsed(@PathVariable Long linkTypeId) {
        HashedMap resultMap = new HashedMap(1);
        resultMap.put("isLinkTypeUsed", this.linkTypeManagerService.isLinkTypeUsed(linkTypeId));
        return resultMap;
    }

    @ResponseBody
    @RequestMapping(value={"/{linkTypeId}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public void deleteLinkType(@PathVariable Long linkTypeId) {
        this.linkTypeManagerService.deleteLinkType(linkTypeId);
    }

    @ResponseBody
    @RequestMapping(value={"/{linkTypeIdsToDelete}"}, method={RequestMethod.DELETE})
    public void deleteLinkTypes(@PathVariable List<Long> linkTypeIdsToDelete) {
        this.linkTypeManagerService.deleteLinkTypes(linkTypeIdsToDelete);
    }

    @ResponseBody
    @RequestMapping(value={"/{linkTypesIdsToCheck}"}, method={RequestMethod.GET}, params={"id=doesContainDefault"})
    public Map<String, Object> doesLinkTypesContainDefault(@PathVariable List<Long> linkTypesIdsToCheck) {
        HashedMap resultMap = new HashedMap(1);
        resultMap.put("containsDefault", this.linkTypeManagerService.doesContainDefault(linkTypesIdsToCheck));
        return resultMap;
    }
}

